/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.connect;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.File;
import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.cli.commands.tools.PrintData;
import org.apache.activemq.artemis.core.config.CoreAddressConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPMirrorBrokerConnectionElement;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.LastValueQueue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.selector.filter.Filterable;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.utils.StringPrintStream;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerInSyncTest
extends AmqpClientTestSupport {
    protected static final int AMQP_PORT_2 = 5673;
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    ActiveMQServer server_2;
    private AssertionLoggerHandler loggerHandler;

    @AfterEach
    public void stopServer1() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @AfterEach
    public void stopServer2() throws Exception {
        if (this.server_2 != null) {
            this.server_2.stop();
        }
    }

    @BeforeEach
    public void startLogging() {
        this.loggerHandler = new AssertionLoggerHandler();
    }

    @AfterEach
    public void stopLogging() throws Exception {
        try {
            Assertions.assertFalse((boolean)this.loggerHandler.findText(new String[]{"AMQ222214"}));
        }
        finally {
            this.loggerHandler.close();
        }
    }

    @Override
    protected ActiveMQServer createServer() throws Exception {
        return this.createServer(5672, false);
    }

    @Test
    public void testSyncOnCreateQueues() throws Exception {
        this.server.setIdentity("Server1");
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("connectTowardsServer2", "tcp://localhost:5673").setReconnectAttempts(3).setRetryInterval(100);
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement().setDurable(true));
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.server.start();
        this.server_2 = this.createServer(5673, false);
        this.server_2.setIdentity("Server2");
        amqpConnection = new AMQPBrokerConnectConfiguration("connectTowardsServer1", "tcp://localhost:5672").setReconnectAttempts(-1).setRetryInterval(100);
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement().setDurable(true));
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server_2.start();
        this.server_2.addAddressInfo(new AddressInfo("sometest").setAutoCreated(false));
        this.server_2.createQueue(QueueConfiguration.of((String)"sometest").setDurable(Boolean.valueOf(true)));
        Wait.assertTrue(() -> this.server_2.locateQueue("sometest") != null);
        Wait.assertTrue(() -> this.server.locateQueue("sometest") != null);
        this.server.addAddressInfo(new AddressInfo("OnServer1").setAutoCreated(false));
        this.server.createQueue(QueueConfiguration.of((String)"OnServer1").setDurable(Boolean.valueOf(true)));
        Wait.assertTrue(() -> this.server.locateQueue("OnServer1") != null);
        Wait.assertTrue((String)"Sync is not working on the way back", () -> this.server_2.locateQueue("OnServer1") != null, (long)2000L);
        Wait.assertTrue(() -> this.server_2.locateQueue("sometest") != null);
        Wait.assertTrue(() -> this.server.locateQueue("sometest") != null);
        for (int i = 0; i < 10; ++i) {
            int queueID = i;
            this.server_2.createQueue(QueueConfiguration.of((String)("test2_" + i)).setDurable(Boolean.valueOf(true)));
            this.server.createQueue(QueueConfiguration.of((String)("test1_" + i)).setDurable(Boolean.valueOf(true)));
            Wait.assertTrue(() -> this.server.locateQueue("test2_" + queueID) != null);
            Wait.assertTrue(() -> this.server.locateQueue("test1_" + queueID) != null);
            Wait.assertTrue(() -> this.server_2.locateQueue("test2_" + queueID) != null);
            Wait.assertTrue(() -> this.server_2.locateQueue("test1_" + queueID) != null);
        }
        this.server_2.stop();
        this.server.stop();
    }

    @Test
    public void testSingleMessage() throws Exception {
        this.server.setIdentity("Server1");
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("connectTowardsServer2", "tcp://localhost:5673").setReconnectAttempts(3).setRetryInterval(100);
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement().setDurable(true));
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.server.start();
        this.server_2 = this.createServer(5673, false);
        this.server_2.setIdentity("Server2");
        amqpConnection = new AMQPBrokerConnectConfiguration("connectTowardsServer1", "tcp://localhost:5672").setReconnectAttempts(-1).setRetryInterval(100);
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement().setDurable(true));
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server_2.start();
        this.server_2.addAddressInfo(new AddressInfo(this.getQueueName()).setAutoCreated(false).addRoutingType(RoutingType.ANYCAST));
        this.server_2.createQueue(QueueConfiguration.of((String)this.getQueueName()).setDurable(Boolean.valueOf(true)).setRoutingType(RoutingType.ANYCAST));
        Wait.assertTrue(() -> this.server_2.locateQueue(this.getQueueName()) != null);
        Wait.assertTrue(() -> this.server.locateQueue(this.getQueueName()) != null);
        ConnectionFactory cf1 = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
        Connection connection1 = cf1.createConnection();
        Session session1 = connection1.createSession(true, 0);
        connection1.start();
        ConnectionFactory cf2 = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5673");
        Connection connection2 = cf2.createConnection();
        Session session2 = connection2.createSession(true, 0);
        connection2.start();
        jakarta.jms.Queue queue = session1.createQueue(this.getQueueName());
        MessageProducer producerServer1 = session1.createProducer((Destination)queue);
        MessageProducer producerServer2 = session2.createProducer((Destination)queue);
        TextMessage message = session1.createTextMessage("test");
        message.setIntProperty("i", 0);
        message.setStringProperty("server", this.server.getIdentity());
        producerServer1.send((Message)message);
        session1.commit();
        Queue queueOnServer1 = this.server.locateQueue(this.getQueueName());
        Queue queueOnServer2 = this.server_2.locateQueue(this.getQueueName());
        Assertions.assertNotNull((Object)queueOnServer1);
        Assertions.assertNotNull((Object)queueOnServer2);
        Wait.assertEquals((long)1L, () -> ((Queue)queueOnServer1).getMessageCount());
        Wait.assertEquals((long)1L, () -> ((Queue)queueOnServer2).getMessageCount());
        message = session1.createTextMessage("test");
        message.setIntProperty("i", 1);
        message.setStringProperty("server", this.server_2.getIdentity());
        producerServer2.send((Message)message);
        session2.commit();
        if (logger.isDebugEnabled() && !Wait.waitFor(() -> queueOnServer1.getMessageCount() == 2L)) {
            this.debugData();
        }
        Wait.assertEquals((long)2L, () -> ((Queue)queueOnServer1).getMessageCount());
        Wait.assertEquals((long)2L, () -> ((Queue)queueOnServer2).getMessageCount());
        connection1.close();
        connection2.close();
        this.server_2.stop();
        this.server.stop();
    }

    private Queue locateQueueWithWait(ActiveMQServer server, String queueName) throws Exception {
        Wait.assertTrue(() -> server.locateQueue(queueName) != null);
        Queue queue = server.locateQueue(queueName);
        Assertions.assertNotNull((Object)queue);
        return queue;
    }

    @Test
    public void testExpiryNoReaper() throws Exception {
        this.internalExpiry(false);
    }

    @Test
    public void testExpiry() throws Exception {
        this.internalExpiry(true);
    }

    private void internalExpiry(boolean useReaper) throws Exception {
        this.server.setIdentity("Server1");
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("to_2", "tcp://localhost:5673").setReconnectAttempts(3).setRetryInterval(100);
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement().setDurable(true));
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.server.getConfiguration().addAddressSetting("#", new AddressSettings().setExpiryAddress(SimpleString.of((String)"expiryQueue")));
        this.server.getConfiguration().addAddressConfiguration(new CoreAddressConfiguration().setName("expiryQueue"));
        this.server.getConfiguration().addQueueConfiguration(QueueConfiguration.of((String)"expiryQueue").setRoutingType(RoutingType.ANYCAST));
        if (!useReaper) {
            this.server.getConfiguration().setMessageExpiryScanPeriod(-1L);
        }
        this.server.start();
        this.server_2 = this.createServer(5673, false);
        this.server.getConfiguration().addAddressConfiguration(new CoreAddressConfiguration().setName("expiryQueue"));
        this.server.getConfiguration().addQueueConfiguration(QueueConfiguration.of((String)"expiryQueue").setRoutingType(RoutingType.ANYCAST));
        if (!useReaper) {
            this.server_2.getConfiguration().setMessageExpiryScanPeriod(-1L);
        }
        this.server_2.setIdentity("Server2");
        amqpConnection = new AMQPBrokerConnectConfiguration("to_1", "tcp://localhost:5672").setReconnectAttempts(-1).setRetryInterval(100);
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement().setDurable(true));
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server_2.getConfiguration().addAddressSetting("#", new AddressSettings().setExpiryAddress(SimpleString.of((String)"expiryQueue")));
        this.server_2.start();
        Queue to1 = this.locateQueueWithWait(this.server_2, "$ACTIVEMQ_ARTEMIS_MIRROR_to_1");
        Queue to2 = this.locateQueueWithWait(this.server, "$ACTIVEMQ_ARTEMIS_MIRROR_to_2");
        Queue expiry1 = this.locateQueueWithWait(this.server, "expiryQueue");
        Queue expiry2 = this.locateQueueWithWait(this.server_2, "expiryQueue");
        this.server_2.addAddressInfo(new AddressInfo(this.getQueueName()).setAutoCreated(false).addRoutingType(RoutingType.ANYCAST));
        this.server_2.createQueue(QueueConfiguration.of((String)this.getQueueName()).setDurable(Boolean.valueOf(true)).setRoutingType(RoutingType.ANYCAST));
        Queue queueOnServer1 = this.locateQueueWithWait(this.server, this.getQueueName());
        Queue queueOnServer2 = this.locateQueueWithWait(this.server_2, this.getQueueName());
        ConnectionFactory cf1 = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
        Connection connection1 = cf1.createConnection();
        Session session1 = connection1.createSession(true, 0);
        connection1.start();
        jakarta.jms.Queue queue = session1.createQueue(this.getQueueName());
        MessageProducer producerServer1 = session1.createProducer((Destination)queue);
        producerServer1.setTimeToLive(1000L);
        TextMessage message = session1.createTextMessage("test");
        message.setIntProperty("i", 0);
        message.setStringProperty("server", this.server.getIdentity());
        producerServer1.send((Message)message);
        session1.commit();
        Wait.assertEquals((Long)1L, () -> ((Queue)queueOnServer1).getMessageCount(), (long)1000L, (long)100L);
        Wait.assertEquals((Long)1L, () -> ((Queue)queueOnServer2).getMessageCount(), (long)1000L, (long)100L);
        if (useReaper) {
            to1.pause();
            to2.pause();
        }
        Thread.sleep(1500L);
        if (!useReaper) {
            queueOnServer1.expireReferences();
        }
        Wait.assertEquals((Long)0L, () -> ((Queue)queueOnServer1).getMessageCount(), (long)2000L, (long)100L);
        Wait.assertEquals((Long)0L, () -> ((Queue)queueOnServer2).getMessageCount(), (long)2000L, (long)100L);
        Wait.assertEquals((Long)1L, () -> ((Queue)expiry1).getMessageCount(), (long)1000L, (long)100L);
        Wait.assertEquals((Long)1L, () -> ((Queue)expiry2).getMessageCount(), (long)1000L, (long)100L);
        to1.resume();
        to2.resume();
        if (!useReaper) {
            queueOnServer1.expireReferences();
        }
        Wait.assertEquals((Long)1L, () -> ((Queue)expiry1).getMessageCount(), (long)1000L, (long)100L);
        Wait.assertEquals((Long)1L, () -> ((Queue)expiry2).getMessageCount(), (long)1000L, (long)100L);
        connection1.close();
        this.server_2.stop();
        this.server.stop();
    }

    @Test
    public void testDLA() throws Exception {
        this.server.setIdentity("Server1");
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("to_2", "tcp://localhost:5673").setReconnectAttempts(3).setRetryInterval(100);
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement().setDurable(true));
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.server.getConfiguration().addAddressSetting("#", new AddressSettings().setDeadLetterAddress(SimpleString.of((String)"deadLetterQueue")).setMaxDeliveryAttempts(2));
        this.server.getConfiguration().addAddressConfiguration(new CoreAddressConfiguration().setName("deadLetterQueue"));
        this.server.getConfiguration().addQueueConfiguration(QueueConfiguration.of((String)"deadLetterQueue").setRoutingType(RoutingType.ANYCAST));
        this.server.getConfiguration().setMessageExpiryScanPeriod(-1L);
        this.server.start();
        this.server_2 = this.createServer(5673, false);
        this.server.getConfiguration().addAddressConfiguration(new CoreAddressConfiguration().setName("deadLetterQueue"));
        this.server.getConfiguration().addQueueConfiguration(QueueConfiguration.of((String)"deadLetterQueue").setRoutingType(RoutingType.ANYCAST));
        this.server_2.getConfiguration().setMessageExpiryScanPeriod(-1L);
        this.server_2.setIdentity("Server2");
        amqpConnection = new AMQPBrokerConnectConfiguration("to_1", "tcp://localhost:5672").setReconnectAttempts(-1).setRetryInterval(100);
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement().setDurable(true));
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server_2.getConfiguration().addAddressSetting("#", new AddressSettings().setDeadLetterAddress(SimpleString.of((String)"deadLetterQueue")).setMaxDeliveryAttempts(2));
        this.server_2.start();
        Queue to1 = this.locateQueueWithWait(this.server_2, "$ACTIVEMQ_ARTEMIS_MIRROR_to_1");
        Queue to2 = this.locateQueueWithWait(this.server, "$ACTIVEMQ_ARTEMIS_MIRROR_to_2");
        Queue dlq1 = this.locateQueueWithWait(this.server, "deadLetterQueue");
        Queue dlq2 = this.locateQueueWithWait(this.server_2, "deadLetterQueue");
        this.server_2.addAddressInfo(new AddressInfo(this.getQueueName()).setAutoCreated(false).addRoutingType(RoutingType.ANYCAST));
        this.server_2.createQueue(QueueConfiguration.of((String)this.getQueueName()).setDurable(Boolean.valueOf(true)).setRoutingType(RoutingType.ANYCAST));
        Queue queueOnServer1 = this.locateQueueWithWait(this.server, this.getQueueName());
        Queue queueOnServer2 = this.locateQueueWithWait(this.server_2, this.getQueueName());
        ConnectionFactory cf1 = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
        Connection connection1 = cf1.createConnection();
        Session session1 = connection1.createSession(true, 0);
        connection1.start();
        jakarta.jms.Queue queue = session1.createQueue(this.getQueueName());
        MessageProducer producerServer1 = session1.createProducer((Destination)queue);
        TextMessage message = session1.createTextMessage("test");
        message.setIntProperty("i", 0);
        message.setStringProperty("server", this.server.getIdentity());
        producerServer1.send((Message)message);
        session1.commit();
        MessageConsumer consumer1 = session1.createConsumer((Destination)queue);
        connection1.start();
        for (int i = 0; i < 2; ++i) {
            TextMessage messageToCancel = (TextMessage)consumer1.receive(1000L);
            Assertions.assertNotNull((Object)messageToCancel);
            session1.rollback();
        }
        Assertions.assertNull((Object)consumer1.receiveNoWait());
        Wait.assertEquals((Long)0L, () -> ((Queue)queueOnServer1).getMessageCount(), (long)1000L, (long)100L);
        Wait.assertEquals((Long)0L, () -> ((Queue)queueOnServer2).getMessageCount(), (long)1000L, (long)100L);
        Wait.assertEquals((Long)1L, () -> ((Queue)dlq1).getMessageCount(), (long)1000L, (long)100L);
        Wait.assertEquals((Long)1L, () -> ((Queue)dlq2).getMessageCount(), (long)1000L, (long)100L);
        dlq1.retryMessages(new Filter(){

            public boolean match(org.apache.activemq.artemis.api.core.Message message) {
                return true;
            }

            public boolean match(Map<String, String> map) {
                return true;
            }

            public boolean match(Filterable filterable) {
                return true;
            }

            public SimpleString getFilterString() {
                return SimpleString.of((String)"Test");
            }
        });
        Wait.assertEquals((Long)1L, () -> ((Queue)queueOnServer1).getMessageCount(), (long)1000L, (long)100L);
        Wait.assertEquals((Long)1L, () -> ((Queue)queueOnServer2).getMessageCount(), (long)1000L, (long)100L);
        Wait.assertEquals((Long)0L, () -> ((Queue)dlq1).getMessageCount(), (long)1000L, (long)100L);
        Wait.assertEquals((Long)0L, () -> ((Queue)dlq2).getMessageCount(), (long)1000L, (long)100L);
        connection1.close();
        this.server_2.stop();
        this.server.stop();
    }

    @Test
    public void testCreateInternalQueue() throws Exception {
        this.server.setIdentity("Server1");
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("to_2", "tcp://localhost:5673").setReconnectAttempts(3).setRetryInterval(100);
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement().setDurable(true));
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.server.getConfiguration().addAddressSetting("#", new AddressSettings().setDeadLetterAddress(SimpleString.of((String)"deadLetterQueue")).setMaxDeliveryAttempts(2));
        this.server.getConfiguration().addAddressConfiguration(new CoreAddressConfiguration().setName("deadLetterQueue"));
        this.server.getConfiguration().addQueueConfiguration(QueueConfiguration.of((String)"deadLetterQueue").setRoutingType(RoutingType.ANYCAST));
        this.server.getConfiguration().setMessageExpiryScanPeriod(-1L);
        this.server.start();
        this.server_2 = this.createServer(5673, false);
        this.server.getConfiguration().addAddressConfiguration(new CoreAddressConfiguration().setName("deadLetterQueue"));
        this.server.getConfiguration().addQueueConfiguration(QueueConfiguration.of((String)"deadLetterQueue").setRoutingType(RoutingType.ANYCAST));
        this.server_2.getConfiguration().setMessageExpiryScanPeriod(-1L);
        this.server_2.setIdentity("Server2");
        amqpConnection = new AMQPBrokerConnectConfiguration("to_1", "tcp://localhost:5672").setReconnectAttempts(-1).setRetryInterval(100);
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement().setDurable(true));
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server_2.getConfiguration().addAddressSetting("#", new AddressSettings().setDeadLetterAddress(SimpleString.of((String)"deadLetterQueue")).setMaxDeliveryAttempts(2));
        this.server_2.start();
        Queue to1 = this.locateQueueWithWait(this.server_2, "$ACTIVEMQ_ARTEMIS_MIRROR_to_1");
        Assertions.assertNotNull((Object)to1);
        long messagesAddedOnS2 = to1.getMessagesAdded();
        String internalQueueName = this.getQueueName() + "Internal";
        this.server.addAddressInfo(new AddressInfo(internalQueueName).setAutoCreated(false).addRoutingType(RoutingType.ANYCAST).setInternal(true));
        this.server.createQueue(QueueConfiguration.of((String)internalQueueName).setDurable(Boolean.valueOf(true)).setRoutingType(RoutingType.ANYCAST).setInternal(Boolean.valueOf(true)));
        this.server.addAddressInfo(new AddressInfo(this.getQueueName()).setAutoCreated(false).addRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((String)this.getQueueName()).setDurable(Boolean.valueOf(true)).setRoutingType(RoutingType.ANYCAST));
        Wait.assertTrue(() -> this.server_2.locateQueue(this.getQueueName()) != null, (long)5000L);
        Assertions.assertTrue((this.server_2.getAddressInfo(SimpleString.of((String)internalQueueName)) == null ? 1 : 0) != 0);
        Assertions.assertTrue((this.server_2.locateQueue(internalQueueName) == null ? 1 : 0) != 0);
        Assertions.assertEquals((long)messagesAddedOnS2, (long)to1.getMessagesAdded());
        this.server_2.stop();
        this.server.stop();
    }

    @Test
    public void testLVQ() throws Exception {
        AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();
        this.runAfter(() -> loggerHandler.close());
        this.server.setIdentity("Server1");
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("to_2", "tcp://localhost:5673").setReconnectAttempts(3).setRetryInterval(100);
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement().setDurable(true));
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.server.getConfiguration().addAddressSetting("#", new AddressSettings().setDeadLetterAddress(SimpleString.of((String)"deadLetterQueue")).setMaxDeliveryAttempts(2));
        this.server.getConfiguration().addAddressConfiguration(new CoreAddressConfiguration().setName("deadLetterQueue"));
        this.server.getConfiguration().addQueueConfiguration(QueueConfiguration.of((String)"deadLetterQueue").setRoutingType(RoutingType.ANYCAST));
        String lvqName = "testLVQ_" + RandomUtil.randomString();
        this.server.getConfiguration().addAddressConfiguration(new CoreAddressConfiguration().setName(lvqName));
        this.server.getConfiguration().addQueueConfiguration(QueueConfiguration.of((String)lvqName).setRoutingType(RoutingType.ANYCAST).setLastValue(Boolean.valueOf(true)).setLastValueKey("KEY"));
        this.server.getConfiguration().setMessageExpiryScanPeriod(-1L);
        this.server.start();
        this.server_2 = this.createServer(5673, false);
        this.server.getConfiguration().addAddressConfiguration(new CoreAddressConfiguration().setName("deadLetterQueue"));
        this.server.getConfiguration().addQueueConfiguration(QueueConfiguration.of((String)"deadLetterQueue").setRoutingType(RoutingType.ANYCAST));
        this.server_2.getConfiguration().setMessageExpiryScanPeriod(-1L);
        this.server_2.setIdentity("Server2");
        AMQPBrokerConnectConfiguration amqpConnection2 = new AMQPBrokerConnectConfiguration("to_1", "tcp://localhost:5672").setReconnectAttempts(-1).setRetryInterval(100);
        amqpConnection2.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement().setDurable(true));
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection2);
        this.server_2.getConfiguration().addAddressSetting("#", new AddressSettings().setDeadLetterAddress(SimpleString.of((String)"deadLetterQueue")).setMaxDeliveryAttempts(2));
        this.server_2.start();
        Queue lvqQueue1 = this.locateQueueWithWait(this.server, lvqName);
        Queue lvqQueue2 = this.locateQueueWithWait(this.server, lvqName);
        Assertions.assertTrue((boolean)lvqQueue1.isLastValue());
        Assertions.assertTrue((boolean)lvqQueue2.isLastValue());
        Assertions.assertTrue((boolean)(lvqQueue1 instanceof LastValueQueue));
        Assertions.assertTrue((boolean)(lvqQueue2 instanceof LastValueQueue));
        Assertions.assertEquals((Object)"KEY", (Object)lvqQueue1.getQueueConfiguration().getLastValueKey().toString());
        Assertions.assertEquals((Object)"KEY", (Object)lvqQueue2.getQueueConfiguration().getLastValueKey().toString());
        ConnectionFactory cf1 = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
        try (Connection connection1 = cf1.createConnection();){
            Session session1 = connection1.createSession(false, 1);
            jakarta.jms.Queue queue = session1.createQueue(lvqName);
            MessageProducer producerServer1 = session1.createProducer((Destination)queue);
            connection1.start();
            for (int i = 0; i < 1000; ++i) {
                TextMessage message = session1.createTextMessage("test");
                message.setIntProperty("i", 0);
                message.setStringProperty("KEY", "" + i % 10);
                producerServer1.send((Message)message);
            }
        }
        Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ222214"}));
        Wait.assertEquals((Long)10L, () -> ((Queue)lvqQueue1).getMessageCount(), (long)2000L, (long)100L);
        Wait.assertEquals((Long)10L, () -> ((Queue)lvqQueue2).getMessageCount(), (long)2000L, (long)100L);
        this.server_2.stop();
        this.server.stop();
        Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ222153"}));
    }

    @Test
    public void testSyncData() throws Exception {
        int NUMBER_OF_MESSAGES = 100;
        this.server.setIdentity("Server1");
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("connectTowardsServer2", "tcp://localhost:5673").setReconnectAttempts(3).setRetryInterval(100);
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement().setDurable(true));
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.server.start();
        this.server_2 = this.createServer(5673, false);
        this.server_2.setIdentity("Server2");
        amqpConnection = new AMQPBrokerConnectConfiguration("connectTowardsServer1", "tcp://localhost:5672").setReconnectAttempts(-1).setRetryInterval(100);
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement().setDurable(true));
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server_2.start();
        this.server_2.addAddressInfo(new AddressInfo(this.getQueueName()).setAutoCreated(false).addRoutingType(RoutingType.ANYCAST));
        this.server_2.createQueue(QueueConfiguration.of((String)this.getQueueName()).setDurable(Boolean.valueOf(true)).setRoutingType(RoutingType.ANYCAST));
        Wait.assertTrue(() -> this.server_2.locateQueue(this.getQueueName()) != null);
        Wait.assertTrue(() -> this.server.locateQueue(this.getQueueName()) != null);
        ConnectionFactory cf1 = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
        Connection connection1 = cf1.createConnection();
        Session session1 = connection1.createSession(true, 0);
        connection1.start();
        ConnectionFactory cf2 = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5673");
        Connection connection2 = cf2.createConnection();
        Session session2 = connection2.createSession(true, 0);
        connection2.start();
        jakarta.jms.Queue queue = session1.createQueue(this.getQueueName());
        MessageProducer producerServer1 = session1.createProducer((Destination)queue);
        MessageProducer producerServer2 = session2.createProducer((Destination)queue);
        for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            TextMessage message = session1.createTextMessage("test " + i);
            message.setIntProperty("i", i);
            message.setStringProperty("server", this.server.getIdentity());
            producerServer1.send((Message)message);
        }
        session1.commit();
        Queue queueOnServer1 = this.server.locateQueue(this.getQueueName());
        Queue queueOnServer2 = this.server_2.locateQueue(this.getQueueName());
        Assertions.assertNotNull((Object)queueOnServer1);
        Assertions.assertNotNull((Object)queueOnServer2);
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queueOnServer1).getMessageCount());
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queueOnServer2).getMessageCount());
        for (int i = NUMBER_OF_MESSAGES; i < NUMBER_OF_MESSAGES * 2; ++i) {
            TextMessage message = session1.createTextMessage("test " + i);
            message.setIntProperty("i", i);
            message.setStringProperty("server", this.server_2.getIdentity());
            producerServer2.send((Message)message);
        }
        session2.commit();
        if (logger.isDebugEnabled() && !Wait.waitFor(() -> queueOnServer1.getMessageCount() == (long)(NUMBER_OF_MESSAGES * 2))) {
            this.debugData();
        }
        Wait.assertEquals((long)(NUMBER_OF_MESSAGES * 2), () -> ((Queue)queueOnServer1).getMessageCount());
        Wait.assertEquals((long)(NUMBER_OF_MESSAGES * 2), () -> ((Queue)queueOnServer2).getMessageCount());
        MessageConsumer consumerOn1 = session1.createConsumer((Destination)queue);
        for (int i = 0; i < NUMBER_OF_MESSAGES * 2; ++i) {
            TextMessage message = (TextMessage)consumerOn1.receive(5000L);
            logger.debug("### Client acking message({}) on server 1, a message that was original sent on {} text = {}", new Object[]{i, message.getStringProperty("server"), message.getText()});
            Assertions.assertNotNull((Object)message);
            Assertions.assertEquals((int)i, (int)message.getIntProperty("i"));
            Assertions.assertEquals((Object)("test " + i), (Object)message.getText());
            session1.commit();
        }
        boolean bothConsumed = Wait.waitFor(() -> {
            long q1 = queueOnServer1.getMessageCount();
            long q2 = queueOnServer2.getMessageCount();
            logger.debug("Queue on Server 1 = {}", (Object)q1);
            logger.debug("Queue on Server 2 = {}", (Object)q2);
            return q1 == 0L && q2 == 0L;
        }, (long)5000L, (long)1000L);
        if (logger.isDebugEnabled() && !bothConsumed) {
            this.debugData();
            Assertions.fail((String)("q1 = " + queueOnServer1.getMessageCount() + ", q2 = " + queueOnServer2.getMessageCount()));
        }
        Assertions.assertEquals((long)0L, (long)queueOnServer1.getMessageCount());
        Assertions.assertEquals((int)0, (int)queueOnServer2.getConsumerCount());
        System.out.println("Queue on Server 1 = " + queueOnServer1.getMessageCount());
        System.out.println("Queue on Server 2 = " + queueOnServer2.getMessageCount());
        Assertions.assertEquals((int)0, (int)queueOnServer1.getDeliveringCount());
        Assertions.assertEquals((int)0, (int)queueOnServer2.getDeliveringCount());
        Assertions.assertEquals((int)0, (int)queueOnServer1.getDurableDeliveringCount());
        Assertions.assertEquals((int)0, (int)queueOnServer2.getDurableDeliveringCount());
        Assertions.assertEquals((long)0L, (long)queueOnServer1.getDurableDeliveringSize());
        Assertions.assertEquals((long)0L, (long)queueOnServer2.getDurableDeliveringSize());
        Assertions.assertEquals((long)0L, (long)queueOnServer1.getDeliveringSize());
        Assertions.assertEquals((long)0L, (long)queueOnServer2.getDeliveringSize());
        this.server_2.stop();
        this.server.stop();
    }

    @Test
    public void testStats() throws Exception {
        int NUMBER_OF_MESSAGES = 1;
        this.server.setIdentity("Server1");
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("connectTowardsServer2", "tcp://localhost:5673").setReconnectAttempts(3).setRetryInterval(100);
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement().setDurable(true));
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.server.start();
        this.server_2 = this.createServer(5673, false);
        this.server_2.setIdentity("Server2");
        amqpConnection = new AMQPBrokerConnectConfiguration("connectTowardsServer1", "tcp://localhost:5672").setReconnectAttempts(-1).setRetryInterval(100);
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement().setDurable(true));
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server_2.start();
        this.server_2.addAddressInfo(new AddressInfo(this.getQueueName()).setAutoCreated(false).addRoutingType(RoutingType.ANYCAST));
        this.server_2.createQueue(QueueConfiguration.of((String)this.getQueueName()).setDurable(Boolean.valueOf(true)).setRoutingType(RoutingType.ANYCAST));
        Wait.assertTrue(() -> this.server_2.locateQueue(this.getQueueName()) != null);
        Wait.assertTrue(() -> this.server.locateQueue(this.getQueueName()) != null, (long)5000L);
        ConnectionFactory cf1 = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
        Connection connection1 = cf1.createConnection();
        Session session1 = connection1.createSession(true, 0);
        connection1.start();
        ConnectionFactory cf2 = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5673");
        Connection connection2 = cf2.createConnection();
        Session session2 = connection2.createSession(true, 0);
        connection2.start();
        jakarta.jms.Queue queue = session1.createQueue(this.getQueueName());
        MessageProducer producerServer1 = session1.createProducer((Destination)queue);
        MessageProducer producerServer2 = session2.createProducer((Destination)queue);
        for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            TextMessage message = session1.createTextMessage("test " + i);
            message.setIntProperty("i", i);
            message.setStringProperty("server", this.server.getIdentity());
            producerServer1.send((Message)message);
        }
        session1.commit();
        Queue queueOnServer1 = this.server.locateQueue(this.getQueueName());
        Queue queueOnServer2 = this.server_2.locateQueue(this.getQueueName());
        Assertions.assertNotNull((Object)queueOnServer1);
        Assertions.assertNotNull((Object)queueOnServer2);
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queueOnServer1).getMessageCount());
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queueOnServer2).getMessageCount());
        Assertions.assertEquals((long)0L, (long)queueOnServer1.getDeliveringSize());
        Assertions.assertEquals((long)0L, (long)queueOnServer2.getDeliveringSize());
        MessageConsumer consumerOn1 = session1.createConsumer((Destination)queue);
        int i = 0;
        while (i < NUMBER_OF_MESSAGES) {
            TextMessage message = (TextMessage)consumerOn1.receive(5000L);
            logger.debug("### Client acking message({}) on server 1, a message that was original sent on {} text = {}", new Object[]{i, message.getStringProperty("server"), message.getText()});
            Assertions.assertNotNull((Object)message);
            Assertions.assertEquals((int)i, (int)message.getIntProperty("i"));
            Assertions.assertEquals((Object)("test " + i), (Object)message.getText());
            session1.commit();
            int n = i++;
        }
        Wait.assertEquals((Long)0L, () -> ((Queue)queueOnServer1).getMessageCount(), (long)2000L, (long)100L);
        Wait.assertEquals((Long)0L, () -> ((Queue)queueOnServer2).getMessageCount(), (long)2000L, (long)100L);
        Assertions.assertEquals((int)0, (int)queueOnServer1.getDeliveringCount());
        Assertions.assertEquals((int)0, (int)queueOnServer2.getDeliveringCount());
        Assertions.assertEquals((int)0, (int)queueOnServer1.getDurableDeliveringCount());
        Assertions.assertEquals((int)0, (int)queueOnServer2.getDurableDeliveringCount());
        Assertions.assertEquals((long)0L, (long)queueOnServer1.getDurableDeliveringSize());
        Assertions.assertEquals((long)0L, (long)queueOnServer2.getDurableDeliveringSize());
        Assertions.assertEquals((long)0L, (long)queueOnServer1.getDeliveringSize());
        Assertions.assertEquals((long)0L, (long)queueOnServer2.getDeliveringSize());
        this.server_2.stop();
        this.server.stop();
    }

    private void debugData() throws Exception {
        StringPrintStream stringPrintStream = new StringPrintStream();
        PrintStream out = stringPrintStream.newStream();
        Queue queueToDebugOn1 = this.server.locateQueue(this.getQueueName());
        Queue queueToDebugOn2 = this.server_2.locateQueue(this.getQueueName());
        out.println("*******************************************************************************************************************************");
        out.println("Queue on Server 1 with count = " + queueToDebugOn1.getMessageCount());
        queueToDebugOn1.forEach(r -> out.println("Server1 has reference " + r.getMessage()));
        out.println("*******************************************************************************************************************************");
        out.println("Queue on Server 2 with count = " + queueToDebugOn2.getMessageCount());
        queueToDebugOn2.forEach(r -> out.println("Server2 has reference " + r.getMessage()));
        out.println("*******************************************************************************************************************************");
        out.println("PrintData Server 1");
        PrintData.printMessages((File)this.server.getConfiguration().getJournalLocation(), (PrintStream)out, (boolean)false, (boolean)false, (boolean)true, (boolean)false);
        out.println("*******************************************************************************************************************************");
        out.println("PrintData Server 2");
        PrintData.printMessages((File)this.server_2.getConfiguration().getJournalLocation(), (PrintStream)out, (boolean)false, (boolean)false, (boolean)true, (boolean)false);
        logger.debug("Data Available on Servers:\n{}", (Object)stringPrintStream.toString());
    }

    @Test
    public void testSyncDataNoSuppliedID() throws Exception {
        int NUMBER_OF_MESSAGES = 100;
        this.server.setIdentity("Server1");
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("connectTowardsServer2", "tcp://localhost:5673").setReconnectAttempts(3).setRetryInterval(100);
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement().setDurable(true));
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.server.start();
        this.server_2 = this.createServer(5673, false);
        this.server_2.setIdentity("Server2");
        amqpConnection = new AMQPBrokerConnectConfiguration("connectTowardsServer1", "tcp://localhost:5672").setReconnectAttempts(-1).setRetryInterval(100);
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement().setDurable(true));
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server_2.start();
        this.server_2.addAddressInfo(new AddressInfo(this.getQueueName()).setAutoCreated(false).addRoutingType(RoutingType.ANYCAST));
        this.server_2.createQueue(QueueConfiguration.of((String)this.getQueueName()).setDurable(Boolean.valueOf(true)).setRoutingType(RoutingType.ANYCAST));
        Wait.assertTrue(() -> this.server_2.locateQueue(this.getQueueName()) != null);
        Wait.assertTrue(() -> this.server.locateQueue(this.getQueueName()) != null);
        AmqpClient cf1 = new AmqpClient(new URI("tcp://localhost:5672"), null, null);
        AmqpConnection connection1 = cf1.createConnection();
        connection1.connect();
        AmqpSession session1 = connection1.createSession();
        AmqpClient cf2 = new AmqpClient(new URI("tcp://localhost:5673"), null, null);
        AmqpConnection connection2 = cf2.createConnection();
        connection2.connect();
        AmqpSession session2 = connection2.createSession();
        AmqpSender producerServer1 = session1.createSender(this.getQueueName());
        AmqpSender producerServer2 = session2.createSender(this.getQueueName());
        for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            AmqpMessage message = new AmqpMessage();
            message.setDurable(true);
            message.setApplicationProperty("i", i);
            producerServer1.send(message);
        }
        Queue queueOnServer1 = this.server.locateQueue(this.getQueueName());
        Queue queueOnServer2 = this.server_2.locateQueue(this.getQueueName());
        Assertions.assertNotNull((Object)queueOnServer1);
        Assertions.assertNotNull((Object)queueOnServer2);
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queueOnServer1).getMessageCount());
        Wait.assertEquals((long)NUMBER_OF_MESSAGES, () -> ((Queue)queueOnServer2).getMessageCount());
        for (int i = NUMBER_OF_MESSAGES; i < NUMBER_OF_MESSAGES * 2; ++i) {
            AmqpMessage message = new AmqpMessage();
            message.setDurable(true);
            message.setApplicationProperty("i", i);
            producerServer2.send(message);
        }
        Wait.assertEquals((long)(NUMBER_OF_MESSAGES * 2), () -> ((Queue)queueOnServer1).getMessageCount());
        Wait.assertEquals((long)(NUMBER_OF_MESSAGES * 2), () -> ((Queue)queueOnServer2).getMessageCount());
        AmqpReceiver consumerOn1 = session1.createReceiver(this.getQueueName());
        consumerOn1.flow(NUMBER_OF_MESSAGES * 2 + 1);
        for (int i = 0; i < NUMBER_OF_MESSAGES * 2; ++i) {
            AmqpMessage message = consumerOn1.receive(5L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)message);
            message.accept();
            Assertions.assertEquals((int)i, (int)((Integer)message.getApplicationProperty("i")));
        }
        Wait.assertEquals((long)0L, () -> ((Queue)queueOnServer1).getMessageCount());
        Wait.assertEquals((long)0L, () -> {
            System.out.println(queueOnServer2.getMessageCount());
            return queueOnServer2.getMessageCount();
        });
        connection1.close();
        connection2.close();
        this.server_2.stop();
        this.server.stop();
    }

    @Test
    public void testLargeMessageInSync() throws Exception {
        TextMessage message;
        MessageConsumer consumer;
        jakarta.jms.Queue queue;
        Session session;
        Queue serverQueue;
        String queueName = "testSyncLargeMessage";
        this.server.setIdentity("Server1");
        AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration("connectTowardsServer2", "tcp://localhost:5673").setReconnectAttempts(3).setRetryInterval(100);
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement().setDurable(true));
        this.server.getConfiguration().addAMQPConnection(amqpConnection);
        this.server.start();
        this.server_2 = this.createServer(5673, false);
        this.server_2.setIdentity("Server2");
        amqpConnection = new AMQPBrokerConnectConfiguration("connectTowardsServer1", "tcp://localhost:5672").setReconnectAttempts(-1).setRetryInterval(100);
        amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement().setDurable(true));
        this.server_2.getConfiguration().addAMQPConnection(amqpConnection);
        this.server_2.start();
        this.server_2.addAddressInfo(new AddressInfo(queueName).setAutoCreated(false).addRoutingType(RoutingType.ANYCAST));
        this.server_2.createQueue(QueueConfiguration.of((String)queueName).setDurable(Boolean.valueOf(true)).setRoutingType(RoutingType.ANYCAST));
        Wait.assertTrue(() -> this.server_2.locateQueue(queueName) != null);
        Wait.assertTrue(() -> this.server.locateQueue(queueName) != null);
        StringBuffer bigStringBuffer = new StringBuffer();
        while (bigStringBuffer.length() < 204800) {
            bigStringBuffer.append("This is a big string ");
        }
        String bigString = bigStringBuffer.toString();
        ConnectionFactory factory1 = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
        ConnectionFactory factory2 = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5673");
        try (Connection connection = factory1.createConnection();){
            Session session2 = connection.createSession(false, 1);
            jakarta.jms.Queue queue2 = session2.createQueue(queueName);
            MessageProducer producer = session2.createProducer((Destination)queue2);
            producer.send((Message)session2.createTextMessage(bigString));
        }
        connection = factory2.createConnection();
        try {
            serverQueue = this.server.locateQueue(queueName);
            Wait.assertEquals((long)1L, () -> ((Queue)serverQueue).getMessageCount());
            Wait.assertEquals((int)1, () -> this.getNumberOfFiles(this.server_2.getConfiguration().getLargeMessagesLocation()), (long)5000L, (long)100L);
            session = connection.createSession(false, 1);
            queue = session.createQueue(queueName);
            consumer = session.createConsumer((Destination)queue);
            connection.start();
            message = (TextMessage)consumer.receive(5000L);
            Assertions.assertNotNull((Object)message);
            Assertions.assertEquals((Object)bigString, (Object)message.getText());
            Wait.assertEquals((int)0, () -> this.getNumberOfFiles(this.server_2.getConfiguration().getLargeMessagesLocation()), (long)5000L, (long)100L);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = factory1.createConnection();
        try {
            serverQueue = this.server.locateQueue(queueName);
            Wait.assertEquals((Long)0L, () -> ((Queue)serverQueue).getMessageCount(), (long)2000L, (long)100L);
            session = connection.createSession(false, 1);
            queue = session.createQueue(queueName);
            consumer = session.createConsumer((Destination)queue);
            connection.start();
            message = (TextMessage)consumer.receiveNoWait();
            Assertions.assertNull((Object)message);
            this.server.stop();
            this.server_2.stop();
            Wait.assertEquals((int)0, () -> this.getNumberOfFiles(this.server.getConfiguration().getLargeMessagesLocation()), (long)1000L, (long)100L);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }
}

