/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.connect;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionAddressType;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPMirrorBrokerConnectionElement;
import org.apache.activemq.artemis.core.remoting.server.RemotingService;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.BrokerConnection;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.protocol.amqp.broker.ActiveMQProtonRemotingConnection;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManager;
import org.apache.activemq.artemis.protocol.amqp.connect.AMQPBrokerConnection;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorControllerSource;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.impl.ConnectionImpl;
import org.apache.qpid.protonj2.test.driver.ProtonTestClient;
import org.apache.qpid.protonj2.test.driver.ProtonTestPeer;
import org.apache.qpid.protonj2.test.driver.ProtonTestServer;
import org.apache.qpid.protonj2.test.driver.matchers.messaging.ApplicationPropertiesMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.messaging.DeliveryAnnotationsMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.messaging.HeaderMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.messaging.MessageAnnotationsMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.messaging.PropertiesMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.transport.TransferPayloadCompositeMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.types.EncodedAmqpValueMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateAMQPErrorsTest
extends AmqpClientTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final int AMQP_PORT_2 = 5673;

    @Override
    protected ActiveMQServer createServer() throws Exception {
        return this.createServer(5672, false);
    }

    @Test
    @Timeout(value=30L)
    public void testConnectItself() throws Exception {
        try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://localhost:5672");
            amqpConnection.setReconnectAttempts(10).setRetryInterval(1);
            amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement());
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            Assertions.assertEquals((int)1, (int)this.server.getBrokerConnections().size());
            this.server.getBrokerConnections().forEach(t -> Wait.assertFalse(() -> ((BrokerConnection)t).isStarted()));
            Wait.assertTrue(() -> loggerHandler.findText(new String[]{"AMQ111001"}), (long)5000L, (long)25L);
        }
        loggerHandler = new AssertionLoggerHandler();
        try {
            Thread.sleep(50L);
            Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ111002"}));
            Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ111003"}));
        }
        finally {
            loggerHandler.close();
        }
    }

    @Test
    @Timeout(value=30L)
    public void testCloseLinkOnMirror() throws Exception {
        try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
            int i;
            Session session;
            ActiveMQServer server2 = this.createServer(5673, false);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://localhost:5673");
            amqpConnection.setReconnectAttempts(1000).setRetryInterval(10);
            amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement());
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            Assertions.assertEquals((int)1, (int)this.server.getBrokerConnections().size());
            Wait.assertTrue(() -> loggerHandler.findText(new String[]{"AMQ111002"}));
            this.server.getBrokerConnections().forEach(t -> Wait.assertTrue(() -> ((AMQPBrokerConnection)t).isConnecting()));
            server2.start();
            this.server.getBrokerConnections().forEach(t -> Wait.assertFalse(() -> ((AMQPBrokerConnection)t).isConnecting()));
            this.createAddressAndQueues(this.server);
            Wait.assertTrue(() -> server2.locateQueue(this.getQueueName()) != null);
            Wait.assertEquals((int)1, () -> ((RemotingService)server2.getRemotingService()).getConnectionCount());
            server2.getRemotingService().getConnections().forEach(t -> {
                try {
                    ActiveMQProtonRemotingConnection connection = (ActiveMQProtonRemotingConnection)t;
                    ConnectionImpl protonConnection = (ConnectionImpl)connection.getAmqpConnection().getHandler().getConnection();
                    Wait.waitFor(() -> protonConnection.linkHead(EnumSet.of(EndpointState.ACTIVE), EnumSet.of(EndpointState.ACTIVE)) != null);
                    connection.getAmqpConnection().runNow(() -> {
                        Receiver receiver = (Receiver)protonConnection.linkHead(EnumSet.of(EndpointState.ACTIVE), EnumSet.of(EndpointState.ACTIVE));
                        receiver.close();
                        connection.flush();
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            ConnectionFactory cf1 = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            ConnectionFactory cf2 = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5673");
            try (Connection connection = cf1.createConnection();){
                session = connection.createSession(false, 1);
                MessageProducer producer = session.createProducer((Destination)session.createQueue(this.getQueueName()));
                for (i = 0; i < 10; ++i) {
                    producer.send((Message)session.createTextMessage("message " + i));
                }
            }
            connection = cf2.createConnection();
            try {
                session = connection.createSession(false, 1);
                MessageConsumer consumer = session.createConsumer((Destination)session.createQueue(this.getQueueName()));
                connection.start();
                for (i = 0; i < 10; ++i) {
                    Assertions.assertEquals((Object)("message " + i), (Object)((TextMessage)consumer.receive(5000L)).getText());
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
    }

    @Test
    @Timeout(value=30L)
    public void testCloseLinkOnSender() throws Exception {
        this.doCloseLinkTestImpl(true);
    }

    @Test
    @Timeout(value=30L)
    public void testCloseLinkOnReceiver() throws Exception {
        this.doCloseLinkTestImpl(false);
    }

    private void doCloseLinkTestImpl(boolean isSender) throws Exception {
        int i;
        Session session;
        AtomicInteger errors = new AtomicInteger(0);
        try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
            AMQPBrokerConnectConfiguration amqpConnection;
            ActiveMQServer server2 = this.createServer(5673, false);
            if (isSender) {
                amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://localhost:5673");
                amqpConnection.setReconnectAttempts(1000).setRetryInterval(10);
                amqpConnection.addElement(new AMQPBrokerConnectionElement().setMatchAddress(this.getQueueName()).setType(AMQPBrokerConnectionAddressType.SENDER));
                this.server.getConfiguration().addAMQPConnection(amqpConnection);
            } else {
                amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://localhost:5672");
                amqpConnection.setReconnectAttempts(1000).setRetryInterval(10);
                amqpConnection.addElement(new AMQPBrokerConnectionElement().setMatchAddress(this.getQueueName()).setType(AMQPBrokerConnectionAddressType.RECEIVER));
                server2.getConfiguration().addAMQPConnection(amqpConnection);
            }
            if (isSender) {
                this.server.start();
                Assertions.assertEquals((int)1, (int)this.server.getBrokerConnections().size());
            } else {
                server2.start();
                Assertions.assertEquals((int)1, (int)server2.getBrokerConnections().size());
            }
            Wait.assertTrue(() -> loggerHandler.findText(new String[]{"AMQ111002"}));
            this.server.getBrokerConnections().forEach(t -> Wait.assertTrue(() -> ((AMQPBrokerConnection)t).isConnecting()));
            if (isSender) {
                server2.start();
            } else {
                this.server.start();
            }
            this.server.getBrokerConnections().forEach(t -> Wait.assertFalse(() -> ((AMQPBrokerConnection)t).isConnecting()));
            this.createAddressAndQueues(this.server);
            this.createAddressAndQueues(server2);
            Wait.assertTrue(() -> this.server.locateQueue(this.getQueueName()) != null);
            Wait.assertTrue(() -> server2.locateQueue(this.getQueueName()) != null);
            ActiveMQServer serverReceivingConnections = isSender ? server2 : this.server;
            Wait.assertEquals((int)1, () -> ((RemotingService)serverReceivingConnections.getRemotingService()).getConnectionCount());
            serverReceivingConnections.getRemotingService().getConnections().forEach(t -> {
                try {
                    ActiveMQProtonRemotingConnection connection = (ActiveMQProtonRemotingConnection)t;
                    ConnectionImpl protonConnection = (ConnectionImpl)connection.getAmqpConnection().getHandler().getConnection();
                    Wait.waitFor(() -> protonConnection.linkHead(EnumSet.of(EndpointState.ACTIVE), EnumSet.of(EndpointState.ACTIVE)) != null);
                    connection.getAmqpConnection().runNow(() -> {
                        Link theLink = protonConnection.linkHead(EnumSet.of(EndpointState.ACTIVE), EnumSet.of(EndpointState.ACTIVE));
                        theLink.close();
                        connection.flush();
                    });
                }
                catch (Exception e) {
                    errors.incrementAndGet();
                }
            });
            Wait.assertEquals((int)1, () -> loggerHandler.countText(new String[]{"AMQ119021"}));
        }
        ConnectionFactory cf1 = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
        ConnectionFactory cf2 = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5673");
        try (Connection connection = cf1.createConnection();){
            session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)session.createQueue(this.getQueueName()));
            for (i = 0; i < 10; ++i) {
                producer.send((Message)session.createTextMessage("message " + i));
            }
        }
        connection = cf2.createConnection();
        try {
            session = connection.createSession(false, 1);
            MessageConsumer consumer = session.createConsumer((Destination)session.createQueue(this.getQueueName()));
            connection.start();
            for (i = 0; i < 10; ++i) {
                Assertions.assertEquals((Object)("message " + i), (Object)((TextMessage)consumer.receive(5000L)).getText());
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        Assertions.assertEquals((int)0, (int)errors.get());
    }

    @Test
    @Timeout(value=30L)
    public void testTimeoutOnSenderOpen() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            ValidateAMQPErrorsTest.expectConnectionButDontRespondToSenderAttach(peer);
            ValidateAMQPErrorsTest.expectConnectionButDontRespondToSenderAttach(peer);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.debug("Connect test started, peer listening on: {}", (Object)remoteURI);
            try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
                AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://localhost:" + remoteURI.getPort() + "?connect-timeout-millis=100");
                amqpConnection.setReconnectAttempts(1).setRetryInterval(100);
                amqpConnection.addElement(new AMQPBrokerConnectionElement().setMatchAddress(this.getQueueName()).setType(AMQPBrokerConnectionAddressType.SENDER));
                amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement());
                this.server.getConfiguration().addAMQPConnection(amqpConnection);
                this.server.start();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                Assertions.assertEquals((int)2, (int)loggerHandler.countText(new String[]{"AMQ119020"}));
                Assertions.assertEquals((int)1, (int)loggerHandler.countText(new String[]{"AMQ111001"}));
            }
        }
    }

    @Test
    @Timeout(value=30L)
    public void testReconnectAfterSenderOpenTimeout() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            ValidateAMQPErrorsTest.expectConnectionButDontRespondToSenderAttach(peer);
            ValidateAMQPErrorsTest.expectConnectionButDontRespondToSenderAttach(peer);
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().respondInKind().withProperty(AMQPMirrorControllerSource.BROKER_ID.toString(), (Object)"Test-Broker");
            peer.remoteFlow().withLinkCredit(1000L).queue();
            peer.expectTransfer().accept();
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.debug("Connect test started, peer listening on: {}", (Object)remoteURI);
            try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
                AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://localhost:" + remoteURI.getPort() + "?connect-timeout-millis=100");
                amqpConnection.setReconnectAttempts(10).setRetryInterval(100);
                amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement());
                this.server.getConfiguration().addAMQPConnection(amqpConnection);
                this.server.start();
                int msgCount = 10;
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectTransfer().accept();
                peer.expectTransfer().accept();
                for (int i = 0; i < msgCount; ++i) {
                    ValidateAMQPErrorsTest.expectMirroredJMSMessage((ProtonTestPeer)peer, i);
                }
                Wait.assertEquals((int)2, () -> loggerHandler.countText(new String[]{"AMQ119020"}), (long)2000L, (long)25L);
                ValidateAMQPErrorsTest.sendJMSMessage(msgCount, this.getQueueName());
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            }
        }
    }

    @Test
    @Timeout(value=30L)
    public void testNoServerOfferedMirrorCapability() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            for (int i = 0; i < 3; ++i) {
                peer.expectSASLAnonymousConnect();
                peer.expectOpen().respond();
                peer.expectBegin().respond();
                peer.expectAttach().ofSender().respond();
                peer.expectConnectionToDrop();
            }
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.debug("Connect test started, peer listening on: {}", (Object)remoteURI);
            try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
                AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://localhost:" + remoteURI.getPort() + "?connect-timeout-millis=3000");
                amqpConnection.setReconnectAttempts(2).setRetryInterval(100);
                amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement());
                this.server.getConfiguration().addAMQPConnection(amqpConnection);
                this.server.start();
                Wait.assertTrue(() -> loggerHandler.findText(new String[]{"AMQ111001"}));
                Assertions.assertEquals((int)3, (int)loggerHandler.countText(new String[]{"AMQ119018"}));
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            }
        }
    }

    @Test
    @Timeout(value=30L)
    public void testReconnectAfterMirrorLinkRefusal() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().respond().withNullTarget();
            peer.remoteDetach().withErrorCondition(AmqpError.ILLEGAL_STATE.toString(), "Testing refusal of mirror link for $reasons").queue();
            peer.expectDetach().optional();
            peer.expectClose().optional();
            peer.expectConnectionToDrop();
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().respondInKind().withProperty(AMQPMirrorControllerSource.BROKER_ID.toString(), (Object)"Test-Broker");
            peer.remoteFlow().withLinkCredit(1000L).queue();
            peer.expectTransfer().accept();
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.debug("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://localhost:" + remoteURI.getPort() + "?connect-timeout-millis=3000");
            amqpConnection.setReconnectAttempts(1).setRetryInterval(100);
            amqpConnection.addElement((AMQPBrokerConnectionElement)new AMQPMirrorBrokerConnectionElement());
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            int msgCount = 10;
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectTransfer().accept();
            peer.expectTransfer().accept();
            for (int i = 0; i < msgCount; ++i) {
                ValidateAMQPErrorsTest.expectMirroredJMSMessage((ProtonTestPeer)peer, i);
            }
            ValidateAMQPErrorsTest.sendJMSMessage(msgCount, this.getQueueName());
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
        }
    }

    @Test
    @Timeout(value=30L)
    public void testNoClientDesiredMirrorCapability() throws Exception {
        try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
            this.server.start();
            String address = ProtonProtocolManager.getMirrorAddress((String)this.getTestName());
            try (ProtonTestClient receivingPeer = new ProtonTestClient();){
                receivingPeer.queueClientSaslAnonymousConnect();
                receivingPeer.connect("localhost", 5672);
                receivingPeer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                receivingPeer.expectOpen();
                receivingPeer.expectBegin();
                receivingPeer.expectAttach().withNullTarget();
                receivingPeer.expectDetach().withError(AmqpError.ILLEGAL_STATE.toString(), Matchers.containsString((String)"AMQ119024")).respond();
                receivingPeer.remoteOpen().withContainerId("test-sender").now();
                receivingPeer.remoteBegin().now();
                receivingPeer.remoteAttach().ofSender().withInitialDeliveryCount(0L).withName("mirror-test").withTarget().withAddress(address).also().withSource().and().now();
                receivingPeer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            }
            Wait.assertTrue(() -> loggerHandler.findText(new String[]{"AMQ119024"}));
        }
    }

    private static void expectConnectionButDontRespondToSenderAttach(ProtonTestServer peer) {
        peer.expectSASLAnonymousConnect();
        peer.expectOpen().respond();
        peer.expectBegin().respond();
        peer.expectAttach().ofSender();
        peer.expectConnectionToDrop();
    }

    private static void sendJMSMessage(int msgCount, String queueName) throws JMSException {
        ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
        try (Connection connection = factory.createConnection();){
            Session session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)session.createQueue(queueName));
            for (int i = 0; i < msgCount; ++i) {
                TextMessage message = session.createTextMessage("hello");
                message.setIntProperty("sender", i);
                producer.send((Message)message);
            }
        }
    }

    private static void expectMirroredJMSMessage(ProtonTestPeer peer, int sequence) {
        HeaderMatcher headerMatcher = new HeaderMatcher(true);
        PropertiesMatcher properties = new PropertiesMatcher(true);
        DeliveryAnnotationsMatcher daMatcher = new DeliveryAnnotationsMatcher(true);
        MessageAnnotationsMatcher annotationsMatcher = new MessageAnnotationsMatcher(true);
        ApplicationPropertiesMatcher apMatcher = new ApplicationPropertiesMatcher(true);
        apMatcher.withEntry("sender", CoreMatchers.equalTo((Object)sequence));
        EncodedAmqpValueMatcher bodyMatcher = new EncodedAmqpValueMatcher((Object)"hello");
        TransferPayloadCompositeMatcher matcher = new TransferPayloadCompositeMatcher();
        matcher.setHeadersMatcher(headerMatcher);
        matcher.setPropertiesMatcher(properties);
        matcher.setDeliveryAnnotationsMatcher(daMatcher);
        matcher.setMessageAnnotationsMatcher(annotationsMatcher);
        matcher.setApplicationPropertiesMatcher(apMatcher);
        matcher.addMessageContentMatcher((Matcher)bodyMatcher);
        peer.expectTransfer().withPayload((Matcher)matcher).accept();
    }
}

