/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.largemessages;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.management.openmbean.CompositeData;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.integration.amqp.largemessages.AMQPLargeMessagesTestUtil;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class SimpleStreamingLargeMessageTest
extends AmqpClientTestSupport {
    private String smallFrameAcceptor = new String("tcp://localhost:5680");
    int frameSize;
    int minLargeMessageSize;

    @Parameters(name="frameSize = {0}, minLargeMessage = {1}")
    public static Iterable<? extends Object> testParameters() {
        return Arrays.asList({512, 50000}, {0x100000, 50000}, {0x100000, 50000000});
    }

    public SimpleStreamingLargeMessageTest(int frameSize, int minLargeMessageSize) {
        this.frameSize = frameSize;
        this.minLargeMessageSize = minLargeMessageSize;
    }

    @Override
    protected void addAdditionalAcceptors(ActiveMQServer server) throws Exception {
        server.getConfiguration().addAcceptorConfiguration("flow", this.smallFrameAcceptor + "?protocols=AMQP;useEpoll=false;maxFrameSize=" + this.frameSize + ";amqpMinLargeMessageSize=" + this.minLargeMessageSize);
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testSendNonPersistent() throws Exception {
        this.testSend(false, false);
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testSendPersistent() throws Exception {
        this.testSend(true, false);
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testSendPersistentRestartServer() throws Exception {
        this.testSend(true, true);
    }

    public void testSend(boolean persistent, boolean restartServer) throws Exception {
        try {
            int size = 102400;
            AmqpClient client = this.createAmqpClient(new URI(this.smallFrameAcceptor));
            AmqpConnection connection = client.createConnection();
            this.addConnection(connection);
            connection.setMaxFrameSize(2048);
            connection.connect();
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName());
            Queue queueView = this.getProxyToQueue(this.getQueueName());
            Assertions.assertNotNull((Object)queueView);
            Assertions.assertEquals((long)0L, (long)queueView.getMessageCount());
            session.begin();
            for (int m = 0; m < 10; ++m) {
                AmqpMessage message = new AmqpMessage();
                message.setDurable(persistent);
                byte[] bytes = new byte[size];
                for (int i = 0; i < bytes.length; ++i) {
                    bytes[i] = 122;
                }
                message.setBytes(bytes);
                sender.send(message);
            }
            session.commit();
            AMQPLargeMessagesTestUtil.validateAllTemporaryBuffers(this.server);
            if (restartServer) {
                connection.close();
                this.server.stop();
                this.server.start();
                connection = client.createConnection();
                this.addConnection(connection);
                connection.setMaxFrameSize(2048);
                connection.connect();
                session = connection.createSession();
            }
            queueView = this.getProxyToQueue(this.getQueueName());
            Wait.assertEquals((long)10L, () -> ((Queue)queueView).getMessageCount());
            AmqpReceiver receiver = session.createReceiver(this.getQueueName());
            receiver.flow(10);
            for (int i = 0; i < 10; ++i) {
                AmqpMessage msgReceived = receiver.receive(10L, TimeUnit.SECONDS);
                Assertions.assertNotNull((Object)msgReceived);
                Data body = (Data)msgReceived.getWrappedMessage().getBody();
                byte[] bodyArray = body.getValue().getArray();
                for (int bI = 0; bI < size; ++bI) {
                    Assertions.assertEquals((byte)122, (byte)bodyArray[bI]);
                }
                msgReceived.accept(true);
            }
            receiver.flow(1);
            Assertions.assertNull((Object)receiver.receiveNoWait());
            receiver.close();
            connection.close();
            Wait.assertEquals((long)0L, () -> ((Queue)queueView).getMessageCount());
            this.validateNoFilesOnLargeDir();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @TestTemplate
    public void testSendWithPropertiesAndFilterPersistentRestart() throws Exception {
        this.testSendWithPropertiesAndFilter(true, true);
    }

    @TestTemplate
    public void testSendWithPropertiesAndFilterPersistentNoRestart() throws Exception {
        this.testSendWithPropertiesAndFilter(true, false);
    }

    @TestTemplate
    public void testSendWithPropertiesNonPersistent() throws Exception {
        this.testSendWithPropertiesAndFilter(false, false);
    }

    public void testSendWithPropertiesAndFilter(boolean persistent, boolean restartServer) throws Exception {
        try {
            int size = 102400;
            AmqpClient client = this.createAmqpClient(new URI(this.smallFrameAcceptor));
            AmqpConnection connection = client.createConnection();
            this.addConnection(connection);
            connection.setMaxFrameSize(2048);
            connection.connect();
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName());
            Queue queueView = this.getProxyToQueue(this.getQueueName());
            Assertions.assertNotNull((Object)queueView);
            Assertions.assertEquals((long)0L, (long)queueView.getMessageCount());
            session.begin();
            int oddID = 0;
            for (int m = 0; m < 10; ++m) {
                AmqpMessage message = new AmqpMessage();
                message.setDurable(persistent);
                boolean odd = m % 2 == 0;
                message.setApplicationProperty("i", m);
                message.setApplicationProperty("oddString", odd ? "odd" : "even");
                message.setApplicationProperty("odd", odd);
                if (odd) {
                    message.setApplicationProperty("oddID", oddID++);
                }
                byte[] bytes = new byte[size];
                for (int i = 0; i < bytes.length; ++i) {
                    bytes[i] = 122;
                }
                message.setBytes(bytes);
                sender.send(message);
                if (m != 5) continue;
                session.commit();
            }
            AMQPLargeMessagesTestUtil.validateAllTemporaryBuffers(this.server);
            if (restartServer) {
                connection.close();
                this.server.stop();
                this.server.start();
                connection = client.createConnection();
                this.addConnection(connection);
                connection.setMaxFrameSize(2048);
                connection.connect();
                session = connection.createSession();
            }
            queueView = this.getProxyToQueue(this.getQueueName());
            Wait.assertEquals((long)10L, () -> ((Queue)queueView).getMessageCount());
            AmqpReceiver receiver = session.createReceiver(this.getQueueName(), "odd=true");
            receiver.flow(10);
            for (int i = 0; i < 5; ++i) {
                AmqpMessage msgReceived = receiver.receive(10L, TimeUnit.SECONDS);
                Assertions.assertNotNull((Object)msgReceived);
                Assertions.assertTrue((boolean)((Boolean)msgReceived.getApplicationProperty("odd")));
                Assertions.assertEquals((int)i, (int)((Integer)msgReceived.getApplicationProperty("oddID")));
                Data body = (Data)msgReceived.getWrappedMessage().getBody();
                byte[] bodyArray = body.getValue().getArray();
                for (int bI = 0; bI < size; ++bI) {
                    Assertions.assertEquals((byte)122, (byte)bodyArray[bI]);
                }
                msgReceived.accept(true);
            }
            receiver.flow(1);
            Assertions.assertNull((Object)receiver.receiveNoWait());
            receiver.close();
            connection.close();
            this.validateNoFilesOnLargeDir(this.getLargeMessagesDir(), 5);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @TestTemplate
    public void testSingleMessage() throws Exception {
        try {
            int size = 102400;
            AmqpClient client = this.createAmqpClient(new URI(this.smallFrameAcceptor));
            AmqpConnection connection = client.createConnection();
            this.addConnection(connection);
            connection.setMaxFrameSize(2048);
            connection.connect();
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName());
            Queue queueView = this.getProxyToQueue(this.getQueueName());
            Assertions.assertNotNull((Object)queueView);
            Assertions.assertEquals((long)0L, (long)queueView.getMessageCount());
            session.begin();
            int oddID = 0;
            for (int m = 0; m < 1; ++m) {
                AmqpMessage message = new AmqpMessage();
                message.setDurable(true);
                boolean odd = m % 2 == 0;
                message.setApplicationProperty("i", m);
                message.setApplicationProperty("oddString", odd ? "odd" : "even");
                message.setApplicationProperty("odd", odd);
                if (odd) {
                    message.setApplicationProperty("oddID", oddID++);
                }
                byte[] bytes = new byte[size];
                for (int i = 0; i < bytes.length; ++i) {
                    bytes[i] = 122;
                }
                message.setBytes(bytes);
                sender.send(message);
            }
            session.commit();
            Queue queue = this.server.locateQueue(SimpleString.of((String)this.getQueueName()));
            Wait.assertEquals((long)1L, () -> ((Queue)queue).getMessageCount());
            LinkedListIterator browserIterator = queue.browserIterator();
            while (browserIterator.hasNext()) {
                MessageReference ref = (MessageReference)browserIterator.next();
                org.apache.activemq.artemis.api.core.Message message = ref.getMessage();
                Assertions.assertNotNull((Object)message);
                Assertions.assertTrue((boolean)(message instanceof LargeServerMessage));
            }
            browserIterator.close();
            connection.close();
            this.server.stop();
            this.server.start();
            QueueControl queueControl = ManagementControlHelper.createQueueControl(queue.getAddress(), queue.getName(), RoutingType.ANYCAST, this.mBeanServer);
            CompositeData[] browseResult = queueControl.browse();
            Assertions.assertEquals((int)1, (int)browseResult.length);
            if (((Boolean)browseResult[0].get("largeMessage")).booleanValue()) {
                Assertions.assertTrue((browseResult[0].containsKey("text") || browseResult[0].containsKey("BodyPreview") ? 1 : 0) != 0);
            }
            connection = client.createConnection();
            this.addConnection(connection);
            connection.setMaxFrameSize(2048);
            connection.connect();
            session = connection.createSession();
            AmqpReceiver receiver = session.createReceiver(this.getQueueName());
            receiver.flow(1);
            for (int i = 0; i < 1; ++i) {
                AmqpMessage msgReceived = receiver.receive(10L, TimeUnit.SECONDS);
                Assertions.assertNotNull((Object)msgReceived);
                Assertions.assertTrue((boolean)((Boolean)msgReceived.getApplicationProperty("odd")));
                Assertions.assertEquals((int)i, (int)((Integer)msgReceived.getApplicationProperty("oddID")));
                Data body = (Data)msgReceived.getWrappedMessage().getBody();
                byte[] bodyArray = body.getValue().getArray();
                for (int bI = 0; bI < size; ++bI) {
                    Assertions.assertEquals((byte)122, (byte)bodyArray[bI]);
                }
                msgReceived.accept(true);
            }
            receiver.flow(1);
            Assertions.assertNull((Object)receiver.receiveNoWait());
            receiver.close();
            connection.close();
            this.validateNoFilesOnLargeDir(this.getLargeMessagesDir(), 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @TestTemplate
    public void testJMSPersistentTX() throws Exception {
        boolean persistent = true;
        boolean tx = true;
        this.jmsTest(persistent, tx);
    }

    @TestTemplate
    public void testJMSPersistentNonTX() throws Exception {
        boolean persistent = true;
        boolean tx = false;
        this.jmsTest(persistent, tx);
    }

    @TestTemplate
    public void testJMSNonPersistentTX() throws Exception {
        boolean persistent = false;
        boolean tx = true;
        this.jmsTest(persistent, tx);
    }

    @TestTemplate
    public void testJMSNonPersistentNonTX() throws Exception {
        boolean persistent = false;
        boolean tx = false;
        this.jmsTest(persistent, tx);
    }

    private void jmsTest(boolean persistent, boolean tx) throws JMSException {
        int MESSAGE_SIZE = 102400;
        int MESSAGES = 10;
        String producerUri = "amqp://localhost:5672";
        JmsConnectionFactory producerFactory = new JmsConnectionFactory(producerUri);
        try (Connection producerConnection = producerFactory.createConnection();
             Session producerSession = producerConnection.createSession(tx, tx ? 0 : 1);){
            producerConnection.start();
            jakarta.jms.Queue queue = producerSession.createQueue(this.getQueueName());
            String consumerUri = "amqp://localhost:5672";
            JmsConnectionFactory consumerConnectionFactory = new JmsConnectionFactory(consumerUri);
            try (Connection consumerConnection = consumerConnectionFactory.createConnection();
                 Session consumerSession = consumerConnection.createSession(tx, tx ? 0 : 1);
                 MessageConsumer consumer = consumerSession.createConsumer((Destination)queue);
                 MessageProducer producer = producerSession.createProducer((Destination)queue);){
                if (persistent) {
                    producer.setDeliveryMode(2);
                } else {
                    producer.setDeliveryMode(1);
                }
                consumerConnection.start();
                byte[] largeMessageContent = new byte[MESSAGE_SIZE];
                byte[] receivedContent = new byte[largeMessageContent.length];
                ThreadLocalRandom.current().nextBytes(largeMessageContent);
                for (int i = 0; i < MESSAGES; ++i) {
                    BytesMessage sentMessage = producerSession.createBytesMessage();
                    sentMessage.writeBytes(largeMessageContent);
                    producer.send((Message)sentMessage);
                    if (tx) {
                        producerSession.commit();
                    }
                    Message receivedMessage = consumer.receive(5000L);
                    Assertions.assertNotNull((Object)receivedMessage, (String)"A message should be received in 5000 ms");
                    if (tx) {
                        consumerSession.commit();
                    }
                    MatcherAssert.assertThat((Object)receivedMessage, (Matcher)IsInstanceOf.instanceOf(sentMessage.getClass()));
                    Assertions.assertEquals((int)largeMessageContent.length, (int)((BytesMessage)receivedMessage).readBytes(receivedContent));
                    Assertions.assertArrayEquals((byte[])largeMessageContent, (byte[])receivedContent);
                }
            }
        }
    }
}

