/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.lang.invoke.MethodHandles;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.CoreAddressConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RescheduleJDBCDeliveryTest
extends ActiveMQTestBase {
    private final boolean PRINT_DATA = false;
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    public void testRescheduledRedeliveryCORE() throws Exception {
        this.testRescheduledRedelivery("CORE", 0);
    }

    @Test
    public void testRescheduledRedeliveryCORE_1() throws Exception {
        this.testRescheduledRedelivery("CORE", 1);
    }

    @Test
    public void testRescheduledRedeliveryAMQP_1() throws Exception {
        this.testRescheduledRedelivery("AMQP", 1);
    }

    @Test
    public void testRescheduledRedeliveryAMQP() throws Exception {
        this.testRescheduledRedelivery("AMQP", 0);
    }

    @Test
    public void testRescheduledRedeliveryCOREInfinite() throws Exception {
        this.testRescheduledRedelivery("CORE", -1);
    }

    @Test
    public void testRescheduledRedeliveryAMQPInfinite() throws Exception {
        this.testRescheduledRedelivery("AMQP", -1);
    }

    private void testRescheduledRedelivery(String protocol, int maxRecords) throws Exception {
        TextMessage message;
        int maxRedeliveries = 100;
        String testQueue = this.getName();
        Configuration configuration = this.createDefaultJDBCConfig(true);
        configuration.setMaxRedeliveryRecords(maxRecords);
        configuration.addAddressSetting("#", new AddressSettings().setRedeliveryDelay(1L).setMaxDeliveryAttempts(-1).setDeadLetterAddress(SimpleString.of((String)"DLQ")));
        configuration.addAddressConfiguration(new CoreAddressConfiguration().setName("DLQ").addRoutingType(RoutingType.ANYCAST));
        configuration.addQueueConfiguration(QueueConfiguration.of((String)"DLQ").setAddress("DLQ").setRoutingType(RoutingType.ANYCAST));
        configuration.addAddressConfiguration(new CoreAddressConfiguration().setName(testQueue).addRoutingType(RoutingType.ANYCAST));
        configuration.addQueueConfiguration(QueueConfiguration.of((String)testQueue).setAddress(testQueue).setRoutingType(RoutingType.ANYCAST));
        ActiveMQServer server = this.createServer(true, configuration, 0xA00000, -1L);
        server.start();
        ConnectionFactory factory = CFUtil.createConnectionFactory(protocol, "tcp://localhost:61616");
        try (jakarta.jms.Connection connection = factory.createConnection();){
            Session session = connection.createSession(true, 0);
            Queue queue = session.createQueue(testQueue);
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.send((Message)session.createTextMessage("hello"));
            session.commit();
            connection.start();
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            for (int i = 0; i < maxRedeliveries; ++i) {
                message = (TextMessage)consumer.receive(5000L);
                logger.debug("received {}", (Object)message);
                Assertions.assertNotNull((Object)message);
                session.rollback();
            }
        }
        server.stop();
        Connection jdbcConnection = DriverManager.getConnection(this.getTestJDBCConnectionUrl());
        this.runAfter(jdbcConnection::close);
        int records = this.executeQuery(jdbcConnection, "SELECT * FROM MESSAGE WHERE USERRECORDTYPE=36 OR USERRECORDTYPE=34");
        if (maxRecords < 0) {
            Assertions.assertEquals((int)(maxRedeliveries * 2), (int)records);
        } else {
            Assertions.assertEquals((int)(maxRecords * 2), (int)records);
        }
        server.start();
        try (jakarta.jms.Connection connection = factory.createConnection();){
            Session session = connection.createSession(true, 0);
            Queue queue = session.createQueue(testQueue);
            connection.start();
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            message = (TextMessage)consumer.receive(5000L);
            logger.debug("received {}", (Object)message);
            Assertions.assertNotNull((Object)message);
            session.commit();
            Assertions.assertNull((Object)consumer.receiveNoWait());
        }
    }

    protected int executeQuery(Connection connection, String sql) throws Exception {
        PreparedStatement statement = connection.prepareStatement(sql);
        ResultSet result = statement.executeQuery();
        ResultSetMetaData metaData = result.getMetaData();
        int columnCount = metaData.getColumnCount();
        int records = 0;
        while (result.next()) {
            if (logger.isDebugEnabled()) {
                StringBuffer line = new StringBuffer();
                for (int i = 1; i <= columnCount; ++i) {
                    Object value = result.getObject(i);
                    line.append(metaData.getColumnLabel(i) + " = " + value);
                    if (i + 1 > columnCount) continue;
                    line.append(", ");
                }
                logger.info(line.toString());
            }
            ++records;
        }
        return records;
    }
}

