/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SelfExpandingBufferTest
extends ActiveMQTestBase {
    ActiveMQServer service;
    SimpleString ADDRESS = SimpleString.of((String)"Address");

    @Test
    public void testSelfExpandingBufferNettyPersistent() throws Exception {
        this.testSelfExpandingBuffer(true, true);
    }

    @Test
    public void testSelfExpandingBufferInVMPersistent() throws Exception {
        this.testSelfExpandingBuffer(false, true);
    }

    @Test
    public void testSelfExpandingBufferNettyNonPersistent() throws Exception {
        this.testSelfExpandingBuffer(true, false);
    }

    @Test
    public void testSelfExpandingBufferInVMNonPersistent() throws Exception {
        this.testSelfExpandingBuffer(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSelfExpandingBuffer(boolean netty, boolean persistent) throws Exception {
        this.setUpService(netty, persistent);
        ServerLocator locator = this.createFactory(netty);
        ClientSessionFactory factory = this.createSessionFactory(locator);
        try (ClientSession session = factory.createSession(false, true, true);){
            session.createQueue(QueueConfiguration.of((SimpleString)this.ADDRESS));
            ClientMessage msg = session.createMessage(true);
            ActiveMQBuffer buffer = msg.getBodyBuffer();
            byte[] bytes = RandomUtil.randomBytes((int)(10 * buffer.capacity()));
            buffer.writeBytes(bytes);
            ClientProducer prod = session.createProducer(this.ADDRESS);
            prod.send((Message)msg);
            prod.send((Message)msg);
            ClientConsumer cons = session.createConsumer(this.ADDRESS);
            session.start();
            ClientMessage msg2 = cons.receive(3000L);
            Assertions.assertNotNull((Object)msg2);
            byte[] receivedBytes = new byte[bytes.length];
            msg2.getBodyBuffer().readBytes(receivedBytes);
            ActiveMQTestBase.assertEqualsByteArrays(bytes, receivedBytes);
            msg2 = cons.receive(3000L);
            Assertions.assertNotNull((Object)msg2);
            msg2.getBodyBuffer().readBytes(receivedBytes);
            ActiveMQTestBase.assertEqualsByteArrays(bytes, receivedBytes);
        }
    }

    protected void setUpService(boolean netty, boolean persistent) throws Exception {
        this.service = this.createServer(persistent, this.createDefaultConfig(netty));
        this.service.start();
    }
}

