/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.cluster.RemoteQueueBinding;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MessageLoadBalancingTest
extends ClusterTestBase {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.start();
    }

    private void start() throws Exception {
        this.setupServers();
        this.setRedistributionDelay(0L);
    }

    protected boolean isNetty() {
        return false;
    }

    @Test
    public void testMessageLoadBalancingOff() throws Exception {
        this.setupCluster(MessageLoadBalancingType.OFF);
        this.startServers(0, 1);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.addConsumer(1, 1, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 0, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 1, 1, false);
        this.waitForBindings(1, "queues.testaddress", 1, 0, false);
        this.addConsumer(0, 0, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 1, 1, false);
        this.waitForBindings(1, "queues.testaddress", 1, 1, false);
        this.send(0, "queues.testaddress", 10, false, null);
        ClientMessage message = this.getConsumer(1).receive(1000L);
        Assertions.assertNull((Object)message);
        for (int i = 0; i < 10; ++i) {
            message = this.getConsumer(0).receive(5000L);
            Assertions.assertNotNull((Object)message, (String)("" + i));
            message.acknowledge();
        }
        ClientMessage clientMessage = this.getConsumer(0).receiveImmediate();
        Assertions.assertNull((Object)clientMessage);
    }

    @Test
    public void testMessageLoadBalancingWithFiltersUpdate() throws Exception {
        this.setupCluster(MessageLoadBalancingType.ON_DEMAND);
        this.startServers(0, 1);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.waitForBindings(0, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 1, 0, false);
        this.waitForBindings(1, "queues.testaddress", 1, 0, true);
        this.waitForBindings(1, "queues.testaddress", 1, 0, false);
        Binding[] bindings = new Binding[2];
        PostOffice[] po = new PostOffice[2];
        for (int i = 0; i < 2; ++i) {
            po[i] = this.servers[i].getPostOffice();
            bindings[i] = po[i].getBinding(SimpleString.of((String)"queue0"));
            Assertions.assertNotNull((Object)bindings[i]);
            Queue queue0 = (Queue)bindings[i].getBindable();
            Assertions.assertNotNull((Object)queue0);
            QueueConfiguration qconfig = queue0.getQueueConfiguration();
            Assertions.assertNotNull((Object)qconfig);
            qconfig.setFilterString("color = 'red'");
            po[i].updateQueue(qconfig, true);
        }
        SimpleString clusterName0 = bindings[1].getClusterName();
        RemoteQueueBinding remoteBinding = (RemoteQueueBinding)po[0].getBinding(clusterName0);
        Assertions.assertNotNull((Object)remoteBinding);
        Wait.assertEquals((Object)"color = 'red'", () -> {
            Filter filter = remoteBinding.getFilter();
            if (filter == null) {
                return filter;
            }
            return filter.getFilterString().toString();
        });
    }

    protected void setupCluster(MessageLoadBalancingType messageLoadBalancingType) throws Exception {
        this.setupClusterConnection("cluster0", "queues", messageLoadBalancingType, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster1", "queues", messageLoadBalancingType, 1, this.isNetty(), 1, 0);
    }

    protected void setRedistributionDelay(long delay) {
        AddressSettings as = new AddressSettings().setRedistributionDelay(delay);
        this.getServer(0).getAddressSettingsRepository().addMatch("queues.*", (Object)as);
        this.getServer(1).getAddressSettingsRepository().addMatch("queues.*", (Object)as);
    }

    protected void setupServers() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
    }

    protected void stopServers() throws Exception {
        this.closeAllConsumers();
        this.closeAllSessionFactories();
        this.closeAllServerLocatorsFactories();
        this.stopServers(0, 1);
        this.clearServer(0, 1);
    }
}

