/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.tests.integration.cluster.failover.ClusterWithBackupFailoverTestBase;

public class StaticClusterWithBackupFailoverTest
extends ClusterWithBackupFailoverTestBase {
    protected int[] getServerIDs() {
        return new int[]{0, 1, 2, 3, 4, 5};
    }

    protected int[] getPrimaryServerIDs() {
        return new int[]{0, 1, 2};
    }

    protected boolean isPrimaryServerID(int id) {
        for (int i : this.getPrimaryServerIDs()) {
            if (i != id) continue;
            return true;
        }
        return false;
    }

    protected int[] getBackupServerIDs() {
        return new int[]{3, 4, 5};
    }

    protected boolean isBackupServerID(int id) {
        for (int i : this.getBackupServerIDs()) {
            if (i != id) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void setupCluster(MessageLoadBalancingType messageLoadBalancingType) throws Exception {
        this.setupClusterConnectionWithBackups("cluster0", "queues", messageLoadBalancingType, 1, this.isNetty(), 0, new int[]{1, 2});
        this.setupClusterConnectionWithBackups("cluster1", "queues", messageLoadBalancingType, 1, this.isNetty(), 1, new int[]{0, 2});
        this.setupClusterConnectionWithBackups("cluster2", "queues", messageLoadBalancingType, 1, this.isNetty(), 2, new int[]{0, 1});
        this.setupClusterConnectionWithBackups("cluster0", "queues", messageLoadBalancingType, 1, this.isNetty(), 3, new int[]{1, 2});
        this.setupClusterConnectionWithBackups("cluster1", "queues", messageLoadBalancingType, 1, this.isNetty(), 4, new int[]{0, 2});
        this.setupClusterConnectionWithBackups("cluster2", "queues", messageLoadBalancingType, 1, this.isNetty(), 5, new int[]{0, 1});
    }

    protected boolean isSharedStorage() {
        return true;
    }

    @Override
    protected void setupServers() throws Exception {
        this.setupBackupServer(3, 0, this.isFileStorage(), this.haType(), this.isNetty());
        this.setupBackupServer(4, 1, this.isFileStorage(), this.haType(), this.isNetty());
        this.setupBackupServer(5, 2, this.isFileStorage(), this.haType(), this.isNetty());
        this.setupPrimaryServer(0, this.isFileStorage(), this.haType(), this.isNetty(), false);
        this.setupPrimaryServer(1, this.isFileStorage(), this.haType(), this.isNetty(), false);
        this.setupPrimaryServer(2, this.isFileStorage(), this.haType(), this.isNetty(), false);
    }
}

