/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover.lockmanager;

import com.sun.net.httpserver.HttpServer;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.component.WebServerComponent;
import org.apache.activemq.artemis.core.config.ha.DistributedLockManagerConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.ServiceComponent;
import org.apache.activemq.artemis.dto.AppDTO;
import org.apache.activemq.artemis.dto.BindingDTO;
import org.apache.activemq.artemis.dto.ComponentDTO;
import org.apache.activemq.artemis.dto.WebServerDTO;
import org.apache.activemq.artemis.lockmanager.MutableLong;
import org.apache.activemq.artemis.lockmanager.file.FileBasedLockManager;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTest;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockManagerNettyNoGroupNameReplicatedFailoverTest
extends FailoverTest {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    protected void beforeWaitForRemoteBackupSynchronization() {
    }

    private void waitForSync(ActiveMQServer server) throws Exception {
        Wait.waitFor(() -> ((ActiveMQServer)server).isReplicaSync());
    }

    @Test
    @Timeout(value=120L)
    public void testReplicatedFailback() throws Exception {
        try {
            this.beforeWaitForRemoteBackupSynchronization();
            this.waitForSync(this.backupServer.getServer());
            this.createSessionFactory();
            ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, true);
            session.createQueue(QueueConfiguration.of((SimpleString)ADDRESS));
            this.crash(session);
            this.primaryServer.start();
            this.waitForSync(this.primaryServer.getServer());
            this.waitForSync(this.backupServer.getServer());
            this.waitForServerToStart(this.primaryServer.getServer());
            session = this.createSession((ClientSessionFactory)this.sf, true, true);
            this.crash(session);
            this.primaryServer.start();
            this.waitForSync(this.primaryServer.getServer());
            this.waitForSync(this.backupServer.getServer());
            this.waitForServerToStart(this.primaryServer.getServer());
            session = this.createSession((ClientSessionFactory)this.sf, true, true);
            this.crash(session);
            this.primaryServer.start();
            this.waitForSync(this.primaryServer.getServer());
            this.primaryServer.getServer().waitForActivation(5L, TimeUnit.SECONDS);
            this.waitForSync(this.primaryServer.getServer());
            this.waitForServerToStart(this.backupServer.getServer());
            Assertions.assertTrue((boolean)this.backupServer.getServer().isStarted());
        }
        finally {
            if (this.sf != null) {
                this.sf.close();
            }
            try {
                this.primaryServer.getServer().stop();
            }
            catch (Throwable throwable) {}
            try {
                this.backupServer.getServer().stop();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplicatedFailbackBackupFromPrimaryBackToBackup() throws Exception {
        InetSocketAddress address = new InetSocketAddress("127.0.0.1", 8787);
        HttpServer httpServer = HttpServer.create(address, 100);
        httpServer.start();
        try {
            httpServer.createContext("/", t -> {
                String response = "<html><body><b>This is a unit test</b></body></html>";
                t.sendResponseHeaders(200, response.length());
                OutputStream os = t.getResponseBody();
                os.write(response.getBytes());
                os.close();
            });
            AppDTO appDTO = new AppDTO();
            appDTO.war = "console.war";
            appDTO.url = "console";
            BindingDTO bindingDTO = new BindingDTO();
            bindingDTO.uri = "http://localhost:0";
            bindingDTO.apps = new ArrayList();
            bindingDTO.apps.add(appDTO);
            WebServerDTO wdto = new WebServerDTO();
            wdto.setBindings(Collections.singletonList(bindingDTO));
            wdto.path = "console";
            WebServerComponent webServerComponent = new WebServerComponent();
            webServerComponent.configure((ComponentDTO)wdto, ".", ".");
            webServerComponent.start();
            this.backupServer.getServer().getNetworkHealthCheck().parseURIList("http://localhost:8787");
            Assertions.assertTrue((boolean)this.backupServer.getServer().getNetworkHealthCheck().isStarted());
            this.backupServer.getServer().addExternalComponent((ActiveMQComponent)webServerComponent, false);
            this.backupServer.getServer().fail(true);
            Assertions.assertTrue((boolean)this.backupServer.getServer().getNetworkHealthCheck().isStarted());
            Assertions.assertTrue((boolean)((ActiveMQComponent)this.backupServer.getServer().getExternalComponents().get(0)).isStarted());
            ((ServiceComponent)this.backupServer.getServer().getExternalComponents().get(0)).stop(true);
        }
        finally {
            httpServer.stop(0);
        }
    }

    @Override
    protected void createConfigs() throws Exception {
        this.createPluggableReplicatedConfigs();
    }

    @Override
    protected void setupHAPolicyConfiguration() {
        ((ReplicationBackupPolicyConfiguration)this.backupConfig.getHAPolicyConfiguration()).setMaxSavedReplicatedJournalsSize(2).setAllowFailBack(true);
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean primary) {
        return this.getNettyAcceptorTransportConfiguration(primary);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean primary) {
        return this.getNettyConnectorTransportConfiguration(primary);
    }

    @Override
    protected void crash(boolean waitFailure, ClientSession ... sessions) throws Exception {
        if (sessions.length > 0) {
            for (ClientSession session : sessions) {
                LockManagerNettyNoGroupNameReplicatedFailoverTest.waitForRemoteBackup(session.getSessionFactory(), 5, true, this.backupServer.getServer());
            }
        } else {
            LockManagerNettyNoGroupNameReplicatedFailoverTest.waitForRemoteBackup(null, 5, true, this.backupServer.getServer());
        }
        super.crash(waitFailure, sessions);
    }

    @Override
    protected void crash(ClientSession ... sessions) throws Exception {
        if (sessions.length > 0) {
            for (ClientSession session : sessions) {
                LockManagerNettyNoGroupNameReplicatedFailoverTest.waitForRemoteBackup(session.getSessionFactory(), 5, true, this.backupServer.getServer());
            }
        } else {
            LockManagerNettyNoGroupNameReplicatedFailoverTest.waitForRemoteBackup(null, 5, true, this.backupServer.getServer());
        }
        super.crash(sessions);
    }

    @Override
    protected void decrementActivationSequenceForForceRestartOf(TestableServer primaryServer) throws Exception {
        LockManagerNettyNoGroupNameReplicatedFailoverTest.doDecrementActivationSequenceForForceRestartOf(logger, this.nodeManager, this.managerConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doDecrementActivationSequenceForForceRestartOf(Logger log, NodeManager nodeManager, DistributedLockManagerConfiguration DistributedLockManagerConfiguration2) throws Exception {
        nodeManager.start();
        long localActivation = nodeManager.readNodeActivationSequence();
        FileBasedLockManager fileBasedPrimitiveManager = new FileBasedLockManager(DistributedLockManagerConfiguration2.getProperties());
        fileBasedPrimitiveManager.start();
        try {
            MutableLong mutableLong = fileBasedPrimitiveManager.getMutableLong(nodeManager.getNodeId().toString());
            if (!mutableLong.compareAndSet(localActivation + 1L, localActivation)) {
                throw new Exception("Failed to decrement coordinated activation sequence to:" + localActivation + ", not +1 : " + mutableLong.get());
            }
            logger.warn("Intentionally decrementing coordinated activation sequence for test, may result is lost data");
        }
        finally {
            fileBasedPrimitiveManager.stop();
            nodeManager.stop();
        }
    }
}

