/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.reattach;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.CoreAddressConfiguration;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMRegistry;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.integration.cluster.reattach.MultiThreadReattachSupportTestBase;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultiThreadRandomReattachTestBase
extends MultiThreadReattachSupportTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int RECEIVE_TIMEOUT = 30000;
    private final int LATCH_WAIT = this.getLatchWait();
    private final int NUM_THREADS = this.getNumThreads();
    protected static final SimpleString ADDRESS = SimpleString.of((String)"FailoverTestAddress");
    protected ActiveMQServer server;

    protected abstract int getNumIterations();

    @Override
    protected void start() throws Exception {
        Configuration primaryConf = this.createDefaultInVMConfig();
        this.server = this.createServer(false, primaryConf);
        this.server.getConfiguration().getAddressConfigurations().add(new CoreAddressConfiguration().setName(ADDRESS.toString()).addRoutingType(RoutingType.MULTICAST));
        this.server.start();
        this.waitForServerToStart(this.server);
    }

    protected void setBody(ClientMessage message) throws Exception {
        message.getBodyBuffer().writeBytes(new byte[250]);
    }

    protected boolean checkSize(ClientMessage message) {
        return message.getBodyBuffer().readableBytes() == 250;
    }

    @Test
    public void testA() throws Exception {
        this.runTestMultipleThreads(new MultiThreadReattachSupportTestBase.RunnableT(){

            @Override
            public void run(ClientSessionFactory sf, int threadNum) throws Exception {
                MultiThreadRandomReattachTestBase.this.doTestA(sf, threadNum);
            }
        }, this.NUM_THREADS, false);
    }

    @Test
    public void testB() throws Exception {
        this.runTestMultipleThreads(new MultiThreadReattachSupportTestBase.RunnableT(){

            @Override
            public void run(ClientSessionFactory sf, int threadNum) throws Exception {
                MultiThreadRandomReattachTestBase.this.doTestB(sf, threadNum);
            }
        }, this.NUM_THREADS, false);
    }

    @Test
    public void testC() throws Exception {
        this.runTestMultipleThreads(new MultiThreadReattachSupportTestBase.RunnableT(){

            @Override
            public void run(ClientSessionFactory sf, int threadNum) throws Exception {
                MultiThreadRandomReattachTestBase.this.doTestC(sf, threadNum);
            }
        }, this.NUM_THREADS, false);
    }

    @Test
    public void testD() throws Exception {
        this.runTestMultipleThreads(new MultiThreadReattachSupportTestBase.RunnableT(){

            @Override
            public void run(ClientSessionFactory sf, int threadNum) throws Exception {
                MultiThreadRandomReattachTestBase.this.doTestD(sf, threadNum);
            }
        }, this.NUM_THREADS, false);
    }

    @Test
    public void testE() throws Exception {
        this.runTestMultipleThreads(new MultiThreadReattachSupportTestBase.RunnableT(){

            @Override
            public void run(ClientSessionFactory sf, int threadNum) throws Exception {
                MultiThreadRandomReattachTestBase.this.doTestE(sf, threadNum);
            }
        }, this.NUM_THREADS, false);
    }

    @Test
    public void testF() throws Exception {
        this.runTestMultipleThreads(new MultiThreadReattachSupportTestBase.RunnableT(){

            @Override
            public void run(ClientSessionFactory sf, int threadNum) throws Exception {
                MultiThreadRandomReattachTestBase.this.doTestF(sf, threadNum);
            }
        }, this.NUM_THREADS, false);
    }

    @Test
    public void testG() throws Exception {
        this.runTestMultipleThreads(new MultiThreadReattachSupportTestBase.RunnableT(){

            @Override
            public void run(ClientSessionFactory sf, int threadNum) throws Exception {
                MultiThreadRandomReattachTestBase.this.doTestG(sf, threadNum);
            }
        }, this.NUM_THREADS, false);
    }

    @Test
    public void testH() throws Exception {
        this.runTestMultipleThreads(new MultiThreadReattachSupportTestBase.RunnableT(){

            @Override
            public void run(ClientSessionFactory sf, int threadNum) throws Exception {
                MultiThreadRandomReattachTestBase.this.doTestH(sf, threadNum);
            }
        }, this.NUM_THREADS, false);
    }

    @Test
    public void testI() throws Exception {
        this.runTestMultipleThreads(new MultiThreadReattachSupportTestBase.RunnableT(){

            @Override
            public void run(ClientSessionFactory sf, int threadNum) throws Exception {
                MultiThreadRandomReattachTestBase.this.doTestI(sf, threadNum);
            }
        }, this.NUM_THREADS, false);
    }

    @Test
    public void testJ() throws Exception {
        this.runTestMultipleThreads(new MultiThreadReattachSupportTestBase.RunnableT(){

            @Override
            public void run(ClientSessionFactory sf, int threadNum) throws Exception {
                MultiThreadRandomReattachTestBase.this.doTestJ(sf, threadNum);
            }
        }, this.NUM_THREADS, false);
    }

    @Test
    public void testK() throws Exception {
        this.runTestMultipleThreads(new MultiThreadReattachSupportTestBase.RunnableT(){

            @Override
            public void run(ClientSessionFactory sf, int threadNum) throws Exception {
                MultiThreadRandomReattachTestBase.this.doTestK(sf, threadNum);
            }
        }, this.NUM_THREADS, false);
    }

    @Test
    public void testL() throws Exception {
        this.runTestMultipleThreads(new MultiThreadReattachSupportTestBase.RunnableT(){

            @Override
            public void run(ClientSessionFactory sf, int threadNum) throws Exception {
                MultiThreadRandomReattachTestBase.this.doTestL(sf);
            }
        }, this.NUM_THREADS, true, 10L);
    }

    @Test
    public void testN() throws Exception {
        this.runTestMultipleThreads(new MultiThreadReattachSupportTestBase.RunnableT(){

            @Override
            public void run(ClientSessionFactory sf, int threadNum) throws Exception {
                MultiThreadRandomReattachTestBase.this.doTestN(sf, threadNum);
            }
        }, this.NUM_THREADS, false);
    }

    @Test
    public void testO() throws Exception {
        this.runTestMultipleThreads(new MultiThreadReattachSupportTestBase.RunnableT(){

            @Override
            public void run(ClientSessionFactory sf, int threadNum) throws Exception {
                MultiThreadRandomReattachTestBase.this.doTestO(sf, threadNum);
            }
        }, this.NUM_THREADS, false);
    }

    protected ClientSession createAutoCommitSession(ClientSessionFactory sf) throws Exception {
        ClientSession session = sf.createSession(false, true, true);
        session.addMetaData("someData", RandomUtil.randomString());
        session.addMetaData("someData2", RandomUtil.randomString());
        return session;
    }

    protected ClientSession createTransactionalSession(ClientSessionFactory sf) throws Exception {
        ClientSession session = sf.createSession(false, false, false);
        session.addMetaData("someData", RandomUtil.randomString());
        session.addMetaData("someData2", RandomUtil.randomString());
        return session;
    }

    protected void doTestA(ClientSessionFactory sf, int threadNum, ClientSession session2) throws Exception {
        SimpleString subName = SimpleString.of((String)("sub" + threadNum));
        ClientSession session = this.addClientSession(sf.createSession(false, true, true));
        session.createQueue(QueueConfiguration.of((SimpleString)subName).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientConsumer consumer = session.createConsumer(subName);
        int numMessages = 100;
        this.sendMessages(session, producer, 100, threadNum);
        session.start();
        MyHandler handler = new MyHandler(threadNum, 100);
        consumer.setMessageHandler((MessageHandler)handler);
        boolean ok = handler.latch.await(this.LATCH_WAIT, TimeUnit.MILLISECONDS);
        if (!ok) {
            throw new Exception("Timed out waiting for messages on handler " + System.identityHashCode(handler) + " threadnum " + threadNum);
        }
        if (handler.failure != null) {
            throw new Exception("Handler failed: " + handler.failure);
        }
        producer.close();
        consumer.close();
        session.deleteQueue(subName);
        session.close();
    }

    protected void doTestA(ClientSessionFactory sf, int threadNum) throws Exception {
        long start = System.currentTimeMillis();
        ClientSession s = sf.createSession(false, false, false);
        int numMessages = 100;
        int numSessions = 10;
        HashSet<ClientConsumer> consumers = new HashSet<ClientConsumer>();
        HashSet<ClientSession> sessions = new HashSet<ClientSession>();
        for (int i = 0; i < 10; ++i) {
            SimpleString subName = SimpleString.of((String)(threadNum + "sub" + i));
            ClientSession sessConsume = this.createAutoCommitSession(sf);
            sessConsume.start();
            sessConsume.createQueue(QueueConfiguration.of((SimpleString)subName).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
            ClientConsumer consumer = sessConsume.createConsumer(subName);
            consumers.add(consumer);
            sessions.add(sessConsume);
        }
        ClientSession sessSend = sf.createSession(false, true, true);
        ClientProducer producer = sessSend.createProducer(ADDRESS);
        this.sendMessages(sessSend, producer, 100, threadNum);
        HashSet<MyHandler> handlers = new HashSet<MyHandler>();
        for (ClientConsumer consumer : consumers) {
            MyHandler handler = new MyHandler(threadNum, 100);
            consumer.setMessageHandler((MessageHandler)handler);
            handlers.add(handler);
        }
        for (MyHandler handler : handlers) {
            boolean ok = handler.latch.await(this.LATCH_WAIT, TimeUnit.MILLISECONDS);
            if (!ok) {
                throw new Exception("Timed out waiting for messages on handler " + System.identityHashCode(handler) + " threadnum " + threadNum);
            }
            if (handler.failure == null) continue;
            throw new Exception("Handler failed: " + handler.failure);
        }
        sessSend.close();
        for (ClientSession session : sessions) {
            session.close();
        }
        for (int i = 0; i < 10; ++i) {
            SimpleString subName = SimpleString.of((String)(threadNum + "sub" + i));
            s.deleteQueue(subName);
        }
        s.close();
        long end = System.currentTimeMillis();
        logger.debug("duration {}", (Object)(end - start));
    }

    protected void doTestB(ClientSessionFactory sf, int threadNum) throws Exception {
        long start = System.currentTimeMillis();
        ClientSession s = sf.createSession(false, false, false);
        int numMessages = 100;
        int numSessions = 10;
        HashSet<ClientConsumer> consumers = new HashSet<ClientConsumer>();
        HashSet<Object> sessions = new HashSet<Object>();
        for (int i = 0; i < 10; ++i) {
            SimpleString subName = SimpleString.of((String)(threadNum + "sub" + i));
            ClientSession sessConsume = this.createAutoCommitSession(sf);
            sessConsume.createQueue(QueueConfiguration.of((SimpleString)subName).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
            ClientConsumer consumer = sessConsume.createConsumer(subName);
            consumers.add(consumer);
            sessions.add(sessConsume);
        }
        ClientSession sessSend = sf.createSession(false, true, true);
        sessSend.addMetaData("some-data", RandomUtil.randomString());
        ClientProducer producer = sessSend.createProducer(ADDRESS);
        this.sendMessages(sessSend, producer, 100, threadNum);
        for (Object session : sessions) {
            session.start();
        }
        HashSet<MyHandler> handlers = new HashSet<MyHandler>();
        for (ClientConsumer clientConsumer : consumers) {
            MyHandler handler = new MyHandler(threadNum, 100);
            clientConsumer.setMessageHandler((MessageHandler)handler);
            handlers.add(handler);
        }
        for (MyHandler myHandler : handlers) {
            boolean ok = myHandler.latch.await(this.LATCH_WAIT, TimeUnit.MILLISECONDS);
            if (!ok) {
                throw new Exception("Timed out waiting for messages on handler " + System.identityHashCode(myHandler) + " threadnum " + threadNum);
            }
            if (myHandler.failure == null) continue;
            throw new Exception("Handler failed: " + myHandler.failure);
        }
        sessSend.close();
        for (ClientSession clientSession : sessions) {
            clientSession.close();
        }
        for (int i = 0; i < 10; ++i) {
            SimpleString simpleString = SimpleString.of((String)(threadNum + "sub" + i));
            s.deleteQueue(simpleString);
        }
        s.close();
        long end = System.currentTimeMillis();
        logger.debug("duration {}", (Object)(end - start));
    }

    protected void doTestC(ClientSessionFactory sf, int threadNum) throws Exception {
        long start = System.currentTimeMillis();
        ClientSession s = sf.createSession(false, false, false);
        s.addMetaData("some-data", RandomUtil.randomString());
        int numMessages = 100;
        int numSessions = 10;
        HashSet<ClientConsumer> consumers = new HashSet<ClientConsumer>();
        HashSet<ClientSession> sessions = new HashSet<ClientSession>();
        for (int i = 0; i < 10; ++i) {
            SimpleString subName = SimpleString.of((String)(threadNum + "sub" + i));
            ClientSession sessConsume = this.createTransactionalSession(sf);
            sessConsume.start();
            sessConsume.createQueue(QueueConfiguration.of((SimpleString)subName).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
            ClientConsumer consumer = sessConsume.createConsumer(subName);
            consumers.add(consumer);
            sessions.add(sessConsume);
        }
        ClientSession sessSend = sf.createSession(false, false, false);
        sessSend.addMetaData("some-data", RandomUtil.randomString());
        ClientProducer producer = sessSend.createProducer(ADDRESS);
        this.sendMessages(sessSend, producer, 100, threadNum);
        sessSend.rollback();
        this.sendMessages(sessSend, producer, 100, threadNum);
        sessSend.commit();
        HashSet<MyHandler> handlers = new HashSet<MyHandler>();
        for (ClientConsumer consumer : consumers) {
            MyHandler handler = new MyHandler(threadNum, 100);
            consumer.setMessageHandler((MessageHandler)handler);
            handlers.add(handler);
        }
        for (MyHandler handler : handlers) {
            boolean ok = handler.latch.await(this.LATCH_WAIT, TimeUnit.MILLISECONDS);
            if (!ok) {
                throw new Exception("Timed out waiting for messages on handler " + System.identityHashCode(handler) + " threadnum " + threadNum);
            }
            if (handler.failure != null) {
                throw new Exception("Handler failed: " + handler.failure);
            }
            handler.reset();
        }
        for (ClientSession session : sessions) {
            session.rollback();
        }
        for (MyHandler handler : handlers) {
            boolean ok = handler.latch.await(this.LATCH_WAIT, TimeUnit.MILLISECONDS);
            Assertions.assertTrue((boolean)ok);
        }
        for (ClientSession session : sessions) {
            session.commit();
        }
        sessSend.close();
        for (ClientSession session : sessions) {
            session.close();
        }
        for (int i = 0; i < 10; ++i) {
            SimpleString subName = SimpleString.of((String)(threadNum + "sub" + i));
            s.deleteQueue(subName);
        }
        s.close();
        long end = System.currentTimeMillis();
        logger.debug("duration {}", (Object)(end - start));
    }

    protected void doTestD(ClientSessionFactory sf, int threadNum) throws Exception {
        long start = System.currentTimeMillis();
        ClientSession s = sf.createSession(false, false, false);
        s.addMetaData("some-data", RandomUtil.randomString());
        int numMessages = 100;
        int numSessions = 10;
        HashSet<ClientConsumer> consumers = new HashSet<ClientConsumer>();
        HashSet<Object> sessions = new HashSet<Object>();
        for (int i = 0; i < 10; ++i) {
            SimpleString subName = SimpleString.of((String)(threadNum + " sub" + i));
            ClientSession sessConsume = sf.createSession(false, false, false);
            sessConsume.addMetaData("data", RandomUtil.randomString());
            sessConsume.createQueue(QueueConfiguration.of((SimpleString)subName).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
            ClientConsumer consumer = sessConsume.createConsumer(subName);
            consumers.add(consumer);
            sessions.add(sessConsume);
        }
        ClientSession sessSend = sf.createSession(false, false, false);
        sessSend.addMetaData("some-data", RandomUtil.randomString());
        ClientProducer producer = sessSend.createProducer(ADDRESS);
        this.sendMessages(sessSend, producer, 100, threadNum);
        sessSend.rollback();
        this.sendMessages(sessSend, producer, 100, threadNum);
        sessSend.commit();
        for (Object session : sessions) {
            session.start();
        }
        HashSet<MyHandler> handlers = new HashSet<MyHandler>();
        for (ClientConsumer clientConsumer : consumers) {
            MyHandler handler = new MyHandler(threadNum, 100);
            clientConsumer.setMessageHandler((MessageHandler)handler);
            handlers.add(handler);
        }
        for (MyHandler myHandler : handlers) {
            boolean ok = myHandler.latch.await(this.LATCH_WAIT, TimeUnit.MILLISECONDS);
            if (!ok) {
                throw new Exception("Timed out waiting for messages on handler " + System.identityHashCode(myHandler) + " threadnum " + threadNum);
            }
            if (myHandler.failure == null) continue;
            throw new Exception("Handler failed: " + myHandler.failure);
        }
        handlers.clear();
        for (ClientConsumer clientConsumer : consumers) {
            clientConsumer.setMessageHandler(null);
        }
        for (ClientSession clientSession : sessions) {
            clientSession.rollback();
        }
        for (ClientConsumer clientConsumer : consumers) {
            MyHandler handler = new MyHandler(threadNum, 100);
            clientConsumer.setMessageHandler((MessageHandler)handler);
            handlers.add(handler);
        }
        for (MyHandler myHandler : handlers) {
            boolean ok = myHandler.latch.await(this.LATCH_WAIT, TimeUnit.MILLISECONDS);
            if (!ok) {
                throw new Exception("Timed out waiting for messages on handler " + System.identityHashCode(myHandler) + " threadnum " + threadNum);
            }
            if (myHandler.failure == null) continue;
            throw new Exception("Handler failed on rollback: " + myHandler.failure);
        }
        for (ClientSession clientSession : sessions) {
            clientSession.commit();
        }
        sessSend.close();
        for (ClientSession clientSession : sessions) {
            clientSession.close();
        }
        for (int i = 0; i < 10; ++i) {
            SimpleString simpleString = SimpleString.of((String)(threadNum + " sub" + i));
            s.deleteQueue(simpleString);
        }
        s.close();
        long end = System.currentTimeMillis();
        logger.debug("duration {}", (Object)(end - start));
    }

    protected void doTestE(ClientSessionFactory sf, int threadNum) throws Exception {
        long start = System.currentTimeMillis();
        ClientSession s = sf.createSession(false, false, false);
        s.addMetaData("some-data", RandomUtil.randomString());
        int numMessages = 100;
        int numSessions = 10;
        HashSet<ClientConsumer> consumers = new HashSet<ClientConsumer>();
        HashSet<Object> sessions = new HashSet<Object>();
        for (int i = 0; i < 10; ++i) {
            SimpleString subName = SimpleString.of((String)(threadNum + "sub" + i));
            ClientSession sessConsume = sf.createSession(false, true, true);
            sessConsume.addMetaData("some-data", RandomUtil.randomString());
            sessConsume.start();
            sessConsume.createQueue(QueueConfiguration.of((SimpleString)subName).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
            ClientConsumer clientConsumer = sessConsume.createConsumer(subName);
            consumers.add(clientConsumer);
            sessions.add(sessConsume);
        }
        ClientSession sessSend = sf.createSession(false, true, true);
        sessSend.addMetaData("some-data", RandomUtil.randomString());
        ClientProducer producer = sessSend.createProducer(ADDRESS);
        this.sendMessages(sessSend, producer, 100, threadNum);
        this.consumeMessages(consumers, 100, threadNum);
        sessSend.close();
        for (ClientSession clientSession : sessions) {
            clientSession.close();
        }
        for (int i = 0; i < 10; ++i) {
            SimpleString simpleString = SimpleString.of((String)(threadNum + "sub" + i));
            s.deleteQueue(simpleString);
        }
        s.close();
        long end = System.currentTimeMillis();
        logger.debug("duration {}", (Object)(end - start));
    }

    protected void doTestF(ClientSessionFactory sf, int threadNum) throws Exception {
        long start = System.currentTimeMillis();
        ClientSession s = sf.createSession(false, false, false);
        s.addMetaData("data", RandomUtil.randomString());
        int numMessages = 100;
        int numSessions = 10;
        HashSet<ClientConsumer> consumers = new HashSet<ClientConsumer>();
        HashSet<Object> sessions = new HashSet<Object>();
        for (int i = 0; i < 10; ++i) {
            SimpleString subName = SimpleString.of((String)(threadNum + "sub" + i));
            ClientSession sessConsume = sf.createSession(false, true, true);
            sessConsume.addMetaData("data", RandomUtil.randomString());
            sessConsume.createQueue(QueueConfiguration.of((SimpleString)subName).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
            ClientConsumer clientConsumer = sessConsume.createConsumer(subName);
            consumers.add(clientConsumer);
            sessions.add(sessConsume);
        }
        ClientSession sessSend = sf.createSession(false, true, true);
        sessSend.addMetaData("data", RandomUtil.randomString());
        ClientProducer producer = sessSend.createProducer(ADDRESS);
        this.sendMessages(sessSend, producer, 100, threadNum);
        for (ClientSession clientSession : sessions) {
            clientSession.start();
        }
        this.consumeMessages(consumers, 100, threadNum);
        sessSend.close();
        for (ClientSession clientSession : sessions) {
            clientSession.close();
        }
        for (int i = 0; i < 10; ++i) {
            SimpleString simpleString = SimpleString.of((String)(threadNum + "sub" + i));
            s.deleteQueue(simpleString);
        }
        s.close();
        long end = System.currentTimeMillis();
        logger.debug("duration {}", (Object)(end - start));
    }

    protected void doTestG(ClientSessionFactory sf, int threadNum) throws Exception {
        long start = System.currentTimeMillis();
        ClientSession s = sf.createSession(false, false, false);
        s.addMetaData("data", RandomUtil.randomString());
        int numMessages = 100;
        int numSessions = 10;
        HashSet<ClientConsumer> consumers = new HashSet<ClientConsumer>();
        HashSet<ClientSession> sessions = new HashSet<ClientSession>();
        for (int i = 0; i < 10; ++i) {
            SimpleString subName = SimpleString.of((String)(threadNum + "sub" + i));
            ClientSession sessConsume = sf.createSession(false, false, false);
            sessConsume.addMetaData("data", RandomUtil.randomString());
            sessConsume.start();
            sessConsume.createQueue(QueueConfiguration.of((SimpleString)subName).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
            ClientConsumer consumer = sessConsume.createConsumer(subName);
            consumers.add(consumer);
            sessions.add(sessConsume);
        }
        ClientSession sessSend = sf.createSession(false, false, false);
        sessSend.addMetaData("data", RandomUtil.randomString());
        ClientProducer producer = sessSend.createProducer(ADDRESS);
        this.sendMessages(sessSend, producer, 100, threadNum);
        sessSend.rollback();
        this.sendMessages(sessSend, producer, 100, threadNum);
        sessSend.commit();
        this.consumeMessages(consumers, 100, threadNum);
        for (ClientSession session : sessions) {
            session.rollback();
        }
        this.consumeMessages(consumers, 100, threadNum);
        for (ClientSession session : sessions) {
            session.commit();
        }
        sessSend.close();
        for (ClientSession session : sessions) {
            session.close();
        }
        for (int i = 0; i < 10; ++i) {
            SimpleString subName = SimpleString.of((String)(threadNum + "sub" + i));
            s.deleteQueue(subName);
        }
        s.close();
        long end = System.currentTimeMillis();
        logger.debug("duration {}", (Object)(end - start));
    }

    protected void doTestH(ClientSessionFactory sf, int threadNum) throws Exception {
        long start = System.currentTimeMillis();
        ClientSession s = sf.createSession(false, false, false);
        s.addMetaData("data", RandomUtil.randomString());
        int numMessages = 100;
        int numSessions = 10;
        HashSet<ClientConsumer> consumers = new HashSet<ClientConsumer>();
        HashSet<Object> sessions = new HashSet<Object>();
        for (int i = 0; i < 10; ++i) {
            SimpleString subName = SimpleString.of((String)(threadNum + "sub" + i));
            ClientSession sessConsume = sf.createSession(false, false, false);
            sessConsume.addMetaData("data", RandomUtil.randomString());
            sessConsume.createQueue(QueueConfiguration.of((SimpleString)subName).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
            ClientConsumer clientConsumer = sessConsume.createConsumer(subName);
            consumers.add(clientConsumer);
            sessions.add(sessConsume);
        }
        ClientSession sessSend = sf.createSession(false, false, false);
        sessSend.addMetaData("data", RandomUtil.randomString());
        ClientProducer producer = sessSend.createProducer(ADDRESS);
        this.sendMessages(sessSend, producer, 100, threadNum);
        sessSend.rollback();
        this.sendMessages(sessSend, producer, 100, threadNum);
        sessSend.commit();
        for (ClientSession clientSession : sessions) {
            clientSession.start();
        }
        this.consumeMessages(consumers, 100, threadNum);
        for (ClientSession clientSession : sessions) {
            clientSession.rollback();
        }
        this.consumeMessages(consumers, 100, threadNum);
        for (ClientSession clientSession : sessions) {
            clientSession.commit();
        }
        sessSend.close();
        for (ClientSession clientSession : sessions) {
            clientSession.close();
        }
        for (int i = 0; i < 10; ++i) {
            SimpleString simpleString = SimpleString.of((String)(threadNum + "sub" + i));
            s.deleteQueue(simpleString);
        }
        s.close();
        long end = System.currentTimeMillis();
        logger.debug("duration {}", (Object)(end - start));
    }

    protected void doTestI(ClientSessionFactory sf, int threadNum) throws Exception {
        ClientSession sessCreate = sf.createSession(false, true, true);
        sessCreate.addMetaData("data", RandomUtil.randomString());
        sessCreate.createQueue(QueueConfiguration.of((SimpleString)SimpleString.of((String)(threadNum + ADDRESS.toString()))).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
        ClientSession sess = sf.createSession(false, true, true);
        sess.addMetaData("data", RandomUtil.randomString());
        sess.start();
        ClientConsumer consumer = sess.createConsumer(SimpleString.of((String)(threadNum + ADDRESS.toString())));
        ClientProducer producer = sess.createProducer(ADDRESS);
        ClientMessage message = sess.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
        producer.send((Message)message);
        ClientMessage message2 = consumer.receive(30000L);
        Assertions.assertNotNull((Object)message2);
        message2.acknowledge();
        sess.close();
        sessCreate.deleteQueue(SimpleString.of((String)(threadNum + ADDRESS.toString())));
        sessCreate.close();
    }

    protected void doTestJ(ClientSessionFactory sf, int threadNum) throws Exception {
        ClientSession sessCreate = sf.createSession(false, true, true);
        sessCreate.addMetaData("data", RandomUtil.randomString());
        sessCreate.createQueue(QueueConfiguration.of((SimpleString)SimpleString.of((String)(threadNum + ADDRESS.toString()))).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
        ClientSession sess = sf.createSession(false, true, true);
        sess.addMetaData("data", RandomUtil.randomString());
        sess.start();
        ClientConsumer consumer = sess.createConsumer(SimpleString.of((String)(threadNum + ADDRESS.toString())));
        ClientProducer producer = sess.createProducer(ADDRESS);
        ClientMessage message = sess.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
        producer.send((Message)message);
        ClientMessage message2 = consumer.receive(30000L);
        Assertions.assertNotNull((Object)message2);
        message2.acknowledge();
        sess.close();
        sessCreate.deleteQueue(SimpleString.of((String)(threadNum + ADDRESS.toString())));
        sessCreate.close();
    }

    protected void doTestK(ClientSessionFactory sf, int threadNum) throws Exception {
        ClientSession s = sf.createSession(false, false, false);
        s.addMetaData("data", RandomUtil.randomString());
        s.createQueue(QueueConfiguration.of((SimpleString)SimpleString.of((String)(threadNum + ADDRESS.toString()))).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
        int numConsumers = 100;
        for (int i = 0; i < 100; ++i) {
            ClientConsumer consumer = s.createConsumer(SimpleString.of((String)(threadNum + ADDRESS.toString())));
            consumer.close();
        }
        s.deleteQueue(SimpleString.of((String)(threadNum + ADDRESS.toString())));
        s.close();
    }

    protected void doTestL(ClientSessionFactory sf) throws Exception {
        int numSessions = 100;
        for (int i = 0; i < 100; ++i) {
            ClientSession session = sf.createSession(false, false, false);
            session.addMetaData("data", RandomUtil.randomString());
            session.close();
        }
    }

    protected void doTestN(ClientSessionFactory sf, int threadNum) throws Exception {
        ClientSession sessCreate = sf.createSession(false, true, true);
        sessCreate.createQueue(QueueConfiguration.of((SimpleString)SimpleString.of((String)(threadNum + ADDRESS.toString()))).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
        ClientSession sess = sf.createSession(false, true, true);
        sess.addMetaData("data", RandomUtil.randomString());
        sess.stop();
        sess.start();
        sess.stop();
        ClientConsumer consumer = sess.createConsumer(SimpleString.of((String)(threadNum + ADDRESS.toString())));
        ClientProducer producer = sess.createProducer(ADDRESS);
        ClientMessage message = sess.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
        producer.send((Message)message);
        sess.start();
        ClientMessage message2 = consumer.receive(30000L);
        Assertions.assertNotNull((Object)message2);
        message2.acknowledge();
        sess.stop();
        sess.start();
        sess.close();
        sessCreate.deleteQueue(SimpleString.of((String)(threadNum + ADDRESS.toString())));
        sessCreate.close();
    }

    protected void doTestO(ClientSessionFactory sf, int threadNum) throws Exception {
        ClientSession sessCreate = sf.createSession(false, true, true);
        sessCreate.createQueue(QueueConfiguration.of((SimpleString)SimpleString.of((String)(threadNum + ADDRESS.toString()))).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
        ClientSession sess = sf.createSession(false, true, true);
        sess.start();
        ClientConsumer consumer = sess.createConsumer(SimpleString.of((String)(threadNum + ADDRESS.toString())));
        for (int i = 0; i < 100; ++i) {
            Assertions.assertNull((Object)consumer.receiveImmediate());
        }
        sess.close();
        sessCreate.deleteQueue(SimpleString.of((String)(threadNum + ADDRESS.toString())));
        sessCreate.close();
    }

    protected int getLatchWait() {
        return 60000;
    }

    protected int getNumThreads() {
        return 10;
    }

    private void runTestMultipleThreads(MultiThreadReattachSupportTestBase.RunnableT runnable, int numThreads, boolean failOnCreateConnection) throws Exception {
        this.runTestMultipleThreads(runnable, numThreads, failOnCreateConnection, 1000L);
    }

    private void runTestMultipleThreads(MultiThreadReattachSupportTestBase.RunnableT runnable, int numThreads, boolean failOnCreateConnection, long failDelay) throws Exception {
        this.runMultipleThreadsFailoverTest(runnable, numThreads, this.getNumIterations(), failOnCreateConnection, failDelay);
    }

    @Override
    protected ServerLocator createLocator() throws Exception {
        ServerLocator locator = this.createInVMNonHALocator().setReconnectAttempts(15).setConfirmationWindowSize(0x100000);
        return locator;
    }

    @Override
    protected void stop() throws Exception {
        ActiveMQTestBase.stopComponent((ActiveMQComponent)this.server);
        System.gc();
        Assertions.assertEquals((int)0, (int)InVMRegistry.instance.size());
    }

    private void sendMessages(ClientSession sessSend, ClientProducer producer, int numMessages, int threadNum) throws Exception {
        for (int i = 0; i < numMessages; ++i) {
            ClientMessage message = sessSend.createMessage((byte)4, false, 0L, System.currentTimeMillis(), (byte)1);
            message.putIntProperty(SimpleString.of((String)"threadnum"), threadNum);
            message.putIntProperty(SimpleString.of((String)"count"), i);
            this.setBody(message);
            producer.send((Message)message);
        }
    }

    private void consumeMessages(Set<ClientConsumer> consumers, int numMessages, int threadNum) throws Exception {
        HashMap counts = new HashMap();
        for (int i = 0; i < numMessages; ++i) {
            for (ClientConsumer consumer : consumers) {
                HashMap<Integer, Integer> consumerCounts = (HashMap<Integer, Integer>)counts.get(consumer);
                if (consumerCounts == null) {
                    consumerCounts = new HashMap<Integer, Integer>();
                    counts.put(consumer, consumerCounts);
                }
                ClientMessage msg = consumer.receive(30000L);
                Assertions.assertNotNull((Object)msg);
                int tn = (Integer)msg.getObjectProperty(SimpleString.of((String)"threadnum"));
                int cnt = (Integer)msg.getObjectProperty(SimpleString.of((String)"count"));
                Integer c = (Integer)consumerCounts.get(tn);
                if (c == null) {
                    c = cnt;
                }
                if (tn == threadNum && cnt != c) {
                    throw new Exception("Invalid count, expected " + tn + ": " + c + " got " + cnt);
                }
                Integer n = c;
                c = c + 1;
                if (c == numMessages) {
                    c = 0;
                }
                consumerCounts.put(tn, c);
                msg.acknowledge();
            }
        }
    }

    private class MyHandler
    implements MessageHandler {
        CountDownLatch latch = new CountDownLatch(1);
        private final Map<Integer, Integer> counts = new HashMap<Integer, Integer>();
        volatile String failure;
        final int tn;
        final int numMessages;
        volatile boolean done;

        synchronized void reset() {
            this.counts.clear();
            this.done = false;
            this.failure = null;
            this.latch = new CountDownLatch(1);
        }

        MyHandler(int threadNum, int numMessages) {
            this.tn = threadNum;
            this.numMessages = numMessages;
        }

        public synchronized void onMessage(ClientMessage message) {
            try {
                message.acknowledge();
            }
            catch (ActiveMQException me) {
                logger.error("Failed to process", (Throwable)me);
            }
            if (this.done) {
                return;
            }
            int threadNum = (Integer)message.getObjectProperty(SimpleString.of((String)"threadnum"));
            int cnt = (Integer)message.getObjectProperty(SimpleString.of((String)"count"));
            Integer c = this.counts.get(threadNum);
            if (c == null) {
                c = cnt;
            }
            if (this.tn == threadNum && cnt != c) {
                this.failure = "Invalid count, expected " + threadNum + ":" + c + " got " + cnt;
                logger.error(this.failure);
                this.latch.countDown();
            }
            if (!MultiThreadRandomReattachTestBase.this.checkSize(message)) {
                this.failure = "Invalid size on message";
                logger.error(this.failure);
                this.latch.countDown();
            }
            if (this.tn == threadNum && c == this.numMessages - 1) {
                this.done = true;
                this.latch.countDown();
            }
            Integer n = c;
            c = c + 1;
            if (c == this.numMessages) {
                c = 0;
            }
            this.counts.put(threadNum, c);
        }
    }
}

