/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.restart;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterRestartTest
extends ClusterTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    public void testRestartWithQueuesCreateInDiffOrder() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0);
        this.startServers(0, 1);
        logger.debug("server 0 = {}", (Object)this.getServer(0).getNodeID());
        logger.debug("server 1 = {}", (Object)this.getServer(1).getNodeID());
        this.setupSessionFactory(0, this.isNetty(), 15);
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(0, "queues.testaddress2", "queue0", null, false);
        this.createQueue(0, "queues.testaddress2", "queue1", null, false);
        this.createQueue(0, "queues.testaddress2", "queue2", null, false);
        this.createQueue(0, "queues.testaddress2", "queue3", null, false);
        this.createQueue(0, "queues.testaddress2", "queue4", null, false);
        this.createQueue(0, "queues.testaddress2", "queue5", null, false);
        this.createQueue(0, "queues.testaddress2", "queue6", null, false);
        this.createQueue(0, "queues.testaddress2", "queue7", null, false);
        this.createQueue(0, "queues.testaddress2", "queue8", null, false);
        this.createQueue(0, "queues.testaddress2", "queue9", null, false);
        this.createQueue(0, "queues.testaddress", "queue10", null, true);
        this.createQueue(1, "queues.testaddress", "queue10", null, true);
        this.addConsumer(0, 0, "queue10", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 1, 0, false);
        this.waitForBindings(1, "queues.testaddress", 1, 1, false);
        this.printBindings(2);
        this.sendInRange(1, "queues.testaddress", 0, 10, true, null);
        this.stopServers(0);
        Thread.sleep(2000L);
        this.startServers(0);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 1, 0, false);
        this.waitForBindings(1, "queues.testaddress", 1, 1, false);
        this.printBindings(2);
        this.sendInRange(1, "queues.testaddress", 10, 20, false, null);
        this.verifyReceiveAllInRange(0, 20, 0);
        logger.debug("*****************************************************************************");
    }

    @Test
    public void testRestartWithQueuesCreateInDiffOrder2() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0);
        this.startServers(0, 1);
        logger.debug("server 0 = {}", (Object)this.getServer(0).getNodeID());
        logger.debug("server 1 = {}", (Object)this.getServer(1).getNodeID());
        this.setupSessionFactory(0, this.isNetty(), 15);
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(0, "queues.testaddress2", "queue0", null, false);
        this.createQueue(0, "queues.testaddress2", "queue1", null, false);
        this.createQueue(0, "queues.testaddress2", "queue2", null, false);
        this.createQueue(0, "queues.testaddress2", "queue3", null, false);
        this.createQueue(0, "queues.testaddress2", "queue4", null, false);
        this.createQueue(0, "queues.testaddress2", "queue5", null, false);
        this.createQueue(0, "queues.testaddress2", "queue6", null, false);
        this.createQueue(0, "queues.testaddress2", "queue7", null, false);
        this.createQueue(0, "queues.testaddress2", "queue8", null, false);
        this.createQueue(0, "queues.testaddress2", "queue9", null, false);
        this.createQueue(0, "queues.testaddress", "queue10", null, true);
        this.createQueue(1, "queues.testaddress", "queue10", null, true);
        this.waitForBindings(0, "queues.testaddress", 1, 0, true);
        this.waitForBindings(1, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 1, 0, false);
        this.waitForBindings(1, "queues.testaddress", 1, 0, false);
        this.printBindings(2);
        this.sendInRange(1, "queues.testaddress", 0, 10, true, null);
        logger.debug("stopping******************************************************");
        this.stopServers(0);
        this.sendInRange(1, "queues.testaddress", 10, 20, true, null);
        logger.debug("stopped******************************************************");
        this.startServers(0);
        this.waitForBindings(0, "queues.testaddress", 1, 0, true);
        this.waitForBindings(1, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 1, 0, false);
        this.waitForBindings(1, "queues.testaddress", 1, 0, false);
        this.printBindings(2);
        this.addConsumer(0, 1, "queue10", null);
        this.addConsumer(1, 0, "queue10", null);
        this.verifyReceiveRoundRobin(0, 20, 0, 1);
        logger.debug("*****************************************************************************");
    }

    private void printBindings(int num) throws Exception {
        for (int i = 0; i < num; ++i) {
            Collection bindings0 = this.getServer(i).getPostOffice().getBindingsForAddress(SimpleString.of((String)"queues.testaddress")).getBindings();
            for (Binding binding : bindings0) {
                logger.debug("{} on node {} at {}", new Object[]{binding, i, binding.getID()});
            }
        }
    }

    public boolean isNetty() {
        return true;
    }
}

