/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.topology;

import java.util.ArrayList;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.client.impl.Topology;
import org.apache.activemq.artemis.core.client.impl.TopologyMemberImpl;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NonHATopologyTest
extends ActiveMQTestBase {
    @Test
    public void testNetty() throws Exception {
        this.internalTest(true);
    }

    @Test
    public void testInVM() throws Exception {
        this.internalTest(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalTest(boolean isNetty) throws Exception {
        ActiveMQServer server = null;
        ServerLocatorInternal locator = null;
        try {
            server = this.createServer(false, isNetty);
            if (!isNetty) {
                server.getConfiguration().getAcceptorConfigurations().add(new TransportConfiguration(NETTY_ACCEPTOR_FACTORY));
                server.getConfiguration().getConnectorConfigurations().put("netty", new TransportConfiguration(NETTY_CONNECTOR_FACTORY));
                ArrayList<String> list = new ArrayList<String>();
                list.add("netty");
                Configuration config = server.getConfiguration();
                config.getClusterConfigurations().add(new ClusterConnectionConfiguration().setName("tst").setAddress("jms").setConnectorName("netty").setRetryInterval(1000L).setConfirmationWindowSize(1000).setMessageLoadBalancingType(MessageLoadBalancingType.ON_DEMAND).setStaticConnectors(list).setAllowDirectConnectionsOnly(true));
            }
            server.start();
            locator = (ServerLocatorInternal)this.createNonHALocator(isNetty);
            ClientSessionFactory factory = this.createSessionFactory((ServerLocator)locator);
            Topology topology = locator.getTopology();
            Assertions.assertEquals((int)1, (int)topology.getMembers().size());
            factory.close();
            TopologyMemberImpl member = (TopologyMemberImpl)topology.getMembers().iterator().next();
            if (isNetty) {
                Assertions.assertEquals((Object)NettyConnectorFactory.class.getName(), (Object)member.getPrimary().getFactoryClassName());
            } else {
                Assertions.assertEquals((Object)InVMConnectorFactory.class.getName(), (Object)member.getPrimary().getFactoryClassName());
            }
        }
        finally {
            try {
                locator.close();
            }
            catch (Exception exception) {}
            try {
                server.stop();
            }
            catch (Exception exception) {}
            server = null;
            locator = null;
        }
    }
}

