/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.divert;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.jms.client.ActiveMQConnection;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.ReplicatedBackupUtils;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ReplicationWithDivertTest
extends ActiveMQTestBase {
    public static final String JMS_SOURCE_QUEUE = "Queue";
    public static final String SOURCE_QUEUE = "Queue";
    public static final String JMS_TARGET_QUEUE = "DestQueue";
    public static final String TARGET_QUEUE = "DestQueue";
    public static int messageChunkCount = 0;
    private static ActiveMQServer backupServer;
    private static ActiveMQServer primaryServer;
    ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://localhost:61616?minLargeMessageSize=10000&HA=true&retryInterval=100&reconnectAttempts=-1&producerWindowSize=10000");
    ActiveMQConnection connection;
    Session session;
    Queue queue;
    Queue targetQueue;
    MessageProducer producer;
    Configuration backupConfig;
    Configuration primaryConfig;
    static final ReusableLatch flagChunkEntered;
    static final ReusableLatch flagChunkWait;
    static final ReusableLatch flagSyncEntered;
    static final ReusableLatch flagSyncWait;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        flagChunkEntered.setCount(1);
        flagChunkWait.setCount(1);
        flagSyncEntered.setCount(1);
        flagSyncWait.setCount(1);
        messageChunkCount = 0;
        TransportConfiguration primaryConnector = TransportConfigurationUtils.getNettyConnector(true, 0);
        TransportConfiguration primaryAcceptor = TransportConfigurationUtils.getNettyAcceptor(true, 0);
        TransportConfiguration backupConnector = TransportConfigurationUtils.getNettyConnector(false, 0);
        TransportConfiguration backupAcceptor = TransportConfigurationUtils.getNettyAcceptor(false, 0);
        this.backupConfig = this.createDefaultInVMConfig().setBindingsDirectory(this.getBindingsDir(0, true)).setJournalDirectory(this.getJournalDir(0, true)).setPagingDirectory(this.getPageDir(0, true)).setLargeMessagesDirectory(this.getLargeMessagesDir(0, true));
        this.backupConfig.addQueueConfiguration(QueueConfiguration.of((String)"Queue").setRoutingType(RoutingType.ANYCAST));
        this.backupConfig.addQueueConfiguration(QueueConfiguration.of((String)"DestQueue").setRoutingType(RoutingType.ANYCAST));
        DivertConfiguration divertConfiguration = new DivertConfiguration().setName("Test").setAddress("Queue").setForwardingAddress("DestQueue").setRoutingName("Test");
        this.primaryConfig = this.createDefaultInVMConfig();
        this.primaryConfig.addQueueConfiguration(QueueConfiguration.of((String)"Queue").setRoutingType(RoutingType.ANYCAST));
        this.primaryConfig.addQueueConfiguration(QueueConfiguration.of((String)"DestQueue").setRoutingType(RoutingType.ANYCAST));
        this.primaryConfig.addDivertConfiguration(divertConfiguration);
        this.backupConfig.addDivertConfiguration(divertConfiguration);
        ReplicatedBackupUtils.configureReplicationPair(this.backupConfig, backupConnector, backupAcceptor, this.primaryConfig, primaryConnector, primaryAcceptor);
        primaryServer = this.createServer(this.primaryConfig);
        primaryServer.start();
        this.startBackup();
        this.waitForServerToStart(primaryServer);
        Assertions.assertEquals((int)10000, (int)this.factory.getMinLargeMessageSize());
        Assertions.assertEquals((int)10000, (int)this.factory.getProducerWindowSize());
        Assertions.assertEquals((long)100L, (long)this.factory.getRetryInterval());
        Assertions.assertEquals((int)-1, (int)this.factory.getReconnectAttempts());
        Assertions.assertTrue((boolean)this.factory.isHA());
        this.connection = (ActiveMQConnection)this.factory.createConnection();
        this.session = this.connection.createSession(true, 0);
        this.queue = this.session.createQueue("Queue");
        this.targetQueue = this.session.createQueue("DestQueue");
        this.producer = this.session.createProducer((Destination)this.queue);
    }

    private void startBackup() throws Exception {
        backupServer = this.createServer(this.backupConfig);
        backupServer.start();
        this.waitForServerToStart(backupServer);
    }

    @AfterEach
    public void stopServers() throws Exception {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (backupServer != null) {
            backupServer.stop();
            backupServer = null;
        }
        if (primaryServer != null) {
            primaryServer.stop();
            primaryServer = null;
        }
        primaryServer = null;
        backupServer = null;
    }

    @Test
    public void testSendLargeMessage() throws Exception {
        int i;
        MapMessage message;
        int msgi;
        CountDownLatch failedOver = new CountDownLatch(1);
        this.connection.setFailoverListener(eventType -> failedOver.countDown());
        int numberOfMessage = 5;
        MapMessage message2 = this.createLargeMessage();
        Thread t = new Thread(() -> {
            try {
                for (int i = 0; i < 5; ++i) {
                    this.producer.send((Message)message2);
                    this.session.commit();
                }
            }
            catch (JMSException expected) {
                expected.printStackTrace();
            }
        });
        t.start();
        t.join(10000L);
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        this.connection.start();
        for (msgi = 0; msgi < 5; ++msgi) {
            message = (MapMessage)consumer.receive(5000L);
            Assertions.assertNotNull((Object)message);
            for (i = 0; i < 10; ++i) {
                Assertions.assertEquals((int)204800, (int)message.getBytes("test" + i).length);
            }
            this.session.commit();
        }
        consumer.close();
        Assertions.assertFalse((boolean)t.isAlive());
        primaryServer.fail(true);
        Assertions.assertTrue((boolean)failedOver.await(10L, TimeUnit.SECONDS));
        consumer = this.session.createConsumer((Destination)this.targetQueue);
        this.connection.start();
        for (msgi = 0; msgi < 5; ++msgi) {
            message = (MapMessage)consumer.receive(5000L);
            Assertions.assertNotNull((Object)message);
            for (i = 0; i < 10; ++i) {
                Assertions.assertEquals((int)204800, (int)message.getBytes("test" + i).length);
            }
            this.session.commit();
        }
        consumer.close();
    }

    private MapMessage createLargeMessage() throws JMSException {
        MapMessage message = this.session.createMapMessage();
        for (int i = 0; i < 10; ++i) {
            message.setBytes("test" + i, new byte[204800]);
        }
        return message;
    }

    static {
        flagChunkEntered = new ReusableLatch(1);
        flagChunkWait = new ReusableLatch(1);
        flagSyncEntered = new ReusableLatch(1);
        flagSyncWait = new ReusableLatch(1);
    }
}

