/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.client;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.apache.commons.lang3.RandomUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SlowLargeMessageConsumerTest
extends JMSTestBase {
    private static final String TOPIC = "SlowLargeMessageConsumerTopic";

    @Override
    protected void extraServerConfig(ActiveMQServer server) {
        server.getConfiguration().getAddressSettings().put(TOPIC, new AddressSettings().setExpiryDelay(Long.valueOf(100L)).setMaxSizeBytes(1024L));
    }

    @Test
    public void ensureSlowConsumerOfLargeMessageNeverGetsStuck() throws Exception {
        try (Connection conn = this.cf.createConnection();){
            conn.start();
            try (Session sessionConsumer = conn.createSession(false, 2);
                 Session sessionProducer = conn.createSession(false, 2);){
                Topic topic = sessionConsumer.createTopic(TOPIC);
                MessageConsumer consumer = sessionConsumer.createConsumer((Destination)topic);
                AtomicBoolean slow = new AtomicBoolean(true);
                CountDownLatch messageReceived = new CountDownLatch(1);
                consumer.setMessageListener(message -> {
                    if (slow.get()) {
                        try {
                            TimeUnit.MILLISECONDS.sleep(50L);
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                        }
                    } else {
                        messageReceived.countDown();
                    }
                });
                MessageProducer producer = sessionProducer.createProducer((Destination)topic);
                int msgSize = 524288;
                for (int i = 0; i < 100; ++i) {
                    producer.send((Message)sessionProducer.createObjectMessage((Serializable)RandomUtils.nextBytes((int)msgSize)));
                    TimeUnit.MILLISECONDS.sleep(25L);
                }
                TimeUnit.MILLISECONDS.sleep(100L);
                slow.set(false);
                producer.send((Message)sessionProducer.createObjectMessage((Serializable)RandomUtils.nextBytes((int)msgSize)));
                Assertions.assertTrue((boolean)messageReceived.await(500L, TimeUnit.MILLISECONDS));
            }
        }
    }
}

