/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.cluster;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.JMSClusteredTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AutoCreateQueueClusterTest
extends JMSClusteredTestBase {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.jmsServer1.getActiveMQServer().setIdentity("Server 1");
        this.jmsServer2.getActiveMQServer().setIdentity("Server 2");
    }

    @Override
    protected boolean enablePersistence() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoCreate() throws Exception {
        ((AddressSettings)this.server1.getAddressSettingsRepository().getMatch("#")).setAutoCreateQueues(Boolean.valueOf(true)).setAutoCreateAddresses(Boolean.valueOf(true)).setRedistributionDelay(0L);
        ((AddressSettings)this.server2.getAddressSettingsRepository().getMatch("#")).setAutoCreateQueues(Boolean.valueOf(true)).setAutoCreateAddresses(Boolean.valueOf(true)).setRedistributionDelay(0L);
        Connection conn1 = this.cf1.createConnection();
        Connection conn2 = this.cf2.createConnection();
        conn1.start();
        conn2.start();
        try {
            Session session1 = conn1.createSession(false, 1);
            Session session2 = conn2.createSession(false, 1);
            MessageProducer prod1 = session1.createProducer((Destination)ActiveMQJMSClient.createQueue((String)"myQueue"));
            prod1.setDeliveryMode(2);
            prod1.send((Message)session1.createTextMessage("m1"));
            MessageConsumer cons2 = session2.createConsumer((Destination)ActiveMQJMSClient.createQueue((String)"myQueue"));
            TextMessage received = (TextMessage)cons2.receive(5000L);
            Assertions.assertNotNull((Object)received);
            Assertions.assertEquals((Object)"m1", (Object)received.getText());
            cons2.close();
        }
        finally {
            conn1.close();
            conn2.close();
        }
    }
}

