/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.cluster;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TextMessage;
import org.apache.activemq.artemis.tests.util.JMSClusteredTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TemporaryQueueClusterTest
extends JMSClusteredTestBase {
    public static final String QUEUE_NAME = "target";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClusteredQueue() throws Exception {
        this.jmsServer1.createQueue(false, QUEUE_NAME, null, true, new String[]{"/queue/target"});
        this.jmsServer2.createQueue(false, QUEUE_NAME, null, true, new String[]{"/queue/target"});
        Connection conn1 = this.cf1.createConnection();
        Connection conn2 = this.cf2.createConnection();
        conn1.start();
        conn2.start();
        try {
            Session session1 = conn1.createSession(false, 1);
            Queue targetQueue1 = session1.createQueue(QUEUE_NAME);
            Session session2 = conn2.createSession(false, 1);
            Queue targetQueue2 = session2.createQueue(QUEUE_NAME);
            this.waitForBindings(this.jmsServer1.getActiveMQServer(), QUEUE_NAME, true, 1, 0, 2000L);
            this.waitForBindings(this.jmsServer1.getActiveMQServer(), QUEUE_NAME, true, 1, 0, 2000L);
            this.waitForBindings(this.jmsServer2.getActiveMQServer(), QUEUE_NAME, false, 1, 0, 2000L);
            this.waitForBindings(this.jmsServer1.getActiveMQServer(), QUEUE_NAME, false, 1, 0, 2000L);
            MessageProducer prod1 = session1.createProducer((Destination)targetQueue1);
            MessageConsumer cons2 = session2.createConsumer((Destination)targetQueue2);
            TextMessage msg = session1.createTextMessage("hello");
            prod1.send((Message)msg);
            prod1.send((Message)msg);
            TextMessage msgReceived = (TextMessage)cons2.receive(5000L);
            Assertions.assertNotNull((Object)msgReceived);
            Assertions.assertEquals((Object)msgReceived.getText(), (Object)msg.getText());
        }
        finally {
            conn1.close();
            conn2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTemporaryQueue() throws Exception {
        this.jmsServer1.createQueue(false, QUEUE_NAME, null, false, new String[]{"/queue/target"});
        this.jmsServer2.createQueue(false, QUEUE_NAME, null, false, new String[]{"/queue/target"});
        Connection conn1 = this.cf1.createConnection();
        Connection conn2 = this.cf2.createConnection();
        conn1.start();
        conn2.start();
        try {
            TextMessage received;
            int i;
            Session session1 = conn1.createSession(false, 1);
            Queue targetQueue1 = session1.createQueue(QUEUE_NAME);
            TemporaryQueue tempQueue = session1.createTemporaryQueue();
            Session session2 = conn2.createSession(false, 1);
            Queue targetQueue2 = session2.createQueue(QUEUE_NAME);
            this.waitForBindings(this.jmsServer1.getActiveMQServer(), QUEUE_NAME, true, 1, 0, 2000L);
            this.waitForBindings(this.jmsServer1.getActiveMQServer(), QUEUE_NAME, true, 1, 0, 2000L);
            this.waitForBindings(this.jmsServer2.getActiveMQServer(), QUEUE_NAME, false, 1, 0, 2000L);
            this.waitForBindings(this.jmsServer1.getActiveMQServer(), QUEUE_NAME, false, 1, 0, 2000L);
            MessageConsumer tempCons1 = session1.createConsumer((Destination)tempQueue);
            this.waitForBindings(this.jmsServer1.getActiveMQServer(), tempQueue.getQueueName(), true, 1, 1, 2000L);
            this.waitForBindings(this.jmsServer2.getActiveMQServer(), tempQueue.getQueueName(), false, 1, 0, 2000L);
            MessageProducer prod1 = session1.createProducer((Destination)targetQueue1);
            MessageConsumer cons2 = session2.createConsumer((Destination)targetQueue2);
            for (i = 0; i < 10; ++i) {
                TextMessage message = session1.createTextMessage("" + i);
                message.setJMSReplyTo((Destination)tempQueue);
                prod1.send((Message)message);
            }
            for (i = 0; i < 10; ++i) {
                if (i % 2 != 0) continue;
                received = (TextMessage)cons2.receive(5000L);
                MessageProducer tempProducer = session2.createProducer(received.getJMSReplyTo());
                tempProducer.send((Message)session2.createTextMessage(">>> " + received.getText()));
                tempProducer.close();
            }
            for (i = 0; i < 10; ++i) {
                if (i % 2 != 0) continue;
                received = (TextMessage)tempCons1.receive(5000L);
                Assertions.assertNotNull((Object)received);
            }
        }
        finally {
            conn1.close();
            conn2.close();
        }
        this.jmsServer1.destroyQueue(QUEUE_NAME);
        this.jmsServer2.destroyQueue(QUEUE_NAME);
    }
}

