/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.connection;

import jakarta.jms.Connection;
import jakarta.jms.Session;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConcurrentSessionCloseTest
extends JMSTestBase {
    private ActiveMQConnectionFactory cf;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.cf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
    }

    @Test
    public void testConcurrentClose() throws Exception {
        final Connection con = this.cf.createConnection();
        for (int j = 0; j < 100; ++j) {
            int i;
            final AtomicBoolean failed = new AtomicBoolean(false);
            int threadCount = 10;
            ThreadGroup group = new ThreadGroup("Test");
            Thread[] threads = new Thread[threadCount];
            for (i = 0; i < threadCount; ++i) {
                threads[i] = new Thread(group, "thread " + i){

                    @Override
                    public void run() {
                        try {
                            con.start();
                            Session session = con.createSession(false, 1);
                            session.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            failed.set(true);
                        }
                    }
                };
                threads[i].start();
            }
            for (i = 0; i < threadCount; ++i) {
                threads[i].join();
            }
            Assertions.assertFalse((boolean)failed.get());
        }
    }
}

