/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.multiprotocol;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MessageConsumer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.plugin.impl.ConnectionPeriodicExpiryPlugin;
import org.apache.activemq.artemis.tests.integration.jms.multiprotocol.MultiprotocolJMSClientTestSupport;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPeriodicExpiryPluginTest
extends MultiprotocolJMSClientTestSupport {
    protected static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    protected void addConfiguration(ActiveMQServer server) throws Exception {
        ConnectionPeriodicExpiryPlugin plugin = new ConnectionPeriodicExpiryPlugin();
        plugin.setPeriodSeconds(2L);
        plugin.setAccuracyWindowSeconds(1);
        plugin.setAcceptorMatchRegex("netty-acceptor");
        server.getConfiguration().getBrokerPlugins().add(plugin);
    }

    @Test
    @Timeout(value=5L)
    public void testAMQP() throws Exception {
        Connection connection = this.createConnection();
        this.testExpiry(connection);
    }

    @Test
    @Timeout(value=5L)
    public void testCore() throws Exception {
        Connection connection = this.createCoreConnection();
        this.testExpiry(connection);
    }

    @Test
    @Timeout(value=5L)
    public void testOpenWire() throws Exception {
        Connection connection = this.createOpenWireConnection();
        this.testExpiry(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testExpiry(Connection connection) throws JMSException, InterruptedException {
        try {
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue(this.getQueueName());
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            consumer.setMessageListener(message -> {});
            CountDownLatch gotExpired = new CountDownLatch(1);
            connection.setExceptionListener(exception -> gotExpired.countDown());
            Assertions.assertFalse((boolean)gotExpired.await(1500L, TimeUnit.MILLISECONDS));
            Wait.assertTrue(() -> gotExpired.await(100L, TimeUnit.MILLISECONDS), (long)4000L, (long)100L);
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception exception2) {}
        }
    }
}

