/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.multiprotocol;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameter;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.jms.multiprotocol.MultiprotocolJMSClientTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class JMSSharedConsumerTest
extends MultiprotocolJMSClientTestSupport {
    @Parameter(index=0)
    public boolean amqpUseCoreSubscriptionNaming;

    @Parameters(name="{index}: amqpUseCoreSubscriptionNaming={0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({true}, {false});
    }

    @Override
    protected void addConfiguration(ActiveMQServer server) {
        server.getConfiguration().setAmqpUseCoreSubscriptionNaming(this.amqpUseCoreSubscriptionNaming);
    }

    private void testSharedConsumer(Connection connection1, Connection connection2) throws Exception {
        this.testSharedConsumer(connection1, connection2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSharedConsumer(Connection connection1, Connection connection2, boolean amqpQueueName) throws Exception {
        try {
            Session session1 = connection1.createSession(false, 1);
            Session session2 = connection2.createSession(false, 1);
            Topic topic = session1.createTopic(this.getTopicName());
            Topic topic2 = session2.createTopic(this.getTopicName());
            MessageConsumer consumer1 = session1.createSharedConsumer(topic, "SharedConsumer");
            MessageConsumer consumer2 = session2.createSharedConsumer(topic2, "SharedConsumer");
            MessageProducer producer = session1.createProducer((Destination)topic);
            producer.setDeliveryMode(2);
            connection1.start();
            TextMessage message = session1.createTextMessage();
            message.setText("hello");
            producer.send((Message)message);
            Message message1 = consumer1.receive(100L);
            Message message2 = consumer2.receive(100L);
            Message received = null;
            if (message1 != null) {
                Assertions.assertNull((Object)message2, (String)"Message should only be delivered once per subscribtion but see twice");
                received = message1;
            } else {
                received = message2;
            }
            Assertions.assertNotNull((Object)received, (String)"Should have received a message by now.");
            Assertions.assertTrue((boolean)(received instanceof TextMessage), (String)"Should be an instance of TextMessage");
            String consumerQueueName = "nonDurable.SharedConsumer";
            if (amqpQueueName) {
                consumerQueueName = "SharedConsumer:shared-volatile:global";
            }
            QueueBinding queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.of((String)consumerQueueName));
            Assertions.assertTrue((boolean)queueBinding.getQueue().isTemporary());
        }
        finally {
            connection1.close();
            connection2.close();
        }
    }

    @TestTemplate
    @Timeout(value=30L)
    public void testSharedConsumer() throws Exception {
        Connection connection = this.createConnection();
        Connection connection2 = this.createConnection();
        this.testSharedConsumer(connection, connection2, !this.amqpUseCoreSubscriptionNaming);
    }

    @TestTemplate
    @Timeout(value=30L)
    public void testSharedConsumerWithArtemisClient() throws Exception {
        Connection connection = this.createCoreConnection();
        Connection connection2 = this.createCoreConnection();
        this.testSharedConsumer(connection, connection2);
    }

    @TestTemplate
    @Timeout(value=30L)
    public void testSharedConsumerWithAMQPClientAndArtemisClient() throws Exception {
        Assumptions.assumeTrue((boolean)this.amqpUseCoreSubscriptionNaming);
        Connection connection = this.createConnection();
        Connection connection2 = this.createCoreConnection();
        this.testSharedConsumer(connection, connection2);
    }

    @TestTemplate
    @Timeout(value=30L)
    public void testSharedConsumerWithArtemisClientAndAMQPClient() throws Exception {
        Assumptions.assumeTrue((boolean)this.amqpUseCoreSubscriptionNaming);
        Connection connection = this.createCoreConnection();
        Connection connection2 = this.createConnection();
        this.testSharedConsumer(connection, connection2);
    }
}

