/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import java.util.HashMap;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.integration.management.ManagementTestBase;
import org.apache.activemq.artemis.utils.Base64;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LargeMessageOverManagementTest
extends ManagementTestBase {
    private ClientSession session;
    private ServerLocator locator;
    private ClientSessionFactory sf;
    private ActiveMQServer server;

    protected AddressControl createManagementControl(SimpleString address) throws Exception {
        return ManagementControlHelper.createAddressControl(address, this.mbeanServer);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        ConfigurationImpl config = this.createBasicConfig();
        TransportConfiguration acceptorConfig = LargeMessageOverManagementTest.createTransportConfiguration(false, true, LargeMessageOverManagementTest.generateParams(0, false));
        config.addAcceptorConfiguration(acceptorConfig);
        this.server = this.createServer(true, (Configuration)config);
        this.server.setMBeanServer(this.mbeanServer);
        this.server.start();
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true);
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.sf.createSession(false, true, false);
        this.session.start();
        this.addClientSession(this.session);
    }

    @Test
    public void testSendOverSizeMessageOverQueueControl() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString emptyqueue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address));
        this.session.createQueue(QueueConfiguration.of((SimpleString)emptyqueue).setAddress(address));
        QueueControl queueControl = this.createManagementControl(address, queue);
        int bodySize = (int)this.server.getStorageManager().getMaxRecordSize() + 100;
        byte[] bigData = this.createBytesData(bodySize);
        queueControl.sendMessage(new HashMap(), 4, Base64.encodeBytes((byte[])bigData), true, "myUser", "myPassword");
        ClientConsumer consumer = this.session.createConsumer(queue);
        ClientMessage message = consumer.receive(1000L);
        Assertions.assertNotNull((Object)message);
        Assertions.assertEquals((int)bigData.length, (int)message.getBodySize());
        Assertions.assertTrue((boolean)message.isLargeMessage());
        byte[] bytesRead = new byte[bigData.length];
        message.getBodyBuffer().readBytes(bytesRead);
        for (int i = 0; i < bytesRead.length; ++i) {
            Assertions.assertEquals((byte)bytesRead[i], (byte)bigData[i]);
        }
        consumer.close();
        consumer = this.session.createConsumer(emptyqueue);
        Assertions.assertNull((Object)consumer.receiveImmediate());
    }

    @Test
    public void testSendOverSizeMessageOverAddressControl() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        this.session.createAddress(address, RoutingType.ANYCAST, false);
        AddressControl addressControl = this.createManagementControl(address);
        this.session.createQueue(QueueConfiguration.of((SimpleString)address).setRoutingType(RoutingType.ANYCAST));
        int bodySize = this.server.getConfiguration().getJournalBufferSize_AIO();
        byte[] bigData = this.createBytesData(bodySize);
        addressControl.sendMessage(null, 4, Base64.encodeBytes((byte[])bigData), false, null, null);
        ClientConsumer consumer = this.session.createConsumer(address);
        ClientMessage message = consumer.receive(1000L);
        Assertions.assertNotNull((Object)message);
        Assertions.assertEquals((int)bigData.length, (int)message.getBodySize());
        Assertions.assertTrue((boolean)message.isLargeMessage());
        byte[] bytesRead = new byte[bigData.length];
        message.getBodyBuffer().readBytes(bytesRead);
        for (int i = 0; i < bytesRead.length; ++i) {
            Assertions.assertEquals((byte)bytesRead[i], (byte)bigData[i]);
        }
    }

    byte[] createBytesData(int nbytes) {
        byte[] result = new byte[nbytes];
        for (int i = 0; i < nbytes; ++i) {
            result[i] = RandomUtil.randomByte();
        }
        return result;
    }
}

