/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.server.plugin.impl.NotificationActiveMQServerPlugin;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.tests.integration.management.SecurityNotificationTest;
import org.apache.activemq.artemis.tests.integration.security.SecurityTest;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SSLSecurityNotificationTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ClientSession adminSession;
    private ClientConsumer notifConsumer;
    private SimpleString notifQueue;

    @Test
    public void testSECURITY_AUTHENTICATION_VIOLATION() throws Exception {
        TransportConfiguration tc = new TransportConfiguration(NETTY_CONNECTOR_FACTORY);
        tc.getParams().put("sslEnabled", true);
        tc.getParams().put("trustStorePath", "server-ca-truststore.jks");
        tc.getParams().put("trustStorePassword", "securepass");
        tc.getParams().put("keyStorePath", "unknown-client-keystore.jks");
        tc.getParams().put("keyStorePassword", "securepass");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{tc}));
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(locator));
        SSLSecurityNotificationTest.flush(this.notifConsumer);
        long start = System.currentTimeMillis();
        try {
            sf.createSession();
            Assertions.fail((String)"authentication must fail and a notification of security violation must be sent");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ClientMessage[] notifications = SSLSecurityNotificationTest.consumeMessages(1, this.notifConsumer);
        Assertions.assertEquals((Object)CoreNotificationType.SECURITY_AUTHENTICATION_VIOLATION.toString(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TYPE).toString());
        Assertions.assertNull((Object)notifications[0].getObjectProperty(ManagementHelper.HDR_USER));
        Assertions.assertEquals((Object)"CN=ActiveMQ Artemis Unknown Client, OU=Artemis, O=ActiveMQ, L=AMQ, ST=AMQ, C=AMQ", (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_CERT_SUBJECT_DN).toString());
        Assertions.assertTrue((boolean)notifications[0].getObjectProperty(ManagementHelper.HDR_REMOTE_ADDRESS).toString().startsWith("127.0.0.1"));
        Assertions.assertTrue((notifications[0].getTimestamp() >= start ? (byte)1 : 0) != 0);
        Assertions.assertTrue(((Long)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP) >= start ? (byte)1 : 0) != 0);
        Assertions.assertEquals((long)notifications[0].getTimestamp(), (long)((Long)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP)));
    }

    @Test
    public void testCONSUMER_CREATED() throws Exception {
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        Role role = new Role("notif", true, true, true, true, false, true, true, true, true, true, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        this.server.getSecurityRepository().addMatch("#", roles);
        TransportConfiguration tc = new TransportConfiguration(NETTY_CONNECTOR_FACTORY);
        tc.getParams().put("sslEnabled", true);
        tc.getParams().put("trustStorePath", "server-ca-truststore.jks");
        tc.getParams().put("trustStorePassword", "securepass");
        tc.getParams().put("keyStorePath", "client-keystore.jks");
        tc.getParams().put("keyStorePassword", "securepass");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{tc}));
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(locator));
        ClientSession guestSession = sf.createSession("guest", "guest", false, true, true, false, 1);
        guestSession.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setRoutingType(RoutingType.ANYCAST));
        SSLSecurityNotificationTest.flush(this.notifConsumer);
        long start = System.currentTimeMillis();
        guestSession.createConsumer(queue);
        ClientMessage[] notifications = SecurityNotificationTest.consumeMessages(1, this.notifConsumer);
        Assertions.assertEquals((Object)CoreNotificationType.CONSUMER_CREATED.toString(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TYPE).toString());
        Assertions.assertEquals((Object)"guest", (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_USER).toString());
        Assertions.assertEquals((Object)"first", (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_VALIDATED_USER).toString());
        Assertions.assertEquals((Object)address.toString(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_ADDRESS).toString());
        Assertions.assertEquals((Object)"CN=ActiveMQ Artemis Client, OU=Artemis, O=ActiveMQ, L=AMQ, ST=AMQ, C=AMQ", (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_CERT_SUBJECT_DN).toString());
        Assertions.assertTrue((notifications[0].getTimestamp() >= start ? (byte)1 : 0) != 0);
        Assertions.assertTrue(((Long)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP) >= start ? (byte)1 : 0) != 0);
        Assertions.assertEquals((long)notifications[0].getTimestamp(), (long)((Long)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP)));
        guestSession.close();
    }

    @Test
    public void testCONNECTION_CREATED() throws Exception {
        Role role = new Role("notif", true, true, true, true, false, true, true, true, true, true, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        this.server.getSecurityRepository().addMatch("#", roles);
        TransportConfiguration tc = new TransportConfiguration(NETTY_CONNECTOR_FACTORY);
        tc.getParams().put("sslEnabled", true);
        tc.getParams().put("trustStorePath", "server-ca-truststore.jks");
        tc.getParams().put("trustStorePassword", "securepass");
        tc.getParams().put("keyStorePath", "client-keystore.jks");
        tc.getParams().put("keyStorePassword", "securepass");
        SSLSecurityNotificationTest.flush(this.notifConsumer);
        long start = System.currentTimeMillis();
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{tc}));
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(locator));
        ClientMessage notification = SecurityNotificationTest.consumeMessages(1, this.notifConsumer)[0];
        Assertions.assertEquals((Object)CoreNotificationType.CONNECTION_CREATED.toString(), (Object)notification.getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TYPE).toString());
        Assertions.assertNotNull((Object)notification.getObjectProperty(ManagementHelper.HDR_CERT_SUBJECT_DN));
        Assertions.assertEquals((Object)"CN=ActiveMQ Artemis Client, OU=Artemis, O=ActiveMQ, L=AMQ, ST=AMQ, C=AMQ", (Object)notification.getObjectProperty(ManagementHelper.HDR_CERT_SUBJECT_DN).toString());
        Assertions.assertTrue((boolean)notification.getObjectProperty(ManagementHelper.HDR_REMOTE_ADDRESS).toString().startsWith("127.0.0.1"));
        Assertions.assertTrue((notification.getTimestamp() >= start ? (byte)1 : 0) != 0);
        Assertions.assertTrue(((Long)notification.getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP) >= start ? (byte)1 : 0) != 0);
        Assertions.assertEquals((long)notification.getTimestamp(), (long)((Long)notification.getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP)));
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager("CertLogin");
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().setSecurityEnabled(true), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sslEnabled", true);
        params.put("keyStorePath", "server-keystore.jks");
        params.put("keyStorePassword", "securepass");
        params.put("trustStorePath", "client-ca-truststore.jks");
        params.put("trustStorePassword", "securepass");
        params.put("needClientAuth", true);
        this.server.getConfiguration().addAcceptorConfiguration(new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params));
        NotificationActiveMQServerPlugin plugin = new NotificationActiveMQServerPlugin();
        HashMap<String, String> init = new HashMap<String, String>();
        init.put("SEND_CONNECTION_NOTIFICATIONS", "true");
        plugin.init(init);
        this.server.registerBrokerPlugin((ActiveMQServerBasePlugin)plugin);
        this.server.start();
        this.notifQueue = RandomUtil.randomSimpleString();
        Role role = new Role("notif", true, true, true, true, true, true, true, true, true, true, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        this.server.getSecurityRepository().addMatch(ActiveMQDefaultConfiguration.getDefaultManagementNotificationAddress().toString(), roles);
        TransportConfiguration tc = new TransportConfiguration(NETTY_CONNECTOR_FACTORY);
        tc.getParams().put("sslEnabled", true);
        tc.getParams().put("trustStorePath", "server-ca-truststore.jks");
        tc.getParams().put("trustStorePassword", "securepass");
        tc.getParams().put("keyStorePath", "client-keystore.jks");
        tc.getParams().put("keyStorePassword", "securepass");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{tc}));
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(locator));
        this.adminSession = sf.createSession(true, true, 1);
        this.adminSession.start();
        this.adminSession.createQueue(QueueConfiguration.of((SimpleString)this.notifQueue).setAddress(ActiveMQDefaultConfiguration.getDefaultManagementNotificationAddress()).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        this.notifConsumer = this.adminSession.createConsumer(this.notifQueue);
    }

    private static void flush(ClientConsumer notifConsumer) throws ActiveMQException {
        ClientMessage message = null;
        while ((message = notifConsumer.receive(500L)) != null) {
        }
    }

    protected static ClientMessage[] consumeMessages(int expected, ClientConsumer consumer) throws Exception {
        ClientMessage[] messages = new ClientMessage[expected];
        ClientMessage m = null;
        for (int i = 0; i < expected; ++i) {
            m = consumer.receive(500L);
            Assertions.assertNotNull((Object)m, (String)("expected to received " + expected + " messages, got only " + i));
            messages[i] = m;
            m.acknowledge();
        }
        m = consumer.receiveImmediate();
        Assertions.assertNull((Object)m, (String)("received one more message than expected (" + expected + ")"));
        return messages;
    }

    static {
        URL resource;
        String path = System.getProperty("java.security.auth.login.config");
        if (path == null && (resource = SecurityTest.class.getClassLoader().getResource("login.config")) != null) {
            path = resource.getFile();
            System.setProperty("java.security.auth.login.config", path);
        }
    }
}

