/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import java.util.HashSet;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.tests.integration.management.SecurityManagementTestBase;
import org.junit.jupiter.api.Test;

public class SecurityManagementMessageRbacTest
extends SecurityManagementTestBase {
    private final String password = "bla";
    private final String guest = "guest";
    private final String view = "view";
    private final String updater = "updaterUser";
    private final String admin = "validAdminUser";

    @Test
    public void testSendManagementMessageWithAdminRole() throws Exception {
        this.doSendBrokerManagementMessage("validAdminUser", "bla", true);
    }

    @Test
    public void testSendManagementMessageAsGuest() throws Exception {
        this.doSendBrokerManagementMessage("guest", "bla", false);
    }

    @Test
    public void testSendManagementMessageAsView() throws Exception {
        this.doSendBrokerManagementMessage("view", "bla", true);
    }

    @Test
    public void testSendManagementOpWithView() throws Exception {
        this.doSendBrokerManagementMessageFor(false, "view", "bla", false);
    }

    @Test
    public void testSendManagementOpWithGuest() throws Exception {
        this.doSendBrokerManagementMessageFor(false, "guest", "bla", false);
    }

    @Test
    public void testSendManagementOpWithUpdateRole() throws Exception {
        this.doSendBrokerManagementMessageFor(false, "updaterUser", "bla", true);
    }

    @Override
    protected ActiveMQServer setupAndStartActiveMQServer() throws Exception {
        Configuration config = this.createDefaultInVMConfig().setSecurityEnabled(true);
        config.setManagementMessageRbac(true);
        config.setManagementRbacPrefix("mm");
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false));
        server.start();
        HierarchicalRepository securityRepository = server.getSecurityRepository();
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
        securityManager.getConfiguration().addUser("validAdminUser", "bla");
        securityManager.getConfiguration().addUser("guest", "bla");
        securityManager.getConfiguration().addUser("updaterUser", "bla");
        securityManager.getConfiguration().addUser("view", "bla");
        securityManager.getConfiguration().addRole("validAdminUser", "manageRole");
        securityManager.getConfiguration().addRole("validAdminUser", "updateRole");
        securityManager.getConfiguration().addRole("guest", "guestRole");
        securityManager.getConfiguration().addRole("view", "viewRole");
        securityManager.getConfiguration().addRole("view", "manageRole");
        securityManager.getConfiguration().addRole("updaterUser", "updateRole");
        securityManager.getConfiguration().addRole("updaterUser", "manageRole");
        HashSet<Role> permissionsOnManagementAddress = new HashSet<Role>();
        permissionsOnManagementAddress.add(new Role("manageRole", true, true, false, false, true, true, true, true, true, true, false, false));
        securityRepository.addMatch(ActiveMQDefaultConfiguration.getDefaultManagementAddress().toString() + ".*", permissionsOnManagementAddress);
        securityRepository.addMatch(ActiveMQDefaultConfiguration.getDefaultManagementAddress().toString(), permissionsOnManagementAddress);
        HashSet<Role> catchAllPermissions = new HashSet<Role>();
        catchAllPermissions.add(new Role("guestRole", false, false, false, false, false, false, false, false, false, false, false, false));
        securityRepository.addMatch("#", catchAllPermissions);
        String brokerControlRbacAttributeKey = "mm.broker.isStarted";
        HashSet<Role> brokerControlRoles = new HashSet<Role>();
        brokerControlRoles.add(new Role("viewRole", true, true, true, true, true, true, true, true, true, true, true, false));
        brokerControlRoles.add(new Role("updateRole", true, true, true, true, true, true, true, true, true, true, true, true));
        securityRepository.addMatch("mm.broker.isStarted", brokerControlRoles);
        String brokerControlRbacOpKey = "mm.broker.enableMessageCounters";
        securityRepository.addMatch("mm.broker.enableMessageCounters", brokerControlRoles);
        return server;
    }
}

