/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.util.ArrayList;
import java.util.Map;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.management.SimpleManagement;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.json.JsonArray;
import org.apache.activemq.artemis.json.JsonObject;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SimpleManagementTest
extends ActiveMQTestBase {
    public static final String LOCALHOST = "tcp://localhost:61616";
    private ActiveMQServer server;
    SimpleManagement simpleManagement = new SimpleManagement("tcp://localhost:61616", "admin", "admin");

    @BeforeEach
    public void setupServer() throws Exception {
        this.server = this.createServer(false, this.createDefaultConfig(0, true));
        ClusterConnectionConfiguration ccconf = new ClusterConnectionConfiguration();
        ccconf.setStaticConnectors(new ArrayList()).getStaticConnectors().add("backup");
        ccconf.setName("cluster");
        ccconf.setConnectorName("live");
        this.server.getConfiguration().addConnectorConfiguration("live", LOCALHOST);
        this.server.getConfiguration().addClusterConfiguration(ccconf);
        this.server.start();
    }

    @Test
    public void testQueues() throws Exception {
        this.server.start();
        String queueName = RandomUtil.randomString();
        this.server.addAddressInfo(new AddressInfo(queueName).addRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((String)queueName).setRoutingType(RoutingType.ANYCAST).setAddress(queueName).setDurable(Boolean.valueOf(true)));
        ConnectionFactory factory = CFUtil.createConnectionFactory("CORE", LOCALHOST);
        try (Connection connection = factory.createConnection();){
            Session session = connection.createSession(true, 0);
            MessageProducer producer = session.createProducer((Destination)session.createQueue(queueName));
            for (int i = 0; i < 33; ++i) {
                producer.send(session.createMessage());
            }
            session.commit();
        }
        Queue serverQueue = this.server.locateQueue(queueName);
        Wait.assertEquals((long)33L, () -> ((Queue)serverQueue).getMessageCount());
        Map queues = this.simpleManagement.getQueueCounts(100);
        Assertions.assertEquals((Long)33L, (Long)((Long)queues.get(queueName)));
        Assertions.assertEquals((long)33L, (long)this.simpleManagement.getMessageCountOnQueue(queueName));
    }

    @Test
    public void testListTopology() throws Exception {
        JsonArray topology = this.simpleManagement.listNetworkTopology();
        String nodeId = this.simpleManagement.getNodeID();
        Assertions.assertEquals((int)1, (int)topology.size());
        JsonObject node = topology.getJsonObject(0);
        Assertions.assertEquals((Object)"localhost:61616", (Object)node.getString("live"));
        Assertions.assertEquals((Object)nodeId, (Object)node.getString("nodeID"));
    }
}

