/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt;

import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.activemq.artemis.tests.integration.mqtt.MQTTClientProvider;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.fusesource.mqtt.client.BlockingConnection;
import org.fusesource.mqtt.client.MQTT;
import org.fusesource.mqtt.client.Message;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.client.Topic;

public class FuseMQTTClientProvider
implements MQTTClientProvider {
    private final MQTT mqtt = new MQTT();
    private BlockingConnection connection;

    @Override
    public void connect(String host) throws Exception {
        this.mqtt.setHost(host);
        this.mqtt.setVersion("3.1.1");
        this.mqtt.setConnectAttemptsMax(0L);
        this.mqtt.setReconnectAttemptsMax(0L);
        this.connection = this.mqtt.blockingConnection();
        this.connection.connect();
    }

    @Override
    public void disconnect() throws Exception {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    @Override
    public void publish(String topic, byte[] payload, int qos) throws Exception {
        this.publish(topic, payload, qos, false);
    }

    @Override
    public void publish(String topic, byte[] payload, int qos, boolean retained) throws Exception {
        this.connection.publish(topic, payload, QoS.values()[qos], retained);
    }

    @Override
    public void subscribe(String topic, int qos) throws Exception {
        Topic[] topics = new Topic[]{new Topic(UTF8Buffer.utf8((String)topic), QoS.values()[qos])};
        this.connection.subscribe(topics);
    }

    @Override
    public void unsubscribe(String topic) throws Exception {
        this.connection.unsubscribe(new String[]{topic});
    }

    @Override
    public byte[] receive(int timeout) throws Exception {
        byte[] result = null;
        Message message = this.connection.receive((long)timeout, TimeUnit.MILLISECONDS);
        if (message != null) {
            result = message.getPayload();
            message.ack();
        }
        return result;
    }

    @Override
    public void setSslContext(SSLContext sslContext) {
        this.mqtt.setSslContext(sslContext);
    }

    @Override
    public void setWillMessage(String string) {
        this.mqtt.setWillMessage(string);
    }

    @Override
    public void setWillTopic(String topic) {
        this.mqtt.setWillTopic(topic);
    }

    @Override
    public void setClientId(String clientId) {
        this.mqtt.setClientId(clientId);
    }

    @Override
    public void kill() throws Exception {
        this.connection.kill();
    }

    @Override
    public void setKeepAlive(int keepAlive) throws Exception {
        this.mqtt.setKeepAlive((short)keepAlive);
    }
}

