/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.InvalidClientIDException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.openwire.OpenWireTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastReconnectOpenWireTest
extends OpenWireTestBase {
    private static final int NUM_ITERATIONS = 50;
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    protected void configureAddressSettings(Map<String, AddressSettings> addressSettingsMap) {
        super.configureAddressSettings(addressSettingsMap);
        addressSettingsMap.put("exampleQueue", new AddressSettings().setAutoCreateQueues(Boolean.valueOf(false)).setAutoCreateAddresses(Boolean.valueOf(false)).setDeadLetterAddress(SimpleString.of((String)"ActiveMQ.DLQ")).setAutoCreateAddresses(Boolean.valueOf(true)).setMaxDeliveryAttempts(2));
        addressSettingsMap.put("exampleQueueTwo", new AddressSettings().setAutoCreateQueues(Boolean.valueOf(false)).setAutoCreateAddresses(Boolean.valueOf(false)).setDeadLetterAddress(SimpleString.of((String)"ActiveMQ.DLQ")).setAutoCreateAddresses(Boolean.valueOf(true)).setMaxDeliveryAttempts(-1));
    }

    @Test
    @Timeout(value=60L)
    public void testFastReconnectCreateConsumerNoErrors() throws Exception {
        ArrayList errors = new ArrayList();
        SimpleString durableQueue = SimpleString.of((String)"exampleQueueTwo");
        this.server.createQueue(QueueConfiguration.of((SimpleString)durableQueue).setRoutingType(RoutingType.ANYCAST));
        ActiveMQQueue queue = new ActiveMQQueue(durableQueue.toString());
        ActiveMQConnectionFactory exFact = new ActiveMQConnectionFactory("failover:(tcp://localhost:61616?closeAsync=false)?startupMaxReconnectAttempts=-1&maxReconnectAttempts=-1&timeout=5000");
        exFact.setWatchTopicAdvisories(false);
        exFact.setConnectResponseTimeout(10000);
        exFact.setClientID("myID");
        RedeliveryPolicy redeliveryPolicy = new RedeliveryPolicy();
        redeliveryPolicy.setRedeliveryDelay(0L);
        redeliveryPolicy.setMaximumRedeliveries(-1);
        exFact.setRedeliveryPolicy(redeliveryPolicy);
        this.publish(1000, durableQueue.toString());
        AtomicInteger numIterations = new AtomicInteger(50);
        ExecutorService executor = Executors.newCachedThreadPool();
        this.runAfter(executor::shutdownNow);
        int concurrent = 2;
        CountDownLatch done = new CountDownLatch(2);
        for (int i = 0; i < 2; ++i) {
            executor.execute(() -> FastReconnectOpenWireTest.lambda$testFastReconnectCreateConsumerNoErrors$0(numIterations, exFact, (Queue)queue, errors, done));
        }
        Assertions.assertTrue((boolean)done.await(30L, TimeUnit.SECONDS));
        Wait.assertEquals((int)0, () -> this.server.locateQueue(durableQueue).getConsumerCount(), (long)5000L);
        Assertions.assertTrue((boolean)errors.isEmpty());
    }

    @Test
    @Timeout(value=60L)
    public void testFastReconnectCreateConsumerNoErrorsNoClientId() throws Exception {
        ArrayList errors = new ArrayList();
        SimpleString durableQueue = SimpleString.of((String)"exampleQueueTwo");
        this.server.createQueue(QueueConfiguration.of((SimpleString)durableQueue).setRoutingType(RoutingType.ANYCAST));
        ActiveMQQueue queue = new ActiveMQQueue(durableQueue.toString());
        ActiveMQConnectionFactory exFact = new ActiveMQConnectionFactory("failover:(tcp://localhost:61616?closeAsync=false)?startupMaxReconnectAttempts=-1&maxReconnectAttempts=-1&timeout=5000");
        exFact.setWatchTopicAdvisories(false);
        exFact.setConnectResponseTimeout(10000);
        RedeliveryPolicy redeliveryPolicy = new RedeliveryPolicy();
        redeliveryPolicy.setRedeliveryDelay(0L);
        redeliveryPolicy.setMaximumRedeliveries(-1);
        exFact.setRedeliveryPolicy(redeliveryPolicy);
        this.publish(1000, durableQueue.toString());
        AtomicInteger numIterations = new AtomicInteger(50);
        ExecutorService executor = Executors.newCachedThreadPool();
        this.runAfter(executor::shutdownNow);
        int concurrent = 2;
        CountDownLatch done = new CountDownLatch(2);
        for (int i = 0; i < 2; ++i) {
            executor.execute(() -> FastReconnectOpenWireTest.lambda$testFastReconnectCreateConsumerNoErrorsNoClientId$2(exFact, (Queue)queue, numIterations, errors, done));
        }
        Assertions.assertTrue((boolean)done.await(30L, TimeUnit.SECONDS));
        Wait.assertEquals((int)0, () -> this.server.locateQueue(durableQueue).getConsumerCount(), (long)5000L);
        Assertions.assertTrue((boolean)errors.isEmpty());
    }

    private void publish(int numMessages, String name) throws Exception {
        ActiveMQConnectionFactory exFact = new ActiveMQConnectionFactory();
        Connection exConn = exFact.createConnection();
        exConn.start();
        ActiveMQQueue queue = new ActiveMQQueue(name);
        Session session = exConn.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)queue);
        TextMessage message = session.createTextMessage("This is a text message");
        for (int i = 0; i < numMessages; ++i) {
            message.setIntProperty("SEQ", i);
            producer.send((Message)message);
        }
        session.close();
        exConn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$testFastReconnectCreateConsumerNoErrorsNoClientId$2(ActiveMQConnectionFactory exFact, Queue queue, AtomicInteger numIterations, ArrayList errors, CountDownLatch done) {
        try (Connection conn = exFact.createConnection();
             Session consumerConnectionSession = conn.createSession(true, 0);
             MessageConsumer messageConsumer = consumerConnectionSession.createConsumer((Destination)queue);){
            conn.start();
            while (numIterations.decrementAndGet() > 0) {
                try {
                    messageConsumer.receiveNoWait();
                    try {
                        ((TcpTransport)((ActiveMQConnection)conn).getTransport().narrow(TcpTransport.class)).stop();
                    }
                    catch (Throwable throwable) {
                    }
                }
                catch (Throwable unexpected) {
                    errors.add(unexpected);
                }
            }
        }
        catch (Throwable unexpected) {
            numIterations.set(0);
            unexpected.printStackTrace();
            errors.add(unexpected);
        }
        finally {
            done.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$testFastReconnectCreateConsumerNoErrors$0(AtomicInteger numIterations, ActiveMQConnectionFactory exFact, Queue queue, ArrayList errors, CountDownLatch done) {
        block26: {
            block23: while (true) {
                while (numIterations.decrementAndGet() > 0) {
                    try {
                        Connection conn = exFact.createConnection();
                        try {
                            Session consumerConnectionSession = conn.createSession(true, 0);
                            try {
                                MessageConsumer messageConsumer = consumerConnectionSession.createConsumer((Destination)queue);
                                try {
                                    messageConsumer.receiveNoWait();
                                    try {
                                        ((TcpTransport)((ActiveMQConnection)conn).getTransport().narrow(TcpTransport.class)).stop();
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                    continue block23;
                                }
                                finally {
                                    if (messageConsumer == null) continue block23;
                                    messageConsumer.close();
                                    continue block23;
                                }
                            }
                            finally {
                                if (consumerConnectionSession == null) continue block23;
                                consumerConnectionSession.close();
                                continue block23;
                            }
                        }
                        finally {
                            if (conn != null) {
                                conn.close();
                            }
                            continue block23;
                        }
                    }
                    catch (InvalidClientIDException conn) {
                    }
                    catch (Throwable unexpected) {
                        logger.warn(unexpected.getMessage(), unexpected);
                        errors.add(unexpected);
                        numIterations.set(0);
                    }
                }
                break block26;
                {
                    continue block23;
                    break;
                }
                break;
            }
            finally {
                done.countDown();
            }
        }
    }
}

