/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import java.util.List;
import java.util.Vector;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JmsTopicRequestReplyTest
extends BasicOpenWireTest
implements MessageListener {
    protected boolean useAsyncConsume;
    private Connection serverConnection;
    private Connection clientConnection;
    private MessageProducer replyProducer;
    private Session serverSession;
    private Destination requestDestination;
    private List<JMSException> failures = new Vector<JMSException>();
    private boolean dynamicallyCreateProducer;
    private String clientSideClientID;

    @Test
    public void testSendAndReceive() throws Exception {
        this.clientConnection = this.createConnection();
        this.clientConnection.setClientID("ClientConnection:" + this.name);
        Session session = this.clientConnection.createSession(false, 1);
        this.clientConnection.start();
        Destination replyDestination = this.createTemporaryDestination(session);
        MessageConsumer replyConsumer = session.createConsumer(replyDestination);
        this.clientSideClientID = this.clientConnection.getClientID();
        TextMessage requestMessage = session.createTextMessage("Olivier");
        requestMessage.setJMSReplyTo(replyDestination);
        MessageProducer requestProducer = session.createProducer(this.requestDestination);
        requestProducer.send((Message)requestMessage);
        Message msg = replyConsumer.receive(5000L);
        if (msg instanceof TextMessage) {
            TextMessage replyMessage = (TextMessage)msg;
            Assertions.assertEquals((Object)"Hello: Olivier", (Object)replyMessage.getText(), (String)"Wrong message content");
        } else {
            Assertions.fail((String)"Should have received a reply by now");
        }
        replyConsumer.close();
        this.deleteTemporaryDestination(replyDestination);
        Assertions.assertEquals((int)0, (int)this.failures.size(), (String)("Should not have had any failures: " + this.failures));
    }

    @Test
    public void testSendAndReceiveWithDynamicallyCreatedProducer() throws Exception {
        this.dynamicallyCreateProducer = true;
        this.testSendAndReceive();
    }

    public void onMessage(Message message) {
        try {
            TextMessage requestMessage = (TextMessage)message;
            Destination replyDestination = requestMessage.getJMSReplyTo();
            TextMessage replyMessage = this.serverSession.createTextMessage("Hello: " + requestMessage.getText());
            replyMessage.setJMSCorrelationID(requestMessage.getJMSMessageID());
            if (this.dynamicallyCreateProducer) {
                this.replyProducer = this.serverSession.createProducer(replyDestination);
                this.replyProducer.send((Message)replyMessage);
            } else {
                this.replyProducer.send(replyDestination, (Message)replyMessage);
            }
        }
        catch (JMSException e) {
            this.onException(e);
        }
    }

    protected void syncConsumeLoop(MessageConsumer requestConsumer) {
        try {
            Message message = requestConsumer.receive(5000L);
            if (message != null) {
                this.onMessage(message);
            } else {
                System.err.println("No message received");
            }
        }
        catch (JMSException e) {
            this.onException(e);
        }
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.serverConnection = this.createConnection();
        this.serverConnection.setClientID("serverConnection:" + this.name);
        this.serverSession = this.serverConnection.createSession(false, 1);
        this.replyProducer = this.serverSession.createProducer(null);
        this.requestDestination = this.createDestination(this.serverSession);
        MessageConsumer requestConsumer = this.serverSession.createConsumer(this.requestDestination);
        if (this.useAsyncConsume) {
            requestConsumer.setMessageListener((MessageListener)this);
        } else {
            Thread thread = new Thread(() -> this.syncConsumeLoop(requestConsumer));
            thread.start();
        }
        this.serverConnection.start();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.serverConnection.close();
        this.clientConnection.stop();
        this.clientConnection.close();
        super.tearDown();
    }

    protected void onException(JMSException e) {
        System.out.println("Caught: " + e);
        e.printStackTrace();
        this.failures.add(e);
    }

    protected Destination createDestination(Session session) throws JMSException {
        if (this.topic) {
            return this.createDestination(session, (byte)2);
        }
        return this.createDestination(session, (byte)1);
    }

    protected Destination createTemporaryDestination(Session session) throws JMSException {
        if (this.topic) {
            return session.createTemporaryTopic();
        }
        return session.createTemporaryQueue();
    }

    protected void deleteTemporaryDestination(Destination dest) throws JMSException {
        if (this.topic) {
            ((TemporaryTopic)dest).delete();
        } else {
            ((TemporaryQueue)dest).delete();
        }
    }
}

