/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.TransactionRolledBackException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.TransactionContext;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.transaction.Synchronization;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TransactionContextTest
extends BasicOpenWireTest {
    TransactionContext underTest;

    @BeforeEach
    public void setup() throws Exception {
        this.connection.start();
        this.underTest = new TransactionContext(this.connection);
    }

    @Test
    public void testSyncBeforeEndCalledOnceOnRollback() throws Exception {
        final AtomicInteger beforeEndCountA = new AtomicInteger(0);
        final AtomicInteger beforeEndCountB = new AtomicInteger(0);
        final AtomicInteger rollbackCountA = new AtomicInteger(0);
        final AtomicInteger rollbackCountB = new AtomicInteger(0);
        this.underTest.addSynchronization(new Synchronization(){

            public void beforeEnd() throws Exception {
                if (beforeEndCountA.getAndIncrement() == 0) {
                    throw new TransactionRolledBackException("force rollback");
                }
            }

            public void afterCommit() throws Exception {
                Assertions.fail((String)"expected rollback exception");
            }

            public void afterRollback() throws Exception {
                rollbackCountA.incrementAndGet();
            }
        });
        this.underTest.addSynchronization(new Synchronization(){

            public void beforeEnd() throws Exception {
                beforeEndCountB.getAndIncrement();
            }

            public void afterCommit() throws Exception {
                Assertions.fail((String)"expected rollback exception");
            }

            public void afterRollback() throws Exception {
                rollbackCountB.incrementAndGet();
            }
        });
        try {
            this.underTest.commit();
            Assertions.fail((String)"expected rollback exception");
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            // empty catch block
        }
        Assertions.assertEquals((int)1, (int)beforeEndCountA.get(), (String)"beforeEnd A called once");
        Assertions.assertEquals((int)1, (int)beforeEndCountA.get(), (String)"beforeEnd B called once");
        Assertions.assertEquals((int)1, (int)rollbackCountB.get(), (String)"rollbackCount B 0");
        Assertions.assertEquals((int)rollbackCountA.get(), (int)rollbackCountB.get(), (String)"rollbackCount A B");
    }

    @Test
    public void testSyncIndexCleared() throws Exception {
        final AtomicInteger beforeEndCountA = new AtomicInteger(0);
        final AtomicInteger rollbackCountA = new AtomicInteger(0);
        Synchronization sync = new Synchronization(){

            public void beforeEnd() throws Exception {
                beforeEndCountA.getAndIncrement();
            }

            public void afterCommit() throws Exception {
                Assertions.fail((String)"expected rollback exception");
            }

            public void afterRollback() throws Exception {
                rollbackCountA.incrementAndGet();
            }
        };
        this.underTest.begin();
        this.underTest.addSynchronization(sync);
        this.underTest.rollback();
        Assertions.assertEquals((int)1, (int)beforeEndCountA.get(), (String)"beforeEnd");
        Assertions.assertEquals((int)1, (int)rollbackCountA.get(), (String)"rollback");
        this.underTest.begin();
        this.underTest.addSynchronization(sync);
        this.underTest.rollback();
        Assertions.assertEquals((int)2, (int)beforeEndCountA.get(), (String)"beforeEnd");
        Assertions.assertEquals((int)2, (int)rollbackCountA.get(), (String)"rollback");
    }
}

