/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.persistence;

import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AddressInfoRestartTest
extends ActiveMQTestBase {
    @Test
    public void testAddressInfoAutoCreatedAndRestart() throws Exception {
        ActiveMQServer server = this.createServer(true);
        server.start();
        SimpleString address = SimpleString.of((String)"test.address");
        SimpleString queue = SimpleString.of((String)"test.queue");
        server.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address));
        AddressInfo addressInfo1 = server.getPostOffice().getAddressInfo(address);
        Assertions.assertTrue((boolean)addressInfo1.isAutoCreated());
        server.stop();
        server.start();
        AddressInfo addressInfo2 = server.getPostOffice().getAddressInfo(address);
        Assertions.assertTrue((boolean)addressInfo2.isAutoCreated());
    }
}

