/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.persistence;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.config.AbstractPersistedAddressSetting;
import org.apache.activemq.artemis.core.persistence.config.PersistedAddressSettingJSON;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.DeletionPolicy;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.integration.persistence.StorageManagerTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class AddressSettingsConfigurationStorageTest
extends StorageManagerTestBase {
    private Map<SimpleString, PersistedAddressSettingJSON> mapExpectedAddresses;

    public AddressSettingsConfigurationStorageTest(StoreConfiguration.StoreType storeType) {
        super(storeType);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.mapExpectedAddresses = new HashMap<SimpleString, PersistedAddressSettingJSON>();
    }

    protected void addAddress(StorageManager journal1, String address, AddressSettings setting) throws Exception {
        SimpleString str = SimpleString.of((String)address);
        PersistedAddressSettingJSON persistedSetting = new PersistedAddressSettingJSON(str, setting, setting.toJSON());
        this.mapExpectedAddresses.put(str, persistedSetting);
        journal1.storeAddressSetting(persistedSetting);
    }

    @TestTemplate
    public void testStoreSecuritySettings() throws Exception {
        AddressSettings setting = new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.BLOCK).setDeadLetterAddress(SimpleString.of((String)"some-test"));
        this.addAddress(this.journal, "a2", setting);
        this.rebootStorage();
        this.checkAddresses(this.journal);
        setting = new AddressSettings().setDeadLetterAddress(SimpleString.of((String)"new-adddress"));
        this.addAddress(this.journal, "a1", setting);
        this.rebootStorage();
        this.checkAddresses(this.journal);
    }

    @TestTemplate
    public void testStoreConfigDeleteSettings() throws Exception {
        AddressSettings setting = new AddressSettings().setConfigDeleteDiverts(DeletionPolicy.FORCE).setConfigDeleteAddresses(DeletionPolicy.FORCE).setConfigDeleteQueues(DeletionPolicy.FORCE);
        this.addAddress(this.journal, "a1", setting);
        this.rebootStorage();
        this.checkAddresses(this.journal);
    }

    private void checkAddresses(StorageManager journal1) throws Exception {
        List listSetting = journal1.recoverAddressSettings();
        Assertions.assertEquals((int)this.mapExpectedAddresses.size(), (int)listSetting.size());
        for (AbstractPersistedAddressSetting el : listSetting) {
            PersistedAddressSettingJSON el2 = this.mapExpectedAddresses.get(el.getAddressMatch());
            Assertions.assertEquals((Object)el.getAddressMatch(), (Object)el2.getAddressMatch());
            Assertions.assertEquals((Object)el.getSetting(), (Object)el2.getSetting());
        }
    }
}

