/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.persistence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.server.impl.JournalLoader;
import org.apache.activemq.artemis.core.server.impl.PostOfficeJournalLoader;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.persistence.StorageManagerTestBase;
import org.apache.activemq.artemis.tests.unit.core.postoffice.impl.fakes.FakeQueue;
import org.apache.activemq.artemis.tests.unit.core.server.impl.fakes.FakePostOffice;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.EmptyCriticalAnalyzer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class DeleteMessagesOnStartupTest
extends StorageManagerTestBase {
    ArrayList<Long> deletedMessage = new ArrayList();

    public DeleteMessagesOnStartupTest(StoreConfiguration.StoreType storeType) {
        super(storeType);
    }

    @Parameters(name="storeType")
    public static Collection<Object[]> data() {
        Object[][] params = new Object[][]{{StoreConfiguration.StoreType.FILE}};
        return Arrays.asList(params);
    }

    @TestTemplate
    public void testDeleteMessagesOnStartup() throws Exception {
        FakeQueue theQueue = new FakeQueue(SimpleString.of((String)""));
        HashMap<Long, FakeQueue> queues = new HashMap<Long, FakeQueue>();
        queues.put(100L, theQueue);
        CoreMessage msg = new CoreMessage(1L, 100);
        this.journal.storeMessage((Message)msg);
        for (int i = 2; i < 100; ++i) {
            this.journal.storeMessage((Message)new CoreMessage((long)i, 100));
        }
        this.journal.storeReference(100L, 1L, true);
        this.journal.stop();
        this.journal.start();
        this.journal.loadBindingJournal(new ArrayList(), new ArrayList(), new ArrayList());
        FakePostOffice postOffice = new FakePostOffice();
        this.journal.loadMessageJournal((PostOffice)postOffice, null, null, null, null, null, null, null, (JournalLoader)new PostOfficeJournalLoader((PostOffice)postOffice, null, this.journal, null, null, null, null, null, queues));
        Assertions.assertEquals((int)98, (int)this.deletedMessage.size());
        for (Long messageID : this.deletedMessage) {
            Assertions.assertTrue((messageID >= 2L && messageID <= 99L ? (byte)1 : 0) != 0, (String)("messageID = " + messageID));
        }
    }

    @Override
    protected JournalStorageManager createJournalStorageManager(Configuration configuration) {
        return new JournalStorageManager(configuration, (CriticalAnalyzer)EmptyCriticalAnalyzer.getInstance(), this.execFactory, this.execFactory){

            public void deleteMessage(long messageID) throws Exception {
                DeleteMessagesOnStartupTest.this.deletedMessage.add(messageID);
                super.deleteMessage(messageID);
            }
        };
    }
}

