/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.persistence;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.server.impl.JournalLoader;
import org.apache.activemq.artemis.tests.unit.core.server.impl.fakes.FakeJournalLoader;
import org.apache.activemq.artemis.tests.unit.core.server.impl.fakes.FakePostOffice;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.EmptyCriticalAnalyzer;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartSMTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    ExecutorService executor;
    ExecutorFactory execFactory;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.execFactory = this.getOrderedExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestartStorageManager() throws Exception {
        File testdir = new File(this.getTestDir());
        RestartSMTest.deleteDirectory(testdir);
        FakePostOffice postOffice = new FakePostOffice();
        JournalStorageManager journal = new JournalStorageManager(this.createDefaultInVMConfig(), (CriticalAnalyzer)EmptyCriticalAnalyzer.getInstance(), this.execFactory, this.execFactory);
        try {
            journal.start();
            ArrayList queueBindingInfos = new ArrayList();
            journal.loadBindingJournal(queueBindingInfos, new ArrayList(), new ArrayList());
            journal.loadMessageJournal((PostOffice)postOffice, null, null, null, null, null, null, (JournalLoader)new FakeJournalLoader());
            journal.stop();
            RestartSMTest.deleteDirectory(testdir);
            journal.start();
            journal.loadMessageJournal((PostOffice)postOffice, null, null, null, null, null, null, (JournalLoader)new FakeJournalLoader());
            queueBindingInfos = new ArrayList();
            journal.loadBindingJournal(queueBindingInfos, new ArrayList(), new ArrayList());
            journal.start();
        }
        finally {
            try {
                journal.stop();
            }
            catch (Exception ex) {
                logger.warn(ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

