/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.persistence.metrics;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.lang.invoke.MethodHandles;
import java.util.Enumeration;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.jms.client.ActiveMQBytesMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPersistentStatTestSupport
extends JMSTestBase {
    protected static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static int defaultMessageSize = 1000;

    @Override
    protected boolean usePersistence() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consumeTestQueueMessages(String queueName, int num) throws Exception {
        Connection connection = this.cf.createConnection();
        connection.setClientID("clientId2" + queueName);
        connection.start();
        Session session = connection.createSession(false, 1);
        Queue queue = session.createQueue(queueName);
        try {
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            for (int i = 0; i < num; ++i) {
                consumer.receive();
            }
            consumer.close();
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void browseTestQueueMessages(String queueName) throws Exception {
        Connection connection = this.cf.createConnection();
        connection.setClientID("clientId2" + queueName);
        connection.start();
        Session session = connection.createSession(false, 1);
        Queue queue = session.createQueue(queueName);
        try {
            QueueBrowser queueBrowser = session.createBrowser(queue);
            Enumeration messages = queueBrowser.getEnumeration();
            while (messages.hasMoreElements()) {
                messages.nextElement();
            }
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consumeDurableTestMessages(Connection connection, String sub, int size, String topicName, AtomicLong publishedMessageSize) throws Exception {
        Session session = connection.createSession(false, 1);
        Topic topic = session.createTopic(topicName);
        try {
            TopicSubscriber consumer = session.createDurableSubscriber(topic, sub);
            for (int i = 0; i < size; ++i) {
                ActiveMQMessage message = (ActiveMQMessage)consumer.receive();
                if (publishedMessageSize == null) continue;
                publishedMessageSize.addAndGet(-message.getCoreMessage().getEncodeSize());
            }
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishTestQueueMessages(int count, String queueName, int deliveryMode, int messageSize, AtomicLong publishedMessageSize, boolean transacted) throws Exception {
        Connection connection = this.cf.createConnection();
        connection.setClientID("clientId" + queueName);
        connection.start();
        Session session = transacted ? connection.createSession(transacted, 0) : connection.createSession(transacted, 1);
        Queue queue = session.createQueue(queueName);
        try {
            MessageProducer prod = session.createProducer((Destination)queue);
            prod.setDeliveryMode(deliveryMode);
            for (int i = 0; i < count; ++i) {
                prod.send((Message)this.createMessage(i, session, messageSize, publishedMessageSize));
            }
            if (transacted) {
                session.commit();
            }
        }
        finally {
            connection.close();
        }
    }

    protected void publishTestMessagesDurable(Connection connection, String[] subNames, String topicName, int publishSize, int expectedSize, int messageSize, AtomicLong publishedMessageSize, boolean verifyBrowsing, boolean shared) throws Exception {
        this.publishTestMessagesDurable(connection, subNames, topicName, publishSize, expectedSize, messageSize, publishedMessageSize, verifyBrowsing, 2, shared);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishTestMessagesDurable(Connection connection, String[] subNames, String topicName, int publishSize, int expectedSize, int messageSize, AtomicLong publishedMessageSize, boolean verifyBrowsing, int deliveryMode, boolean shared) throws Exception {
        Session session = connection.createSession(false, 1);
        Topic topic = session.createTopic(topicName);
        for (String subName : subNames) {
            if (shared) {
                session.createSharedDurableConsumer(topic, subName);
                continue;
            }
            session.createDurableSubscriber(topic, subName);
        }
        try {
            MessageProducer prod = session.createProducer((Destination)topic);
            prod.setDeliveryMode(deliveryMode);
            for (int i = 0; i < publishSize; ++i) {
                prod.send((Message)this.createMessage(i, session, messageSize, publishedMessageSize));
            }
        }
        finally {
            session.close();
        }
    }

    protected BytesMessage createMessage(int count, Session session, int maxMessageSize, AtomicLong publishedMessageSize) throws JMSException, ActiveMQException {
        ActiveMQBytesMessage message = (ActiveMQBytesMessage)session.createBytesMessage();
        Random randomSize = new Random();
        int size = randomSize.nextInt(maxMessageSize - 100 + 1) + 100;
        byte[] data = new byte[size];
        Random rng = new Random();
        rng.nextBytes(data);
        message.writeBytes(data);
        if (publishedMessageSize != null) {
            publishedMessageSize.addAndGet(message.getCoreMessage().getPersistentSize());
        }
        return message;
    }
}

