/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.routing;

import jakarta.jms.ConnectionFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQSslConnectionFactory;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.routing.CacheConfiguration;
import org.apache.activemq.artemis.core.config.routing.ConnectionRouterConfiguration;
import org.apache.activemq.artemis.core.config.routing.NamedPropertyConfiguration;
import org.apache.activemq.artemis.core.config.routing.PoolConfiguration;
import org.apache.activemq.artemis.core.server.routing.KeyType;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.qpid.jms.JmsConnectionFactory;

public class RoutingTestBase
extends ClusterTestBase {
    protected static final String AMQP_PROTOCOL = "AMQP";
    protected static final String CORE_PROTOCOL = "CORE";
    protected static final String OPENWIRE_PROTOCOL = "OPENWIRE";
    protected static final String CLUSTER_POOL = "CLUSTER";
    protected static final String DISCOVERY_POOL = "DISCOVERY";
    protected static final String STATIC_POOL = "STATIC";
    protected static final String CONNECTION_ROUTER_NAME = "bb1";
    protected static final String DEFAULT_CONNECTOR_NAME = "DEFAULT";
    protected static final String GROUP_ADDRESS = ActiveMQTestBase.getUDPDiscoveryAddress();
    protected static final int GROUP_PORT = ActiveMQTestBase.getUDPDiscoveryPort();
    protected static final int MULTIPLE_TARGETS = 3;

    protected TransportConfiguration getDefaultServerAcceptor(int node) {
        return (TransportConfiguration)this.getServer(node).getConfiguration().getAcceptorConfigurations().stream().findFirst().get();
    }

    protected TransportConfiguration getDefaultServerConnector(int node) {
        Map connectorConfigurations = this.getServer(node).getConfiguration().getConnectorConfigurations();
        TransportConfiguration connector = (TransportConfiguration)connectorConfigurations.get(DEFAULT_CONNECTOR_NAME);
        return connector != null ? connector : (TransportConfiguration)connectorConfigurations.values().stream().findFirst().get();
    }

    protected TransportConfiguration setupDefaultServerConnector(int node) {
        TransportConfiguration defaultServerConnector = this.getDefaultServerConnector(node);
        if (!defaultServerConnector.getName().equals(DEFAULT_CONNECTOR_NAME)) {
            defaultServerConnector = new TransportConfiguration(defaultServerConnector.getFactoryClassName(), defaultServerConnector.getParams(), DEFAULT_CONNECTOR_NAME, defaultServerConnector.getExtraParams());
            this.getServer(node).getConfiguration().getConnectorConfigurations().put(DEFAULT_CONNECTOR_NAME, defaultServerConnector);
        }
        return defaultServerConnector;
    }

    protected void setupRouterServerWithCluster(int node, KeyType keyType, String policyName, Map<String, String> properties, boolean localTargetEnabled, String localTargetFilter, int quorumSize, String clusterConnection) {
        Configuration configuration = this.getServer(node).getConfiguration();
        ConnectionRouterConfiguration connectionRouterConfiguration = new ConnectionRouterConfiguration().setName(CONNECTION_ROUTER_NAME);
        this.setupDefaultServerConnector(node);
        connectionRouterConfiguration.setKeyType(keyType).setLocalTargetFilter(localTargetFilter).setPoolConfiguration(new PoolConfiguration().setCheckPeriod(1000).setQuorumSize(quorumSize).setLocalTargetEnabled(localTargetEnabled).setClusterConnection(clusterConnection)).setPolicyConfiguration(new NamedPropertyConfiguration().setName(policyName).setProperties(properties));
        configuration.setConnectionRouters(Collections.singletonList(connectionRouterConfiguration));
        TransportConfiguration acceptor = this.getDefaultServerAcceptor(node);
        acceptor.getParams().put("router", CONNECTION_ROUTER_NAME);
    }

    protected void setupRouterServerWithDiscovery(int node, KeyType keyType, String policyName, Map<String, String> properties, boolean localTargetEnabled, String localTargetFilter, int quorumSize) {
        Configuration configuration = this.getServer(node).getConfiguration();
        ConnectionRouterConfiguration connectionRouterConfiguration = new ConnectionRouterConfiguration().setName(CONNECTION_ROUTER_NAME);
        this.setupDefaultServerConnector(node);
        connectionRouterConfiguration.setKeyType(keyType).setLocalTargetFilter(localTargetFilter).setPoolConfiguration(new PoolConfiguration().setCheckPeriod(1000).setQuorumSize(quorumSize).setLocalTargetEnabled(localTargetEnabled).setDiscoveryGroupName("dg1")).setPolicyConfiguration(new NamedPropertyConfiguration().setName(policyName).setProperties(properties));
        configuration.setConnectionRouters(Collections.singletonList(connectionRouterConfiguration));
        TransportConfiguration acceptor = this.getDefaultServerAcceptor(node);
        acceptor.getParams().put("router", CONNECTION_ROUTER_NAME);
    }

    protected void setupRouterServerWithStaticConnectors(int node, KeyType keyType, String policyName, Map<String, String> properties, boolean localTargetEnabled, String localTargetFilter, int quorumSize, int ... targetNodes) {
        Configuration configuration = this.getServer(node).getConfiguration();
        ConnectionRouterConfiguration connectionRouterConfiguration = new ConnectionRouterConfiguration().setName(CONNECTION_ROUTER_NAME);
        this.setupDefaultServerConnector(node);
        ArrayList<String> staticConnectors = new ArrayList<String>();
        for (int targetNode : targetNodes) {
            TransportConfiguration connector = this.getDefaultServerConnector(targetNode);
            configuration.getConnectorConfigurations().put(connector.getName(), connector);
            staticConnectors.add(connector.getName());
        }
        connectionRouterConfiguration.setKeyType(keyType).setLocalTargetFilter(localTargetFilter).setPoolConfiguration(new PoolConfiguration().setCheckPeriod(1000).setQuorumSize(quorumSize).setLocalTargetEnabled(localTargetEnabled).setStaticConnectors(staticConnectors)).setPolicyConfiguration(new NamedPropertyConfiguration().setName(policyName).setProperties(properties));
        configuration.setConnectionRouters(Collections.singletonList(connectionRouterConfiguration));
        TransportConfiguration acceptor = this.getDefaultServerAcceptor(node);
        acceptor.getParams().put("router", CONNECTION_ROUTER_NAME);
    }

    protected void setupRouterServerWithLocalTarget(int node, KeyType keyType, String targetKeyFilter, String localTargetFilter) {
        Configuration configuration = this.getServer(node).getConfiguration();
        ConnectionRouterConfiguration connectionRouterConfiguration = new ConnectionRouterConfiguration().setName(CONNECTION_ROUTER_NAME);
        connectionRouterConfiguration.setKeyType(keyType).setLocalTargetFilter(localTargetFilter).setKeyFilter(targetKeyFilter);
        configuration.setConnectionRouters(Collections.singletonList(connectionRouterConfiguration));
        TransportConfiguration acceptor = this.getDefaultServerAcceptor(node);
        acceptor.getParams().put("router", CONNECTION_ROUTER_NAME);
    }

    protected void setupRouterLocalCache(int node, boolean persisted, int timeout) {
        Configuration configuration = this.getServer(node).getConfiguration();
        ConnectionRouterConfiguration connectionRouterConfiguration = configuration.getConnectionRouters().stream().filter(config -> config.getName().equals(CONNECTION_ROUTER_NAME)).findFirst().get();
        connectionRouterConfiguration.setCacheConfiguration(new CacheConfiguration().setPersisted(persisted).setTimeout(timeout));
    }

    protected ConnectionFactory createFactory(String protocol, boolean sslEnabled, String host, int port, String clientID, String user, String password) throws Exception {
        return this.createFactory(protocol, sslEnabled, host, port, clientID, user, password, -1);
    }

    protected ConnectionFactory createFactory(String protocol, boolean sslEnabled, String host, int port, String clientID, String user, String password, int retries) throws Exception {
        switch (protocol) {
            case "CORE": {
                StringBuilder urlBuilder = new StringBuilder();
                urlBuilder.append("tcp://");
                urlBuilder.append(host);
                urlBuilder.append(":");
                urlBuilder.append(port);
                urlBuilder.append("?ha=true&reconnectAttempts=10&initialConnectAttempts=" + retries);
                urlBuilder.append("&sniHost=");
                urlBuilder.append(host);
                if (clientID != null) {
                    urlBuilder.append("&clientID=");
                    urlBuilder.append(clientID);
                }
                if (sslEnabled) {
                    urlBuilder.append("&");
                    urlBuilder.append("sslEnabled");
                    urlBuilder.append("=");
                    urlBuilder.append(true);
                    urlBuilder.append("&");
                    urlBuilder.append("trustStorePath");
                    urlBuilder.append("=");
                    urlBuilder.append("server-ca-truststore.jks");
                    urlBuilder.append("&");
                    urlBuilder.append("trustStorePassword");
                    urlBuilder.append("=");
                    urlBuilder.append("securepass");
                }
                return new org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory(urlBuilder.toString(), user, password);
            }
            case "AMQP": {
                StringBuilder urlBuilder = new StringBuilder();
                urlBuilder.append("failover:(");
                if (sslEnabled) {
                    urlBuilder.append("amqps://");
                    urlBuilder.append(host);
                    urlBuilder.append(":");
                    urlBuilder.append(port);
                    urlBuilder.append("?transport.trustStoreLocation=");
                    urlBuilder.append(((Object)((Object)this)).getClass().getClassLoader().getResource("server-ca-truststore.jks").getFile());
                    urlBuilder.append("&transport.trustStorePassword=securepass)");
                } else {
                    urlBuilder.append("amqp://");
                    urlBuilder.append(host);
                    urlBuilder.append(":");
                    urlBuilder.append(port);
                    urlBuilder.append(")");
                }
                urlBuilder.append("?failover.startupMaxReconnectAttempts=" + retries);
                if (clientID != null) {
                    urlBuilder.append("&jms.clientID=");
                    urlBuilder.append(clientID);
                }
                return new JmsConnectionFactory(user, password, urlBuilder.toString());
            }
            case "OPENWIRE": {
                StringBuilder urlBuilder = new StringBuilder();
                urlBuilder.append("failover:(");
                if (sslEnabled) {
                    urlBuilder.append("ssl://");
                    urlBuilder.append(host);
                    urlBuilder.append(":");
                    urlBuilder.append(port);
                    urlBuilder.append(")");
                } else {
                    urlBuilder.append("tcp://");
                    urlBuilder.append(host);
                    urlBuilder.append(":");
                    urlBuilder.append(port);
                    urlBuilder.append(")");
                }
                urlBuilder.append("?randomize=false&startupMaxReconnectAttempts=" + retries + "&maxReconnectAttempts=" + retries);
                if (clientID != null) {
                    urlBuilder.append("&jms.clientID=");
                    urlBuilder.append(clientID);
                }
                if (sslEnabled) {
                    ActiveMQSslConnectionFactory sslConnectionFactory = new ActiveMQSslConnectionFactory(urlBuilder.toString());
                    sslConnectionFactory.setUserName(user);
                    sslConnectionFactory.setPassword(password);
                    sslConnectionFactory.setTrustStore("server-ca-truststore.jks");
                    sslConnectionFactory.setTrustStorePassword("securepass");
                    return sslConnectionFactory;
                }
                return new ActiveMQConnectionFactory(user, password, urlBuilder.toString());
            }
        }
        throw new IllegalStateException("Unexpected value: " + protocol);
    }
}

