/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.security;

import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStorePrimaryPolicyConfiguration;
import org.apache.activemq.artemis.spi.core.security.ActiveMQBasicSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.util.ReplicatedBackupUtils;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class BasicSecurityManagerFailoverTest
extends FailoverTestBase {
    private boolean replicated;

    @Parameters(name="replicated={0}")
    public static Collection getParameters() {
        return Arrays.asList({true}, {false});
    }

    public BasicSecurityManagerFailoverTest(boolean replicated) {
        this.replicated = replicated;
    }

    @Override
    protected void createConfigs() throws Exception {
        if (this.replicated) {
            this.createReplicatedConfigs();
        } else {
            this.createSharedStoreConfigs();
        }
    }

    protected void createSharedStoreConfigs() throws Exception {
        this.nodeManager = this.createNodeManager();
        TransportConfiguration primaryConnector = this.getConnectorTransportConfiguration(true);
        TransportConfiguration backupConnector = this.getConnectorTransportConfiguration(false);
        this.backupConfig = super.createDefaultInVMConfig().setSecurityEnabled(true).clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(false)).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreBackupPolicyConfiguration()).addConnectorConfiguration(primaryConnector.getName(), primaryConnector).addConnectorConfiguration(backupConnector.getName(), backupConnector).addClusterConfiguration(this.createBasicClusterConfig(backupConnector.getName(), primaryConnector.getName()));
        this.backupServer = this.createTestableServer(this.backupConfig);
        this.backupServer.getServer().setSecurityManager((ActiveMQSecurityManager)new ActiveMQBasicSecurityManager());
        this.primaryConfig = super.createDefaultInVMConfig().setSecurityEnabled(true).clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(true)).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStorePrimaryPolicyConfiguration()).addClusterConfiguration(this.createBasicClusterConfig(primaryConnector.getName(), new String[0])).addConnectorConfiguration(primaryConnector.getName(), primaryConnector);
        this.primaryServer = this.createTestableServer(this.primaryConfig);
        this.primaryServer.getServer().setSecurityManager((ActiveMQSecurityManager)new ActiveMQBasicSecurityManager());
    }

    @Override
    protected void createReplicatedConfigs() throws Exception {
        TransportConfiguration primaryConnector = this.getConnectorTransportConfiguration(true);
        TransportConfiguration backupConnector = this.getConnectorTransportConfiguration(false);
        TransportConfiguration backupAcceptor = this.getAcceptorTransportConfiguration(false);
        this.backupConfig = this.createDefaultInVMConfig();
        this.primaryConfig = this.createDefaultInVMConfig();
        ReplicatedBackupUtils.configureReplicationPair(this.backupConfig, backupConnector, backupAcceptor, this.primaryConfig, primaryConnector, null);
        this.backupConfig.setSecurityEnabled(true).setBindingsDirectory(this.getBindingsDir(0, true)).setJournalDirectory(this.getJournalDir(0, true)).setPagingDirectory(this.getPageDir(0, true)).setLargeMessagesDirectory(this.getLargeMessagesDir(0, true));
        this.setupHAPolicyConfiguration();
        this.nodeManager = this.createReplicatedBackupNodeManager(this.backupConfig);
        this.backupServer = this.createTestableServer(this.backupConfig);
        this.backupServer.getServer().setSecurityManager((ActiveMQSecurityManager)new ActiveMQBasicSecurityManager());
        this.primaryConfig.setSecurityEnabled(true).clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(true));
        this.primaryServer = this.createTestableServer(this.primaryConfig);
        this.primaryServer.getServer().setSecurityManager((ActiveMQSecurityManager)new ActiveMQBasicSecurityManager());
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMAcceptor(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMConnector(live);
    }

    @TestTemplate
    public void testFailover() throws Exception {
        this.primaryServer.getServer().getActiveMQServerControl().addUser("foo", "bar", "baz", false);
        ClientSessionFactory cf = this.createSessionFactory((ServerLocator)this.getServerLocator());
        ClientSession session = null;
        try {
            session = cf.createSession("foo", "bar", false, true, true, false, 0);
        }
        catch (ActiveMQException e) {
            e.printStackTrace();
            Assertions.fail((String)"should not throw exception");
        }
        this.crash(session);
        this.waitForServerToStart(this.backupServer.getServer());
        try {
            cf = this.createSessionFactory((ServerLocator)this.getServerLocator());
            session = cf.createSession("foo", "bar", false, true, true, false, 0);
        }
        catch (ActiveMQException e) {
            e.printStackTrace();
            Assertions.fail((String)"should not throw exception");
        }
    }
}

