/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStorePrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.nativo.jlibaio.LibaioContext;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLockTimeoutTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    protected void doTest(boolean useAIO) throws Exception {
        if (useAIO) {
            Assertions.assertTrue((boolean)LibaioContext.isLoaded(), (String)String.format("libAIO is not loaded on %s %s %s", System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version")));
        }
        Configuration config = super.createDefaultInVMConfig().setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStorePrimaryPolicyConfiguration()).clearAcceptorConfigurations();
        ActiveMQServer server1 = this.createServer(true, config);
        if (useAIO) {
            server1.getConfiguration().setJournalType(JournalType.ASYNCIO);
        } else {
            server1.getConfiguration().setJournalType(JournalType.NIO);
        }
        server1.start();
        server1.waitForActivation(10L, TimeUnit.SECONDS);
        ActiveMQServer server2 = this.createServer(true, config);
        if (useAIO) {
            server2.getConfiguration().setJournalType(JournalType.ASYNCIO);
        } else {
            server2.getConfiguration().setJournalType(JournalType.NIO);
        }
        server2.getConfiguration().setJournalLockAcquisitionTimeout(5000L);
        ExecutorService service = Executors.newSingleThreadExecutor((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName()));
        Runnable r = () -> {
            try {
                server2.start();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler(true);){
            Future<?> f = service.submit(r);
            try {
                f.get(15L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                logger.warn("aborting test because server is taking too long to start");
            }
            service.shutdown();
            Assertions.assertTrue((boolean)loggerHandler.findText(new String[]{"AMQ224000"}), (String)"Expected to find AMQ224000");
            Assertions.assertTrue((boolean)loggerHandler.findTrace("Timed out waiting for lock"), (String)"Expected to find \"Timed out waiting for lock\"");
        }
    }
}

