/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import java.util.UUID;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PotentialOOMELoggingTest
extends ActiveMQTestBase {
    @Test
    public void testBlockLogging() throws Exception {
        ActiveMQServer server = this.createServer(false, this.createDefaultInVMConfig());
        for (int i = 0; i < 200; ++i) {
            server.getConfiguration().addQueueConfiguration(QueueConfiguration.of((String)UUID.randomUUID().toString()));
        }
        server.getConfiguration().setGlobalMaxSize(-1L);
        server.getConfiguration().getAddressSettings().put("#", new AddressSettings().setMaxSizeBytes(0x6400000L));
        try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
            server.start();
            Assertions.assertTrue((boolean)loggerHandler.findText(new String[]{"AMQ222205"}), (String)"Expected to find 222205");
        }
    }
}

