/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.ssl;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SSLAutoReloadTest
extends ActiveMQTestBase {
    private final String PASSWORD = "securepass";

    @Test
    public void testOneWaySSLWithAutoReload() throws Exception {
        File parentDir = new File(this.temporaryFolder, "sub");
        parentDir.mkdirs();
        File keyStoreToReload = new File(parentDir, "server-ks.p12");
        SSLAutoReloadTest.copyRecursive(new File(((Object)((Object)this)).getClass().getClassLoader().getResource("unknown-server-keystore.p12").getFile()), keyStoreToReload);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sslAutoReload", true);
        params.put("sslEnabled", true);
        params.put("keyStorePath", keyStoreToReload.getAbsolutePath());
        params.put("keyStorePassword", "securepass");
        params.put("host", "localhost");
        ConfigurationImpl config = this.createBasicConfig().addAcceptorConfiguration(new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params, "nettySSL"));
        ActiveMQServer server = this.createServer(false, (Configuration)config);
        server.getConfiguration().setConfigurationFileRefreshPeriod(50L);
        server.start();
        this.waitForServerToStart(server);
        String url = "tcp://127.0.0.1:61616?sslEnabled=true;trustStorePath=server-ca-truststore.p12;trustStorePassword=securepass";
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocator((String)url)).setCallTimeout(3000L);
        try {
            this.createSessionFactory(locator);
            Assertions.fail((String)"Creating session here should fail due to SSL handshake problems.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        SSLAutoReloadTest.copyRecursive(new File(((Object)((Object)this)).getClass().getClassLoader().getResource("server-keystore.p12").getFile()), keyStoreToReload);
        Wait.waitFor(() -> {
            try {
                this.addSessionFactory(this.createSessionFactory(locator));
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }, (long)5000L, (long)100L);
    }

    @Test
    public void testOneWaySSLWithAutoReloadPemConfigSources() throws Exception {
        File serverKeyFile = File.createTempFile("junit", null, this.temporaryFolder);
        File serverCertFile = File.createTempFile("junit", null, this.temporaryFolder);
        File serverPemConfigFile = File.createTempFile("junit", null, this.temporaryFolder);
        Files.copy(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("unknown-server-key.pem"), serverKeyFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        Files.copy(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("unknown-server-cert.pem"), serverCertFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        Files.write(serverPemConfigFile.toPath(), Arrays.asList("source.key=" + serverKeyFile.getAbsolutePath(), "source.cert=" + serverCertFile.getAbsolutePath()), new OpenOption[0]);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sslAutoReload", true);
        params.put("sslEnabled", true);
        params.put("keyStorePath", serverPemConfigFile.getAbsolutePath());
        params.put("keyStoreType", "PEMCFG");
        ConfigurationImpl config = this.createBasicConfig().addAcceptorConfiguration(new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params, "nettySSL"));
        ActiveMQServer server = this.createServer(false, (Configuration)config);
        server.getConfiguration().setConfigurationFileRefreshPeriod(50L);
        server.start();
        this.waitForServerToStart(server);
        String url = "tcp://127.0.0.1:61616?sslEnabled=true;trustStorePath=server-ca-truststore.p12;trustStorePassword=securepass";
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocator((String)url)).setCallTimeout(3000L);
        try {
            this.createSessionFactory(locator);
            Assertions.fail((String)"Creating session here should fail due to SSL handshake problems.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Files.copy(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("server-key.pem"), serverKeyFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        Files.copy(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("server-cert.pem"), serverCertFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        Wait.waitFor(() -> {
            try {
                this.addSessionFactory(this.createSessionFactory(locator));
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }, (long)5000L, (long)100L);
    }
}

