/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.stomp;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.largemessage.LargeMessageTestBase;
import org.apache.activemq.artemis.tests.integration.stomp.StompTestBase;
import org.apache.activemq.artemis.tests.integration.stomp.util.ClientStompFrame;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnection;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnectionFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Disabled
@ExtendWith(value={ParameterizedTestExtension.class})
public class StompWithLargeMessagesTest
extends StompTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"tcp+v10.stomp"}, {"tcp+v12.stomp"});
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public boolean isCompressLargeMessages() {
        return true;
    }

    @Override
    public boolean isPersistenceEnabled() {
        return true;
    }

    @Override
    public Integer getStompMinLargeMessageSize() {
        return 2048;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testSendReceiveLargeMessage() throws Exception {
        StompClientConnection conn = StompClientConnectionFactory.createClientConnection(this.uri);
        try {
            String address = "testLargeMessageAddress";
            this.server.createQueue(QueueConfiguration.of((String)address).setRoutingType(RoutingType.ANYCAST));
            int largeMessageStringSize = 0xA00000;
            StringBuilder b = new StringBuilder(largeMessageStringSize);
            for (int i = 0; i < largeMessageStringSize; ++i) {
                b.append('t');
            }
            String payload = b.toString();
            conn.connect(this.defUser, this.defPass);
            StompWithLargeMessagesTest.subscribe(conn, null, "auto", null, null, address, true);
            StompWithLargeMessagesTest.send(conn, address, null, payload);
            ClientStompFrame frame = conn.receiveFrame();
            Assertions.assertTrue((boolean)frame.getBody().equals(payload));
        }
        finally {
            conn.disconnect();
        }
    }

    @TestTemplate
    public void testSendReceiveLargePersistentMessages() throws Exception {
        StompClientConnection conn = StompClientConnectionFactory.createClientConnection(this.uri);
        conn.connect(this.defUser, this.defPass);
        int count = 10;
        int msgSize = 0x100000;
        char[] contents = new char[msgSize];
        for (int i = 0; i < msgSize; ++i) {
            contents[i] = 65;
        }
        String body = new String(contents);
        for (int i = 0; i < count; ++i) {
            ClientStompFrame frame = conn.createFrame("SEND");
            frame.addHeader("destination", StompWithLargeMessagesTest.getQueuePrefix() + StompWithLargeMessagesTest.getQueueName());
            frame.addHeader("persistent", "true");
            frame.setBody(body);
            conn.sendFrame(frame);
        }
        ClientStompFrame subFrame = conn.createFrame("SUBSCRIBE");
        subFrame.addHeader("subscription-type", "ANYCAST");
        subFrame.addHeader("destination", StompWithLargeMessagesTest.getQueuePrefix() + StompWithLargeMessagesTest.getQueueName());
        subFrame.addHeader("ack", "auto");
        conn.sendFrame(subFrame);
        for (int i = 0; i < count; ++i) {
            ClientStompFrame frame = conn.receiveFrame(60000L);
            Assertions.assertNotNull((Object)frame);
            Assertions.assertTrue((boolean)frame.getCommand().equals("MESSAGE"));
            Assertions.assertTrue((boolean)frame.getHeader("destination").equals(StompWithLargeMessagesTest.getQueuePrefix() + StompWithLargeMessagesTest.getQueueName()));
            int index = frame.getBody().indexOf("AAAA");
            Assertions.assertEquals((int)msgSize, (int)(frame.getBody().length() - index));
        }
        ClientStompFrame unsubFrame = conn.createFrame("UNSUBSCRIBE");
        unsubFrame.addHeader("destination", StompWithLargeMessagesTest.getQueuePrefix() + StompWithLargeMessagesTest.getQueueName());
        unsubFrame.addHeader("receipt", "567");
        ClientStompFrame response = conn.sendFrame(unsubFrame);
        Assertions.assertNotNull((Object)response);
        Assertions.assertTrue((boolean)response.getCommand().equals("RECEIPT"));
        conn.disconnect();
    }

    @TestTemplate
    public void testReceiveLargePersistentMessagesFromCore() throws Exception {
        StompClientConnection conn = StompClientConnectionFactory.createClientConnection(this.uri);
        conn.connect(this.defUser, this.defPass);
        int msgSize = 307200;
        char[] contents = new char[msgSize];
        for (int i = 0; i < msgSize; ++i) {
            contents[i] = 66;
        }
        String msg = new String(contents);
        int count = 10;
        for (int i = 0; i < count; ++i) {
            this.sendJmsMessage(msg);
        }
        ClientStompFrame subFrame = conn.createFrame("SUBSCRIBE");
        subFrame.addHeader("subscription-type", "ANYCAST");
        subFrame.addHeader("destination", StompWithLargeMessagesTest.getQueuePrefix() + StompWithLargeMessagesTest.getQueueName());
        subFrame.addHeader("ack", "auto");
        conn.sendFrame(subFrame);
        for (int i = 0; i < count; ++i) {
            ClientStompFrame frame = conn.receiveFrame(60000L);
            Assertions.assertNotNull((Object)frame);
            Assertions.assertTrue((boolean)frame.getCommand().equals("MESSAGE"));
            Assertions.assertTrue((boolean)frame.getHeader("destination").equals(StompWithLargeMessagesTest.getQueuePrefix() + StompWithLargeMessagesTest.getQueueName()));
            int index = frame.getBody().indexOf("BBB");
            Assertions.assertEquals((int)msgSize, (int)(frame.getBody().length() - index));
        }
        ClientStompFrame unsubFrame = conn.createFrame("UNSUBSCRIBE");
        unsubFrame.addHeader("destination", StompWithLargeMessagesTest.getQueuePrefix() + StompWithLargeMessagesTest.getQueueName());
        unsubFrame.addHeader("receipt", "567");
        ClientStompFrame response = conn.sendFrame(unsubFrame);
        Assertions.assertNotNull((Object)response);
        Assertions.assertTrue((boolean)response.getCommand().equals("RECEIPT"));
        conn.disconnect();
    }

    @TestTemplate
    public void testReceiveLargeCompressedToRegularPersistentMessagesFromCore() throws Exception {
        StompClientConnection conn = StompClientConnectionFactory.createClientConnection(this.uri);
        conn.connect(this.defUser, this.defPass);
        LargeMessageTestBase.TestLargeMessageInputStream input = new LargeMessageTestBase.TestLargeMessageInputStream(102400, true);
        LargeMessageTestBase.adjustLargeCompression(true, input, 102400);
        char[] contents = input.toArray();
        String msg = new String(contents);
        String leadingPart = msg.substring(0, 100);
        int count = 10;
        for (int i = 0; i < count; ++i) {
            this.sendJmsMessage(msg);
        }
        ClientStompFrame subFrame = conn.createFrame("SUBSCRIBE");
        subFrame.addHeader("subscription-type", "ANYCAST");
        subFrame.addHeader("destination", StompWithLargeMessagesTest.getQueuePrefix() + StompWithLargeMessagesTest.getQueueName());
        subFrame.addHeader("ack", "auto");
        conn.sendFrame(subFrame);
        for (int i = 0; i < count; ++i) {
            ClientStompFrame receiveFrame = conn.receiveFrame(30000L);
            Assertions.assertNotNull((Object)receiveFrame);
            Assertions.assertTrue((boolean)receiveFrame.getCommand().equals("MESSAGE"));
            Assertions.assertEquals((Object)receiveFrame.getHeader("destination"), (Object)(StompWithLargeMessagesTest.getQueuePrefix() + StompWithLargeMessagesTest.getQueueName()));
            int index = receiveFrame.getBody().indexOf(leadingPart);
            Assertions.assertEquals((int)msg.length(), (int)(receiveFrame.getBody().length() - index));
        }
        ClientStompFrame unsubFrame = conn.createFrame("UNSUBSCRIBE");
        unsubFrame.addHeader("destination", StompWithLargeMessagesTest.getQueuePrefix() + StompWithLargeMessagesTest.getQueueName());
        unsubFrame.addHeader("receipt", "567");
        ClientStompFrame response = conn.sendFrame(unsubFrame);
        Assertions.assertNotNull((Object)response);
        Assertions.assertTrue((boolean)response.getCommand().equals("RECEIPT"));
        conn.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testReceiveLargeCompressedToLargePersistentMessagesFromCore() throws Exception {
        StompClientConnection conn = StompClientConnectionFactory.createClientConnection(this.uri);
        try {
            LargeMessageTestBase.TestLargeMessageInputStream input = new LargeMessageTestBase.TestLargeMessageInputStream(102400, true);
            input.setSize(1024000);
            LargeMessageTestBase.adjustLargeCompression(false, input, 1024000);
            char[] contents = input.toArray();
            String msg = new String(contents);
            String leadingPart = msg.substring(0, 100);
            int count = 10;
            for (int i = 0; i < count; ++i) {
                this.sendJmsMessage(msg);
            }
            conn.connect(this.defUser, this.defPass);
            ClientStompFrame subFrame = conn.createFrame("SUBSCRIBE");
            subFrame.addHeader("subscription-type", "ANYCAST");
            subFrame.addHeader("destination", StompWithLargeMessagesTest.getQueuePrefix() + StompWithLargeMessagesTest.getQueueName());
            subFrame.addHeader("ack", "auto");
            conn.sendFrame(subFrame);
            for (int i = 0; i < count; ++i) {
                ClientStompFrame frame = conn.receiveFrame(60000L);
                Assertions.assertNotNull((Object)frame);
                logger.debug(frame.toString());
                logger.debug("part of frame: {}", (Object)frame.getBody().substring(0, 250));
                Assertions.assertTrue((boolean)frame.getCommand().equals("MESSAGE"));
                Assertions.assertTrue((boolean)frame.getHeader("destination").equals(StompWithLargeMessagesTest.getQueuePrefix() + StompWithLargeMessagesTest.getQueueName()));
                int index = frame.getBody().toString().indexOf(leadingPart);
                Assertions.assertEquals((int)msg.length(), (int)(frame.getBody().toString().length() - index));
            }
            ClientStompFrame unsubFrame = conn.createFrame("UNSUBSCRIBE");
            unsubFrame.addHeader("destination", StompWithLargeMessagesTest.getQueuePrefix() + StompWithLargeMessagesTest.getQueueName());
            unsubFrame.addHeader("receipt", "567");
            conn.sendFrame(unsubFrame);
        }
        finally {
            conn.disconnect();
            conn.closeTransport();
        }
    }
}

