/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.postoffice.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.postoffice.DuplicateIDCache;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.postoffice.impl.DuplicateIDCaches;
import org.apache.activemq.artemis.core.server.impl.JournalLoader;
import org.apache.activemq.artemis.core.server.impl.PostOfficeJournalLoader;
import org.apache.activemq.artemis.core.transaction.ResourceManager;
import org.apache.activemq.artemis.core.transaction.impl.ResourceManagerImpl;
import org.apache.activemq.artemis.tests.unit.core.server.impl.fakes.FakePostOffice;
import org.apache.activemq.artemis.tests.unit.util.FakePagingManager;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.actors.OrderedExecutorFactory;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.EmptyCriticalAnalyzer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DuplicateDetectionUnitTest
extends ActiveMQTestBase {
    ExecutorService executor;
    ExecutorFactory factory;

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.executor.shutdown();
        super.tearDown();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.executor = Executors.newFixedThreadPool(10, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName()));
        this.factory = new OrderedExecutorFactory((Executor)this.executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReloadDuplication() throws Exception {
        JournalStorageManager journal = null;
        try {
            this.clearDataRecreateServerDirs();
            SimpleString ADDRESS = SimpleString.of((String)"address");
            Configuration configuration = this.createDefaultInVMConfig();
            FakePostOffice postOffice = new FakePostOffice();
            ScheduledExecutorService scheduledThreadPool = Executors.newScheduledThreadPool(ActiveMQDefaultConfiguration.getDefaultScheduledThreadPoolMaxSize(), (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName()));
            journal = new JournalStorageManager(configuration, (CriticalAnalyzer)EmptyCriticalAnalyzer.getInstance(), this.factory, this.factory);
            journal.start();
            journal.loadBindingJournal(new ArrayList(), new ArrayList(), new ArrayList());
            HashMap mapDups = new HashMap();
            FakePagingManager pagingManager = new FakePagingManager();
            journal.loadMessageJournal((PostOffice)postOffice, (PagingManager)pagingManager, (ResourceManager)new ResourceManagerImpl(null, 0, 0L, scheduledThreadPool), null, mapDups, null, null, (JournalLoader)new PostOfficeJournalLoader((PostOffice)postOffice, (PagingManager)pagingManager, null, null, null, null, null, null));
            Assertions.assertEquals((int)0, (int)mapDups.size());
            DuplicateIDCache cacheID = DuplicateIDCaches.persistent((SimpleString)ADDRESS, (int)10, (StorageManager)journal);
            for (int i = 0; i < 100; ++i) {
                cacheID.addToCache(RandomUtil.randomBytes());
            }
            journal.stop();
            journal = new JournalStorageManager(configuration, (CriticalAnalyzer)EmptyCriticalAnalyzer.getInstance(), this.factory, this.factory);
            journal.start();
            journal.loadBindingJournal(new ArrayList(), new ArrayList(), new ArrayList());
            journal.loadMessageJournal((PostOffice)postOffice, (PagingManager)pagingManager, (ResourceManager)new ResourceManagerImpl(null, 0, 0L, scheduledThreadPool), null, mapDups, null, null, (JournalLoader)new PostOfficeJournalLoader((PostOffice)postOffice, (PagingManager)pagingManager, null, null, null, null, null, null));
            Assertions.assertEquals((int)1, (int)mapDups.size());
            List values = (List)mapDups.get(ADDRESS);
            Assertions.assertEquals((int)10, (int)values.size());
            cacheID = DuplicateIDCaches.persistent((SimpleString)ADDRESS, (int)10, (StorageManager)journal);
            cacheID.load(values);
            for (int i = 0; i < 100; ++i) {
                cacheID.addToCache(RandomUtil.randomBytes(), null);
            }
            journal.stop();
            mapDups.clear();
            journal = new JournalStorageManager(configuration, (CriticalAnalyzer)EmptyCriticalAnalyzer.getInstance(), this.factory, this.factory);
            journal.start();
            journal.loadBindingJournal(new ArrayList(), new ArrayList(), new ArrayList());
            journal.loadMessageJournal((PostOffice)postOffice, (PagingManager)pagingManager, (ResourceManager)new ResourceManagerImpl(null, 0, 0L, scheduledThreadPool), null, mapDups, null, null, (JournalLoader)new PostOfficeJournalLoader((PostOffice)postOffice, (PagingManager)pagingManager, null, null, null, null, null, null));
            Assertions.assertEquals((int)1, (int)mapDups.size());
            values = (List)mapDups.get(ADDRESS);
            Assertions.assertEquals((int)10, (int)values.size());
            scheduledThreadPool.shutdown();
        }
        finally {
            if (journal != null) {
                try {
                    journal.stop();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

