/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.remoting.impl.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.util.HashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.remoting.impl.netty.ActiveMQChannelHandler;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnector;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.spi.core.remoting.BaseConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.BufferHandler;
import org.apache.activemq.artemis.spi.core.remoting.ClientConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManager;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.DefaultSensitiveStringCodec;
import org.apache.activemq.artemis.utils.PasswordMaskingUtil;
import org.apache.activemq.artemis.utils.SensitiveDataCodec;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class NettyConnectorTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ExecutorService executorService;
    private ClientConnectionLifeCycleListener listener = new ClientConnectionLifeCycleListener(){

        public void connectionException(Object connectionID, ActiveMQException me) {
        }

        public void connectionDestroyed(Object connectionID, boolean failed) {
        }

        public void connectionCreated(ActiveMQComponent component, Connection connection, ClientProtocolManager protocol) {
        }

        public void connectionReadyForWrites(Object connectionID, boolean ready) {
        }
    };

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.executorService = Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName()));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sslEnabled", true);
        params.put("sslProvider", "OPENSSL");
        params.put("keyStorePath", "server-keystore.jks");
        params.put("keyStorePassword", "securepass");
        params.put("trustStorePath", "client-ca-truststore.jks");
        params.put("trustStorePassword", "securepass");
        params.put("needClientAuth", true);
        ConfigurationImpl config = this.createBasicConfig().addAcceptorConfiguration(new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params, "nettySSL"));
        this.server = this.createServer(false, (Configuration)config);
        this.server.start();
        this.waitForServerToStart(this.server);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.executorService.shutdown();
        super.tearDown();
    }

    @Test
    public void testStartStop() throws Exception {
        BufferHandler handler = (connectionID, buffer) -> {};
        HashMap params = new HashMap();
        NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)this.listener, (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())), (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())), Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())));
        connector.start();
        Assertions.assertTrue((boolean)connector.isStarted());
        connector.close();
        Assertions.assertFalse((boolean)connector.isStarted());
    }

    @Test
    public void testNullParams() throws Exception {
        BufferHandler handler = (connectionID, buffer) -> {};
        HashMap params = new HashMap();
        try {
            new NettyConnector(params, null, (BaseConnectionLifeCycleListener)this.listener, (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())), (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())), Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())));
            Assertions.fail((String)"Should throw Exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new NettyConnector(params, handler, null, (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())), (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())), Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())));
            Assertions.fail((String)"Should throw Exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testJavaSystemProperty() throws Exception {
        BufferHandler handler = (connectionID, buffer) -> {};
        System.setProperty("javax.net.ssl.keyStore", "client-keystore.jks");
        System.setProperty("javax.net.ssl.keyStorePassword", "securepass");
        System.setProperty("javax.net.ssl.trustStore", "server-ca-truststore.jks");
        System.setProperty("javax.net.ssl.trustStorePassword", "securepass");
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("sslEnabled", true);
        NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)this.listener, (Executor)this.executorService, (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())), Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())));
        connector.start();
        Assertions.assertTrue((boolean)connector.isStarted());
        Connection c = connector.createConnection();
        Assertions.assertNotNull((Object)c);
        c.close();
        connector.close();
        Assertions.assertFalse((boolean)connector.isStarted());
    }

    @Test
    public void testEncryptedJavaSystemProperty() throws Exception {
        BufferHandler handler = (connectionID, buffer) -> {};
        DefaultSensitiveStringCodec codec = new DefaultSensitiveStringCodec();
        System.setProperty("javax.net.ssl.keyStore", "client-keystore.jks");
        System.setProperty("javax.net.ssl.keyStorePassword", PasswordMaskingUtil.wrap((String)codec.encode((Object)"securepass")));
        System.setProperty("javax.net.ssl.trustStore", "server-ca-truststore.jks");
        System.setProperty("javax.net.ssl.trustStorePassword", PasswordMaskingUtil.wrap((String)codec.encode((Object)"securepass")));
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("sslEnabled", true);
        NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)this.listener, (Executor)this.executorService, (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())), Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())));
        connector.start();
        Assertions.assertTrue((boolean)connector.isStarted());
        Connection c = connector.createConnection();
        Assertions.assertNotNull((Object)c);
        c.close();
        connector.close();
        Assertions.assertFalse((boolean)connector.isStarted());
    }

    @Test
    public void testEncryptedJavaSystemPropertyFail() throws Exception {
        BufferHandler handler = (connectionID, buffer) -> {};
        DefaultSensitiveStringCodec codec = new DefaultSensitiveStringCodec();
        System.setProperty("javax.net.ssl.keyStore", "client-keystore.jks");
        System.setProperty("javax.net.ssl.keyStorePassword", PasswordMaskingUtil.wrap((String)codec.encode((Object)"bad password")));
        System.setProperty("javax.net.ssl.trustStore", "server-ca-truststore.jks");
        System.setProperty("javax.net.ssl.trustStorePassword", PasswordMaskingUtil.wrap((String)codec.encode((Object)"bad password")));
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("sslEnabled", true);
        NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)this.listener, (Executor)this.executorService, (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())), Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())));
        connector.start();
        Assertions.assertTrue((boolean)connector.isStarted());
        Assertions.assertNull((Object)connector.createConnection());
        connector.close();
        Assertions.assertFalse((boolean)connector.isStarted());
    }

    @Test
    public void testOverridesJavaSystemPropertyFail() throws Exception {
        BufferHandler handler = (connectionID, buffer) -> {};
        System.setProperty("javax.net.ssl.keyStore", "bad path");
        System.setProperty("javax.net.ssl.keyStorePassword", "bad password");
        System.setProperty("javax.net.ssl.trustStore", "bad path");
        System.setProperty("javax.net.ssl.trustStorePassword", "bad password");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sslEnabled", true);
        params.put("keyStorePath", "client-keystore.jks");
        params.put("keyStorePassword", "securepass");
        params.put("trustStorePath", "server-ca-truststore.jks");
        params.put("trustStorePassword", "securepass");
        NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)this.listener, (Executor)this.executorService, (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())), Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())));
        connector.start();
        Assertions.assertTrue((boolean)connector.isStarted());
        Connection c = connector.createConnection();
        Assertions.assertNull((Object)c);
        connector.close();
        Assertions.assertFalse((boolean)connector.isStarted());
    }

    @Test
    public void testOverridesJavaSystemProperty() throws Exception {
        BufferHandler handler = (connectionID, buffer) -> {};
        System.setProperty("javax.net.ssl.keyStore", "client-keystore.jks");
        System.setProperty("javax.net.ssl.keyStorePassword", "securepass");
        System.setProperty("javax.net.ssl.trustStore", "server-ca-truststore.jks");
        System.setProperty("javax.net.ssl.trustStorePassword", "securepass");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sslEnabled", true);
        params.put("keyStorePath", "bad path");
        params.put("keyStorePassword", "bad password");
        params.put("trustStorePath", "bad path");
        params.put("trustStorePassword", "bad password");
        NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)this.listener, (Executor)this.executorService, (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())), Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())));
        connector.start();
        Assertions.assertTrue((boolean)connector.isStarted());
        Connection c = connector.createConnection();
        Assertions.assertNotNull((Object)c);
        c.close();
        connector.close();
        Assertions.assertFalse((boolean)connector.isStarted());
    }

    @Test
    public void testOverridesJavaSystemPropertyForceSSLParameters() throws Exception {
        BufferHandler handler = (connectionID, buffer) -> {};
        System.setProperty("javax.net.ssl.keyStore", "bad path");
        System.setProperty("javax.net.ssl.keyStorePassword", "bad password");
        System.setProperty("javax.net.ssl.trustStore", "bad path");
        System.setProperty("javax.net.ssl.trustStorePassword", "bad password");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sslEnabled", true);
        params.put("forceSSLParameters", true);
        params.put("keyStorePath", "client-keystore.jks");
        params.put("keyStorePassword", "securepass");
        params.put("trustStorePath", "server-ca-truststore.jks");
        params.put("trustStorePassword", "securepass");
        NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)this.listener, (Executor)this.executorService, (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())), Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())));
        connector.start();
        Assertions.assertTrue((boolean)connector.isStarted());
        Connection c = connector.createConnection();
        Assertions.assertNotNull((Object)c);
        c.close();
        connector.close();
        Assertions.assertFalse((boolean)connector.isStarted());
    }

    @Test
    public void testOverridesJavaSystemPropertyForceSSLParameters2() throws Exception {
        BufferHandler handler = (connectionID, buffer) -> {};
        System.setProperty("javax.net.ssl.keyStore", "client-keystore.jks");
        System.setProperty("javax.net.ssl.keyStorePassword", "securepass");
        System.setProperty("javax.net.ssl.trustStore", "server-ca-truststore.jks");
        System.setProperty("javax.net.ssl.trustStorePassword", "securepass");
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("sslEnabled", true);
        params.put("forceSSLParameters", true);
        NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)this.listener, (Executor)this.executorService, (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())), Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())));
        connector.start();
        Assertions.assertTrue((boolean)connector.isStarted());
        Object c = null;
        try {
            connector.createConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertNull(c);
    }

    @Test
    public void testActiveMQSystemProperties() throws Exception {
        BufferHandler handler = (connectionID, buffer) -> {};
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("sslEnabled", true);
        NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)this.listener, (Executor)this.executorService, (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())), Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())));
        System.setProperty("org.apache.activemq.ssl.keyStore", "client-keystore.jks");
        System.setProperty("org.apache.activemq.ssl.keyStorePassword", "securepass");
        System.setProperty("org.apache.activemq.ssl.trustStore", "server-ca-truststore.jks");
        System.setProperty("org.apache.activemq.ssl.trustStorePassword", "securepass");
        connector.start();
        Assertions.assertTrue((boolean)connector.isStarted());
        Connection c = connector.createConnection();
        Assertions.assertNotNull((Object)c);
        connector.close();
        Assertions.assertFalse((boolean)connector.isStarted());
    }

    @Test
    public void testEncryptedActiveMQSystemProperties() throws Exception {
        BufferHandler handler = (connectionID, buffer) -> {};
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("sslEnabled", true);
        NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)this.listener, (Executor)this.executorService, (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())), Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())));
        DefaultSensitiveStringCodec codec = new DefaultSensitiveStringCodec();
        System.setProperty("org.apache.activemq.ssl.keyStore", "client-keystore.jks");
        System.setProperty("org.apache.activemq.ssl.keyStorePassword", PasswordMaskingUtil.wrap((String)codec.encode((Object)"securepass")));
        System.setProperty("org.apache.activemq.ssl.trustStore", "server-ca-truststore.jks");
        System.setProperty("org.apache.activemq.ssl.trustStorePassword", PasswordMaskingUtil.wrap((String)codec.encode((Object)"securepass")));
        connector.start();
        Assertions.assertTrue((boolean)connector.isStarted());
        Connection c = connector.createConnection();
        Assertions.assertNotNull((Object)c);
        connector.close();
        Assertions.assertFalse((boolean)connector.isStarted());
    }

    @Test
    public void testEncryptedActiveMQSystemPropertiesFail() throws Exception {
        BufferHandler handler = (connectionID, buffer) -> {};
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("sslEnabled", true);
        NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)this.listener, (Executor)this.executorService, (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())), Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())));
        DefaultSensitiveStringCodec codec = new DefaultSensitiveStringCodec();
        System.setProperty("org.apache.activemq.ssl.keyStore", "client-keystore.jks");
        System.setProperty("org.apache.activemq.ssl.keyStorePassword", PasswordMaskingUtil.wrap((String)codec.encode((Object)"bad password")));
        System.setProperty("org.apache.activemq.ssl.trustStore", "server-ca-truststore.jks");
        System.setProperty("org.apache.activemq.ssl.trustStorePassword", PasswordMaskingUtil.wrap((String)codec.encode((Object)"bad password")));
        connector.start();
        Assertions.assertTrue((boolean)connector.isStarted());
        Assertions.assertNull((Object)connector.createConnection());
        connector.close();
        Assertions.assertFalse((boolean)connector.isStarted());
    }

    @Test
    public void testEncryptedActiveMQSystemPropertiesWithWrappedPasswordsAndCodec() throws Exception {
        BufferHandler handler = (connectionID, buffer) -> {};
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("sslEnabled", true);
        NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)this.listener, (Executor)this.executorService, (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())), Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())));
        NettyConnectorTestPasswordCodec codec = new NettyConnectorTestPasswordCodec();
        System.setProperty("org.apache.activemq.ssl.passwordCodec", NettyConnectorTestPasswordCodec.class.getName());
        System.setProperty("org.apache.activemq.ssl.keyStore", "client-keystore.jks");
        System.setProperty("org.apache.activemq.ssl.keyStorePassword", PasswordMaskingUtil.wrap((String)codec.encode("securepass")));
        System.setProperty("org.apache.activemq.ssl.trustStore", "server-ca-truststore.jks");
        System.setProperty("org.apache.activemq.ssl.trustStorePassword", PasswordMaskingUtil.wrap((String)codec.encode("securepass")));
        connector.start();
        Assertions.assertTrue((boolean)connector.isStarted());
        Connection c = connector.createConnection();
        Assertions.assertNotNull((Object)c);
        connector.close();
        Assertions.assertFalse((boolean)connector.isStarted());
    }

    @Test
    public void testEncryptedActiveMQSystemPropertiesWithBarePasswordsAndCodec() throws Exception {
        BufferHandler handler = (connectionID, buffer) -> {};
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("sslEnabled", true);
        NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)this.listener, (Executor)this.executorService, (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())), Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())));
        System.setProperty("org.apache.activemq.ssl.passwordCodec", NettyConnectorTestPasswordCodec.class.getName());
        System.setProperty("org.apache.activemq.ssl.keyStore", "client-keystore.jks");
        System.setProperty("org.apache.activemq.ssl.keyStorePassword", "securepass");
        System.setProperty("org.apache.activemq.ssl.trustStore", "server-ca-truststore.jks");
        System.setProperty("org.apache.activemq.ssl.trustStorePassword", "securepass");
        connector.start();
        Assertions.assertTrue((boolean)connector.isStarted());
        Connection c = connector.createConnection();
        Assertions.assertNotNull((Object)c);
        connector.close();
        Assertions.assertFalse((boolean)connector.isStarted());
    }

    @Test
    public void testEncryptedActiveMQSystemPropertiesWithCodecFail() throws Exception {
        BufferHandler handler = (connectionID, buffer) -> {};
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("sslEnabled", true);
        NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)this.listener, (Executor)this.executorService, (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())), Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())));
        DefaultSensitiveStringCodec codec = new DefaultSensitiveStringCodec();
        System.setProperty("org.apache.activemq.ssl.passwordCodec", NettyConnectorTestPasswordCodec.class.getName());
        System.setProperty("org.apache.activemq.ssl.keyStore", "client-keystore.jks");
        System.setProperty("org.apache.activemq.ssl.keyStorePassword", PasswordMaskingUtil.wrap((String)codec.encode((Object)"securepass")));
        System.setProperty("org.apache.activemq.ssl.trustStore", "server-ca-truststore.jks");
        System.setProperty("org.apache.activemq.ssl.trustStorePassword", PasswordMaskingUtil.wrap((String)codec.encode((Object)"securepass")));
        connector.start();
        Assertions.assertTrue((boolean)connector.isStarted());
        Assertions.assertNull((Object)connector.createConnection());
        connector.close();
        Assertions.assertFalse((boolean)connector.isStarted());
    }

    @Test
    public void testActiveMQOverridesSystemProperty() throws Exception {
        BufferHandler handler = (connectionID, buffer) -> {};
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("sslEnabled", true);
        NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)this.listener, (Executor)this.executorService, (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())), Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())));
        System.setProperty("org.apache.activemq.ssl.keyStore", "client-keystore.jks");
        System.setProperty("org.apache.activemq.ssl.keyStorePassword", "securepass");
        System.setProperty("org.apache.activemq.ssl.trustStore", "server-ca-truststore.jks");
        System.setProperty("org.apache.activemq.ssl.trustStorePassword", "securepass");
        System.setProperty("javax.net.ssl.keyStore", "bad path");
        System.setProperty("javax.net.ssl.keyStorePassword", "bad password");
        System.setProperty("javax.net.ssl.trustStore", "bad path");
        System.setProperty("javax.net.ssl.trustStorePassword", "bad password");
        connector.start();
        Assertions.assertTrue((boolean)connector.isStarted());
        Connection c = connector.createConnection();
        Assertions.assertNotNull((Object)c);
        connector.close();
        Assertions.assertFalse((boolean)connector.isStarted());
    }

    @Test
    public void testBadCipherSuite() throws Exception {
        BufferHandler handler = (connectionID, buffer) -> {};
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sslEnabled", true);
        params.put("enabledCipherSuites", "myBadCipherSuite");
        NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)this.listener, (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())), (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())), Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())));
        connector.start();
        Assertions.assertTrue((boolean)connector.isStarted());
        Assertions.assertNull((Object)connector.createConnection());
        connector.close();
        Assertions.assertFalse((boolean)connector.isStarted());
    }

    @Test
    public void testBadProtocol() throws Exception {
        BufferHandler handler = (connectionID, buffer) -> {};
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sslEnabled", true);
        params.put("enabledProtocols", "myBadProtocol");
        NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)this.listener, (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())), (Executor)Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())), Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName())));
        connector.start();
        Assertions.assertTrue((boolean)connector.isStarted());
        Assertions.assertNull((Object)connector.createConnection());
        connector.close();
        Assertions.assertFalse((boolean)connector.isStarted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChannelHandlerRemovedWhileCreatingConnection() throws Exception {
        BufferHandler handler = (connectionID, buffer) -> {};
        HashMap params = new HashMap();
        ExecutorService closeExecutor = Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName()));
        ExecutorService threadPool = Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName()));
        ScheduledExecutorService scheduledThreadPool = Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName()));
        try {
            NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)this.listener, (Executor)closeExecutor, (Executor)threadPool, scheduledThreadPool);
            connector.start();
            Connection connection = connector.createConnection(future -> {
                future.awaitUninterruptibly();
                Assertions.assertTrue((boolean)future.isSuccess());
                ChannelPipeline pipeline = future.channel().pipeline();
                ActiveMQChannelHandler activeMQChannelHandler = (ActiveMQChannelHandler)pipeline.get(ActiveMQChannelHandler.class);
                Assertions.assertNotNull((Object)activeMQChannelHandler);
                pipeline.remove((ChannelHandler)activeMQChannelHandler);
                Assertions.assertNull((Object)pipeline.get(ActiveMQChannelHandler.class));
            });
            Assertions.assertNull((Object)connection);
            connector.close();
        }
        finally {
            closeExecutor.shutdownNow();
            threadPool.shutdownNow();
            scheduledThreadPool.shutdownNow();
        }
    }

    public static class NettyConnectorTestPasswordCodec
    implements SensitiveDataCodec<String> {
        private static final String MASK = "supersecureish";
        private static final String CLEARTEXT = "securepass";

        public String decode(Object mask) throws Exception {
            if (!MASK.equals(mask)) {
                return mask.toString();
            }
            return CLEARTEXT;
        }

        public String encode(Object secret) throws Exception {
            if (!CLEARTEXT.equals(secret)) {
                return secret.toString();
            }
            return MASK;
        }
    }
}

