/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.server.impl;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.filter.impl.FilterImpl;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.HandleStatus;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.selector.filter.Filterable;
import org.apache.activemq.artemis.tests.unit.core.server.impl.fakes.FakeConsumer;
import org.apache.activemq.artemis.tests.unit.core.server.impl.fakes.FakeFilter;
import org.apache.activemq.artemis.tests.unit.core.server.impl.fakes.FakePostOffice;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.FutureLatch;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueImplTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ScheduledExecutorService scheduledExecutor;
    private ExecutorService executor;
    private ActiveMQServer defaultServer;
    private static final SimpleString queue1 = SimpleString.of((String)"queue1");
    private static final SimpleString address1 = SimpleString.of((String)"address1");

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName()));
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName()));
        this.defaultServer = this.createServer(this.createDefaultConfig(1, false));
        this.defaultServer.start();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.scheduledExecutor.shutdownNow();
        this.executor.shutdownNow();
        super.tearDown();
    }

    @Test
    public void testName() {
        SimpleString name = SimpleString.of((String)"oobblle");
        QueueImpl queue = this.getNamedQueue(name);
        Assertions.assertEquals((Object)name, (Object)queue.getName());
    }

    @Test
    public void testDurable() {
        QueueImpl queue = this.getNonDurableQueue();
        Assertions.assertFalse((boolean)queue.isDurable());
        queue = this.getDurableQueue();
        Assertions.assertTrue((boolean)queue.isDurable());
    }

    @Test
    public void testAddRemoveConsumer() throws Exception {
        FakeConsumer cons1 = new FakeConsumer();
        FakeConsumer cons2 = new FakeConsumer();
        FakeConsumer cons3 = new FakeConsumer();
        QueueImpl queue = this.getTemporaryQueue();
        Assertions.assertEquals((int)0, (int)queue.getConsumerCount());
        queue.addConsumer((Consumer)cons1);
        Assertions.assertEquals((int)1, (int)queue.getConsumerCount());
        queue.removeConsumer((Consumer)cons1);
        Assertions.assertEquals((int)0, (int)queue.getConsumerCount());
        queue.addConsumer((Consumer)cons1);
        queue.addConsumer((Consumer)cons2);
        queue.addConsumer((Consumer)cons3);
        Assertions.assertEquals((int)3, (int)queue.getConsumerCount());
        queue.removeConsumer((Consumer)new FakeConsumer());
        Assertions.assertEquals((int)3, (int)queue.getConsumerCount());
        queue.removeConsumer((Consumer)cons1);
        Assertions.assertEquals((int)2, (int)queue.getConsumerCount());
        queue.removeConsumer((Consumer)cons2);
        Assertions.assertEquals((int)1, (int)queue.getConsumerCount());
        queue.removeConsumer((Consumer)cons3);
        Assertions.assertEquals((int)0, (int)queue.getConsumerCount());
        queue.removeConsumer((Consumer)cons3);
    }

    @Test
    public void testGetFilter() {
        QueueImpl queue = this.getTemporaryQueue();
        Assertions.assertNull((Object)queue.getFilter());
        Filter filter = new Filter(){

            public boolean match(Message message) {
                return false;
            }

            public boolean match(Map<String, String> map) {
                return false;
            }

            public boolean match(Filterable filterable) {
                return false;
            }

            public SimpleString getFilterString() {
                return null;
            }
        };
        queue = this.getFilteredQueue(filter);
        Assertions.assertEquals((Object)filter, (Object)queue.getFilter());
    }

    @Test
    public void testSimpleadd() {
        QueueImpl queue = this.getTemporaryQueue();
        int numMessages = 10;
        for (int i = 0; i < 10; ++i) {
            MessageReference ref = this.generateReference((Queue)queue, i);
            queue.addTail(ref);
        }
        Assertions.assertEquals((int)10, (int)this.getMessageCount((Queue)queue));
        Assertions.assertEquals((int)0, (int)queue.getScheduledCount());
        Assertions.assertEquals((int)0, (int)queue.getDeliveringCount());
    }

    @Test
    public void testRate() throws Exception {
        QueueImpl queue = this.getTemporaryQueue();
        int numMessages = 10;
        for (int i = 0; i < 10; ++i) {
            MessageReference ref = this.generateReference((Queue)queue, i);
            queue.addTail(ref);
        }
        Thread.sleep(1000L);
        Method getRate = QueueImpl.class.getDeclaredMethod("getRate", null);
        getRate.setAccessible(true);
        float rate = ((Float)getRate.invoke((Object)queue, null)).floatValue();
        Assertions.assertTrue((rate <= 10.0f ? (byte)1 : 0) != 0);
        logger.debug("Rate: {}", (Object)Float.valueOf(rate));
    }

    @Test
    public void testSimpleNonDirectDelivery() throws Exception {
        QueueImpl queue = this.getTemporaryQueue();
        int numMessages = 10;
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        for (int i = 0; i < 10; ++i) {
            MessageReference ref = this.generateReference((Queue)queue, i);
            refs.add(ref);
            queue.addTail(ref);
        }
        Assertions.assertEquals((int)10, (int)this.getMessageCount((Queue)queue));
        Assertions.assertEquals((int)0, (int)queue.getScheduledCount());
        Assertions.assertEquals((int)0, (int)queue.getDeliveringCount());
        FakeConsumer consumer = new FakeConsumer();
        queue.addConsumer((Consumer)consumer);
        Assertions.assertTrue((boolean)consumer.getReferences().isEmpty());
        Assertions.assertEquals((int)10, (int)this.getMessageCount((Queue)queue));
        Assertions.assertEquals((int)0, (int)queue.getScheduledCount());
        queue.deliverNow();
        this.assertRefListsIdenticalRefs(refs, consumer.getReferences());
        Assertions.assertEquals((int)10, (int)this.getMessageCount((Queue)queue));
        Assertions.assertEquals((int)0, (int)queue.getScheduledCount());
        Assertions.assertEquals((int)10, (int)queue.getDeliveringCount());
    }

    @Test
    public void testBusyConsumer() throws Exception {
        QueueImpl queue = this.getTemporaryQueue();
        FakeConsumer consumer = new FakeConsumer();
        consumer.setStatusImmediate(HandleStatus.BUSY);
        queue.addConsumer((Consumer)consumer);
        int numMessages = 10;
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        for (int i = 0; i < 10; ++i) {
            MessageReference ref = this.generateReference((Queue)queue, i);
            refs.add(ref);
            queue.addTail(ref);
        }
        Assertions.assertEquals((int)10, (int)this.getMessageCount((Queue)queue));
        Assertions.assertEquals((int)0, (int)queue.getScheduledCount());
        Assertions.assertEquals((int)0, (int)queue.getDeliveringCount());
        queue.deliverNow();
        Assertions.assertEquals((int)10, (int)this.getMessageCount((Queue)queue));
        Assertions.assertEquals((int)0, (int)queue.getScheduledCount());
        Assertions.assertEquals((int)0, (int)queue.getDeliveringCount());
        Assertions.assertTrue((boolean)consumer.getReferences().isEmpty());
        consumer.setStatusImmediate(HandleStatus.HANDLED);
        queue.deliverNow();
        this.assertRefListsIdenticalRefs(refs, consumer.getReferences());
        Assertions.assertEquals((int)10, (int)this.getMessageCount((Queue)queue));
        Assertions.assertEquals((int)0, (int)queue.getScheduledCount());
        Assertions.assertEquals((int)10, (int)queue.getDeliveringCount());
    }

    @Test
    public void testBusyConsumerThenAddMoreMessages() throws Exception {
        MessageReference ref;
        int i;
        QueueImpl queue = this.getTemporaryQueue();
        FakeConsumer consumer = new FakeConsumer();
        consumer.setStatusImmediate(HandleStatus.BUSY);
        queue.addConsumer((Consumer)consumer);
        int numMessages = 10;
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        for (i = 0; i < 10; ++i) {
            ref = this.generateReference((Queue)queue, i);
            refs.add(ref);
            queue.addTail(ref);
        }
        Assertions.assertEquals((int)10, (int)this.getMessageCount((Queue)queue));
        Assertions.assertEquals((int)0, (int)queue.getScheduledCount());
        Assertions.assertEquals((int)0, (int)queue.getDeliveringCount());
        queue.deliverNow();
        Assertions.assertEquals((int)10, (int)this.getMessageCount((Queue)queue));
        Assertions.assertEquals((int)0, (int)queue.getScheduledCount());
        Assertions.assertEquals((int)0, (int)queue.getDeliveringCount());
        Assertions.assertTrue((boolean)consumer.getReferences().isEmpty());
        for (i = 10; i < 20; ++i) {
            ref = this.generateReference((Queue)queue, i);
            refs.add(ref);
            queue.addTail(ref);
        }
        Assertions.assertEquals((int)20, (int)this.getMessageCount((Queue)queue));
        Assertions.assertEquals((int)0, (int)queue.getScheduledCount());
        Assertions.assertEquals((int)0, (int)queue.getDeliveringCount());
        Assertions.assertTrue((boolean)consumer.getReferences().isEmpty());
        consumer.setStatusImmediate(HandleStatus.HANDLED);
        for (i = 20; i < 30; ++i) {
            ref = this.generateReference((Queue)queue, i);
            refs.add(ref);
            queue.addTail(ref);
        }
        queue.deliverNow();
        this.assertRefListsIdenticalRefs(refs, consumer.getReferences());
        Assertions.assertEquals((int)30, (int)this.getMessageCount((Queue)queue));
        Assertions.assertEquals((int)0, (int)queue.getScheduledCount());
        Assertions.assertEquals((int)30, (int)queue.getDeliveringCount());
    }

    @Test
    public void testaddHeadadd() throws Exception {
        QueueImpl queue = this.getTemporaryQueue();
        int numMessages = 10;
        ArrayList<MessageReference> refs1 = new ArrayList<MessageReference>();
        for (int i = 0; i < 10; ++i) {
            MessageReference ref = this.generateReference((Queue)queue, i);
            refs1.add(ref);
            queue.addTail(ref);
        }
        LinkedList<MessageReference> refs2 = new LinkedList<MessageReference>();
        for (int i = 0; i < 10; ++i) {
            MessageReference ref = this.generateReference((Queue)queue, i + 10);
            refs2.addFirst(ref);
            queue.addHead(ref, false);
        }
        ArrayList<MessageReference> refs3 = new ArrayList<MessageReference>();
        for (int i = 0; i < 10; ++i) {
            MessageReference ref = this.generateReference((Queue)queue, i + 20);
            refs3.add(ref);
            queue.addTail(ref);
        }
        FakeConsumer consumer = new FakeConsumer();
        queue.addConsumer((Consumer)consumer);
        queue.deliverNow();
        ArrayList<MessageReference> allRefs = new ArrayList<MessageReference>();
        allRefs.addAll(refs2);
        allRefs.addAll(refs1);
        allRefs.addAll(refs3);
        this.assertRefListsIdenticalRefs(allRefs, consumer.getReferences());
    }

    @Test
    public void testChangeConsumersAndDeliver() throws Exception {
        MessageReference ref4;
        QueueImpl queue = this.getTemporaryQueue();
        int numMessages = 10;
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        for (int i = 0; i < 10; ++i) {
            MessageReference ref2 = this.generateReference((Queue)queue, i);
            refs.add(ref2);
            queue.addTail(ref2);
        }
        Assertions.assertEquals((int)10, (int)this.getMessageCount((Queue)queue));
        Assertions.assertEquals((int)0, (int)queue.getScheduledCount());
        Assertions.assertEquals((int)0, (int)queue.getDeliveringCount());
        FakeConsumer cons1 = new FakeConsumer();
        queue.addConsumer((Consumer)cons1);
        queue.deliverNow();
        Assertions.assertEquals((int)10, (int)this.getMessageCount((Queue)queue));
        Assertions.assertEquals((int)0, (int)queue.getScheduledCount());
        Assertions.assertEquals((int)10, (int)queue.getDeliveringCount());
        this.assertRefListsIdenticalRefs(refs, cons1.getReferences());
        FakeConsumer cons2 = new FakeConsumer();
        queue.addConsumer((Consumer)cons2);
        Assertions.assertEquals((int)2, (int)queue.getConsumerCount());
        cons1.getReferences().clear();
        for (MessageReference ref3 : refs) {
            ref3.getMessage().refUp();
            queue.acknowledge(ref3);
        }
        refs.clear();
        for (int i = 0; i < 20; ++i) {
            MessageReference ref3;
            ref3 = this.generateReference((Queue)queue, i);
            refs.add(ref3);
            queue.addTail(ref3);
        }
        queue.deliverNow();
        Assertions.assertEquals((int)20, (int)this.getMessageCount((Queue)queue));
        Assertions.assertEquals((int)0, (int)queue.getScheduledCount());
        Assertions.assertEquals((int)20, (int)queue.getDeliveringCount());
        Assertions.assertEquals((int)10, (int)cons1.getReferences().size());
        Assertions.assertEquals((int)10, (int)cons2.getReferences().size());
        cons1.getReferences().clear();
        cons2.getReferences().clear();
        for (MessageReference ref3 : refs) {
            queue.acknowledge(ref3);
        }
        refs.clear();
        FakeConsumer cons3 = new FakeConsumer();
        queue.addConsumer((Consumer)cons3);
        Assertions.assertEquals((int)3, (int)queue.getConsumerCount());
        for (int i = 0; i < 30; ++i) {
            ref4 = this.generateReference((Queue)queue, i);
            refs.add(ref4);
            queue.addTail(ref4);
        }
        queue.deliverNow();
        Assertions.assertEquals((int)30, (int)this.getMessageCount((Queue)queue));
        Assertions.assertEquals((int)0, (int)queue.getScheduledCount());
        Assertions.assertEquals((int)30, (int)queue.getDeliveringCount());
        Assertions.assertEquals((int)10, (int)cons1.getReferences().size());
        Assertions.assertEquals((int)10, (int)cons2.getReferences().size());
        Assertions.assertEquals((int)10, (int)cons3.getReferences().size());
        queue.removeConsumer((Consumer)cons1);
        cons3.getReferences().clear();
        cons2.getReferences().clear();
        for (MessageReference ref4 : refs) {
            queue.acknowledge(ref4);
        }
        refs.clear();
        for (int i = 0; i < 20; ++i) {
            ref4 = this.generateReference((Queue)queue, i);
            refs.add(ref4);
            queue.addTail(ref4);
        }
        queue.deliverNow();
        Assertions.assertEquals((int)20, (int)this.getMessageCount((Queue)queue));
        Assertions.assertEquals((int)0, (int)queue.getScheduledCount());
        Assertions.assertEquals((int)20, (int)queue.getDeliveringCount());
        Assertions.assertEquals((int)10, (int)cons2.getReferences().size());
        Assertions.assertEquals((int)10, (int)cons3.getReferences().size());
        queue.removeConsumer((Consumer)cons3);
        cons2.getReferences().clear();
        for (MessageReference ref4 : refs) {
            queue.acknowledge(ref4);
        }
        refs.clear();
        for (int i = 0; i < 10; ++i) {
            ref4 = this.generateReference((Queue)queue, i);
            refs.add(ref4);
            queue.addTail(ref4);
        }
        queue.deliverNow();
        Assertions.assertEquals((int)10, (int)this.getMessageCount((Queue)queue));
        Assertions.assertEquals((int)0, (int)queue.getScheduledCount());
        Assertions.assertEquals((int)10, (int)queue.getDeliveringCount());
        Assertions.assertEquals((int)10, (int)cons2.getReferences().size());
    }

    @Test
    public void testRoundRobinWithQueueing() throws Exception {
        QueueImpl queue = this.getTemporaryQueue();
        int numMessages = 10;
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        queue.pause();
        FakeConsumer cons1 = new FakeConsumer();
        FakeConsumer cons2 = new FakeConsumer();
        queue.addConsumer((Consumer)cons1);
        queue.addConsumer((Consumer)cons2);
        for (int i = 0; i < 10; ++i) {
            MessageReference ref = this.generateReference((Queue)queue, i);
            refs.add(ref);
            queue.addTail(ref);
        }
        queue.resume();
        long timeout = System.currentTimeMillis() + 5000L;
        while (cons1.getReferences().size() != 5 && timeout > System.currentTimeMillis()) {
            Thread.sleep(1L);
        }
        while (cons2.getReferences().size() != 5 && timeout > System.currentTimeMillis()) {
            Thread.sleep(1L);
        }
        Assertions.assertEquals((int)5, (int)cons1.getReferences().size());
        Assertions.assertEquals((int)5, (int)cons2.getReferences().size());
        for (int i = 0; i < 10; ++i) {
            MessageReference ref = i % 2 == 0 ? cons1.getReferences().get(i / 2) : cons2.getReferences().get(i / 2);
            Assertions.assertEquals(refs.get(i), (Object)ref);
        }
    }

    @Test
    public void testWithPriorities() throws Exception {
        QueueImpl queue = this.getTemporaryQueue();
        int numMessages = 10;
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        for (int i = 0; i < 10; ++i) {
            MessageReference ref = this.generateReference((Queue)queue, i);
            ref.getMessage().setPriority((byte)i);
            refs.add(ref);
            queue.addTail(ref);
        }
        queue.deliverNow();
        FakeConsumer consumer = new FakeConsumer();
        queue.addConsumer((Consumer)consumer);
        queue.deliverNow();
        List<MessageReference> receivedRefs = consumer.getReferences();
        Assertions.assertEquals((int)refs.size(), (int)receivedRefs.size());
        for (int i = 0; i < 10; ++i) {
            Assertions.assertEquals(refs.get(i), (Object)receivedRefs.get(9 - i));
        }
    }

    @Test
    public void testConsumerWithFiltersDirect() throws Exception {
        this.testConsumerWithFilters(true);
    }

    @Test
    public void testConsumerWithFiltersQueueing() throws Exception {
        this.testConsumerWithFilters(false);
    }

    @Test
    public void testConsumerWithFilterAddAndRemove() {
        QueueImpl queue = this.getTemporaryQueue();
        FakeFilter filter = new FakeFilter("fruit", "orange");
        FakeConsumer consumer = new FakeConsumer(filter);
    }

    @Test
    public void testIterator() {
        QueueImpl queue = this.getTemporaryQueue();
        int numMessages = 20;
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        for (int i = 0; i < 20; ++i) {
            MessageReference ref = this.generateReference((Queue)queue, i);
            queue.addTail(ref);
            refs.add(ref);
        }
        Assertions.assertEquals((int)20, (int)this.getMessageCount((Queue)queue));
        LinkedListIterator iterator = queue.iterator();
        ArrayList<MessageReference> list = new ArrayList<MessageReference>();
        while (iterator.hasNext()) {
            list.add((MessageReference)iterator.next());
        }
        this.assertRefListsIdenticalRefs(refs, list);
    }

    private void awaitExecution() {
        FutureLatch future = new FutureLatch();
        this.executor.execute((Runnable)future);
        future.await(10000L);
    }

    @Test
    public void testConsumeWithFiltersAddAndRemoveConsumer() throws Exception {
        QueueImpl queue = this.getTemporaryQueue();
        FakeFilter filter = new FakeFilter("fruit", "orange");
        FakeConsumer consumer = new FakeConsumer(filter);
        queue.addConsumer((Consumer)consumer);
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        MessageReference ref1 = this.generateReference((Queue)queue, 1L);
        ref1.getMessage().putStringProperty(SimpleString.of((String)"fruit"), SimpleString.of((String)"banana"));
        queue.addTail(ref1);
        MessageReference ref2 = this.generateReference((Queue)queue, 2L);
        ref2.getMessage().putStringProperty(SimpleString.of((String)"fruit"), SimpleString.of((String)"orange"));
        queue.addTail(ref2);
        refs.add(ref2);
        Assertions.assertEquals((int)2, (int)this.getMessageCount((Queue)queue));
        this.awaitExecution();
        Assertions.assertEquals((int)1, (int)consumer.getReferences().size());
        Assertions.assertEquals((int)1, (int)queue.getDeliveringCount());
        this.assertRefListsIdenticalRefs(refs, consumer.getReferences());
        queue.acknowledge(ref2);
        queue.removeConsumer((Consumer)consumer);
        queue.addConsumer((Consumer)consumer);
        queue.deliverNow();
        refs.clear();
        consumer.clearReferences();
        MessageReference ref3 = this.generateReference((Queue)queue, 3L);
        ref3.getMessage().putStringProperty(SimpleString.of((String)"fruit"), SimpleString.of((String)"banana"));
        queue.addTail(ref3);
        MessageReference ref4 = this.generateReference((Queue)queue, 4L);
        ref4.getMessage().putStringProperty(SimpleString.of((String)"fruit"), SimpleString.of((String)"orange"));
        queue.addTail(ref4);
        refs.add(ref4);
        Assertions.assertEquals((int)3, (int)this.getMessageCount((Queue)queue));
        this.awaitExecution();
        Assertions.assertEquals((int)1, (int)consumer.getReferences().size());
        Assertions.assertEquals((int)1, (int)queue.getDeliveringCount());
        this.assertRefListsIdenticalRefs(refs, consumer.getReferences());
    }

    @Test
    public void testBusyConsumerWithFilterFirstCallBusy() throws Exception {
        QueueImpl queue = this.getTemporaryQueue();
        FakeConsumer consumer = new FakeConsumer(FilterImpl.createFilter((String)"color = 'green'"));
        consumer.setStatusImmediate(HandleStatus.BUSY);
        queue.addConsumer((Consumer)consumer);
        int numMessages = 10;
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        for (int i = 0; i < 10; ++i) {
            MessageReference ref = this.generateReference((Queue)queue, i);
            ref.getMessage().putStringProperty("color", "green");
            refs.add(ref);
            queue.addTail(ref);
        }
        Assertions.assertEquals((int)10, (int)this.getMessageCount((Queue)queue));
        Assertions.assertEquals((int)0, (int)queue.getScheduledCount());
        Assertions.assertEquals((int)0, (int)queue.getDeliveringCount());
        queue.deliverNow();
        consumer.setStatusImmediate(null);
        queue.deliverNow();
        List<MessageReference> receeivedRefs = consumer.getReferences();
        int currId = 0;
        for (MessageReference receeivedRef : receeivedRefs) {
            Assertions.assertEquals((long)receeivedRef.getMessage().getMessageID(), (long)currId++, (String)"messages received out of order");
        }
    }

    @Test
    public void testBusyConsumerWithFilterThenAddMoreMessages() throws Exception {
        MessageReference ref;
        int i;
        QueueImpl queue = this.getTemporaryQueue();
        FakeConsumer consumer = new FakeConsumer(FilterImpl.createFilter((String)"color = 'green'"));
        consumer.setStatusImmediate(HandleStatus.BUSY);
        queue.addConsumer((Consumer)consumer);
        int numMessages = 10;
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        for (i = 0; i < 10; ++i) {
            ref = this.generateReference((Queue)queue, i);
            ref.getMessage().putStringProperty("color", "red");
            refs.add(ref);
            queue.addTail(ref);
        }
        Assertions.assertEquals((int)10, (int)this.getMessageCount((Queue)queue));
        Assertions.assertEquals((int)0, (int)queue.getScheduledCount());
        Assertions.assertEquals((int)0, (int)queue.getDeliveringCount());
        queue.deliverNow();
        Assertions.assertEquals((int)10, (int)this.getMessageCount((Queue)queue));
        Assertions.assertEquals((int)0, (int)queue.getScheduledCount());
        Assertions.assertEquals((int)0, (int)queue.getDeliveringCount());
        Assertions.assertTrue((boolean)consumer.getReferences().isEmpty());
        for (i = 10; i < 20; ++i) {
            ref = this.generateReference((Queue)queue, i);
            refs.add(ref);
            ref.getMessage().putStringProperty("color", "green");
            queue.addTail(ref);
        }
        Assertions.assertEquals((int)20, (int)this.getMessageCount((Queue)queue));
        Assertions.assertEquals((int)0, (int)queue.getScheduledCount());
        Assertions.assertEquals((int)0, (int)queue.getDeliveringCount());
        Assertions.assertTrue((boolean)consumer.getReferences().isEmpty());
        consumer.setStatusImmediate(null);
        for (i = 20; i < 30; ++i) {
            ref = this.generateReference((Queue)queue, i);
            refs.add(ref);
            queue.addTail(ref);
        }
        queue.deliverNow();
        Assertions.assertEquals((int)10, (int)consumer.getReferences().size());
        Assertions.assertEquals((int)30, (int)this.getMessageCount((Queue)queue));
        Assertions.assertEquals((int)0, (int)queue.getScheduledCount());
        Assertions.assertEquals((int)10, (int)queue.getDeliveringCount());
        List<MessageReference> receeivedRefs = consumer.getReferences();
        int currId = 10;
        for (MessageReference receeivedRef : receeivedRefs) {
            Assertions.assertEquals((long)receeivedRef.getMessage().getMessageID(), (long)currId++, (String)"messages received out of order");
        }
    }

    @Test
    public void testConsumerWithFilterThenAddMoreMessages() throws Exception {
        MessageReference ref;
        int i;
        QueueImpl queue = this.getTemporaryQueue();
        int numMessages = 10;
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        for (i = 0; i < 10; ++i) {
            ref = this.generateReference((Queue)queue, i);
            ref.getMessage().putStringProperty("color", "red");
            refs.add(ref);
            queue.addTail(ref);
        }
        Assertions.assertEquals((int)10, (int)this.getMessageCount((Queue)queue));
        Assertions.assertEquals((int)0, (int)queue.getScheduledCount());
        Assertions.assertEquals((int)0, (int)queue.getDeliveringCount());
        queue.deliverNow();
        Assertions.assertEquals((int)10, (int)this.getMessageCount((Queue)queue));
        Assertions.assertEquals((int)0, (int)queue.getScheduledCount());
        Assertions.assertEquals((int)0, (int)queue.getDeliveringCount());
        for (i = 10; i < 20; ++i) {
            ref = this.generateReference((Queue)queue, i);
            refs.add(ref);
            ref.getMessage().putStringProperty("color", "green");
            queue.addTail(ref);
        }
        FakeConsumer consumer = new FakeConsumer(FilterImpl.createFilter((String)"color = 'green'"));
        queue.addConsumer((Consumer)consumer);
        queue.deliverNow();
        Assertions.assertEquals((int)20, (int)this.getMessageCount((Queue)queue));
        Assertions.assertEquals((int)0, (int)queue.getScheduledCount());
        Assertions.assertEquals((int)10, (int)queue.getDeliveringCount());
        for (int i2 = 20; i2 < 30; ++i2) {
            MessageReference ref2 = this.generateReference((Queue)queue, i2);
            refs.add(ref2);
            ref2.getMessage().putStringProperty("color", "green");
            queue.addTail(ref2);
        }
        queue.deliverNow();
        Assertions.assertEquals((int)20, (int)consumer.getReferences().size());
        Assertions.assertEquals((int)30, (int)this.getMessageCount((Queue)queue));
        Assertions.assertEquals((int)0, (int)queue.getScheduledCount());
        Assertions.assertEquals((int)20, (int)queue.getDeliveringCount());
    }

    @Test
    public void testNoMatchConsumersAllowsRedistribution() throws Exception {
        QueueImpl queue = this.getTemporaryQueue();
        int numMessages = 2;
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        for (int i = 0; i < 2; ++i) {
            MessageReference ref = this.generateReference((Queue)queue, i);
            ref.getMessage().putStringProperty("color", "red");
            refs.add(ref);
            queue.addTail(ref);
        }
        Assertions.assertEquals((int)2, (int)this.getMessageCount((Queue)queue));
        queue.deliverNow();
        Assertions.assertEquals((int)2, (int)this.getMessageCount((Queue)queue));
        FakeConsumer consumer = new FakeConsumer(FilterImpl.createFilter((String)"color = 'green'"));
        queue.addConsumer((Consumer)consumer);
        FakeConsumer consumer2 = new FakeConsumer(FilterImpl.createFilter((String)"color = 'orange'"));
        queue.addConsumer((Consumer)consumer2);
        queue.deliverNow();
        Assertions.assertEquals((int)0, (int)consumer.getReferences().size());
        Assertions.assertEquals((int)0, (int)consumer2.getReferences().size());
        try {
            queue.addRedistributor(0L);
            Assertions.fail((String)"expect error on attempt to add addRedistributor - npe b/c no storage etc");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        FakeConsumer consumer3 = new FakeConsumer(FilterImpl.createFilter((String)"color = 'blue'"));
        queue.addConsumer((Consumer)consumer3);
        queue.deliverNow();
        Assertions.assertEquals((int)0, (int)consumer.getReferences().size());
        Assertions.assertEquals((int)0, (int)consumer2.getReferences().size());
        Assertions.assertEquals((int)0, (int)consumer3.getReferences().size());
        queue.addRedistributor(0L);
        MessageReference ref = this.generateReference((Queue)queue, 2L);
        ref.getMessage().putStringProperty("color", "red");
        refs.add(ref);
        queue.addTail(ref);
        queue.deliverNow();
        try {
            queue.addRedistributor(0L);
            Assertions.fail((String)"expect error on attempt to add addRedistributor - npe b/c no storage etc");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assertions.assertEquals((int)3, (int)this.getMessageCount((Queue)queue));
    }

    @Test
    public void testNoMatchOn3AllowsRedistribution() throws Exception {
        QueueImpl queue = this.getTemporaryQueue();
        int i = 0;
        MessageReference ref = this.generateReference((Queue)queue, i++);
        ref.getMessage().putStringProperty("color", "red");
        queue.addTail(ref);
        ref = this.generateReference((Queue)queue, i++);
        ref.getMessage().putStringProperty("color", "red");
        queue.addTail(ref);
        ref = this.generateReference((Queue)queue, i++);
        ref.getMessage().putStringProperty("color", "blue");
        queue.addTail(ref);
        Assertions.assertEquals((int)3, (int)this.getMessageCount((Queue)queue));
        FakeConsumer consumerRed = new FakeConsumer(FilterImpl.createFilter((String)"color = 'red'"));
        queue.addConsumer((Consumer)consumerRed);
        FakeConsumer consumerOrange = new FakeConsumer(FilterImpl.createFilter((String)"color = 'orange'"));
        queue.addConsumer((Consumer)consumerOrange);
        queue.deliverNow();
        Assertions.assertEquals((int)2, (int)consumerRed.getReferences().size());
        Assertions.assertEquals((int)0, (int)consumerOrange.getReferences().size());
        try {
            queue.addRedistributor(0L);
            Assertions.fail((String)"expect error on attempt to add addRedistributor - npe b/c no storage etc");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testNoRedistributorInternalQueue() throws Exception {
        QueueImpl queue = this.getTemporaryQueue();
        queue.setInternalQueue(true);
        queue.addRedistributor(0L);
        Assertions.assertNull((Object)queue.getRedistributor());
    }

    private void testConsumerWithFilters(boolean direct) throws Exception {
        QueueImpl queue = this.getTemporaryQueue();
        FakeFilter filter = new FakeFilter("fruit", "orange");
        FakeConsumer consumer = new FakeConsumer(filter);
        if (direct) {
            queue.addConsumer((Consumer)consumer);
        }
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        MessageReference ref1 = this.generateReference((Queue)queue, 1L);
        ref1.getMessage().putStringProperty(SimpleString.of((String)"fruit"), SimpleString.of((String)"banana"));
        queue.addTail(ref1);
        MessageReference ref2 = this.generateReference((Queue)queue, 2L);
        ref2.getMessage().putStringProperty(SimpleString.of((String)"cheese"), SimpleString.of((String)"stilton"));
        queue.addTail(ref2);
        MessageReference ref3 = this.generateReference((Queue)queue, 3L);
        ref3.getMessage().putStringProperty(SimpleString.of((String)"cake"), SimpleString.of((String)"sponge"));
        queue.addTail(ref3);
        MessageReference ref4 = this.generateReference((Queue)queue, 4L);
        ref4.getMessage().putStringProperty(SimpleString.of((String)"fruit"), SimpleString.of((String)"orange"));
        refs.add(ref4);
        queue.addTail(ref4);
        MessageReference ref5 = this.generateReference((Queue)queue, 5L);
        ref5.getMessage().putStringProperty(SimpleString.of((String)"fruit"), SimpleString.of((String)"apple"));
        queue.addTail(ref5);
        MessageReference ref6 = this.generateReference((Queue)queue, 6L);
        ref6.getMessage().putStringProperty(SimpleString.of((String)"fruit"), SimpleString.of((String)"orange"));
        refs.add(ref6);
        queue.addTail(ref6);
        if (!direct) {
            queue.addConsumer((Consumer)consumer);
            queue.deliverNow();
        }
        Assertions.assertEquals((int)6, (int)this.getMessageCount((Queue)queue));
        this.awaitExecution();
        Assertions.assertEquals((int)2, (int)consumer.getReferences().size());
        Assertions.assertEquals((int)2, (int)queue.getDeliveringCount());
        this.assertRefListsIdenticalRefs(refs, consumer.getReferences());
        queue.acknowledge(ref5);
        queue.acknowledge(ref6);
        queue.removeConsumer((Consumer)consumer);
        consumer = new FakeConsumer();
        queue.addConsumer((Consumer)consumer);
        queue.deliverNow();
        Assertions.assertEquals((int)4, (int)this.getMessageCount((Queue)queue));
        Assertions.assertEquals((int)4, (int)consumer.getReferences().size());
        Assertions.assertEquals((int)4, (int)queue.getDeliveringCount());
    }

    @Test
    public void testMessageOrder() throws Exception {
        FakeConsumer consumer = new FakeConsumer();
        QueueImpl queue = this.getTemporaryQueue();
        MessageReference messageReference = this.generateReference((Queue)queue, 1L);
        MessageReference messageReference2 = this.generateReference((Queue)queue, 2L);
        MessageReference messageReference3 = this.generateReference((Queue)queue, 3L);
        queue.addHead(messageReference, false);
        queue.addTail(messageReference2);
        queue.addHead(messageReference3, false);
        Assertions.assertEquals((int)0, (int)consumer.getReferences().size());
        queue.addConsumer((Consumer)consumer);
        queue.deliverNow();
        Assertions.assertEquals((int)3, (int)consumer.getReferences().size());
        Assertions.assertEquals((Object)messageReference3, (Object)consumer.getReferences().get(0));
        Assertions.assertEquals((Object)messageReference, (Object)consumer.getReferences().get(1));
        Assertions.assertEquals((Object)messageReference2, (Object)consumer.getReferences().get(2));
    }

    @Test
    public void testMessagesAdded() throws Exception {
        QueueImpl queue = this.getTemporaryQueue();
        MessageReference messageReference = this.generateReference((Queue)queue, 1L);
        MessageReference messageReference2 = this.generateReference((Queue)queue, 2L);
        MessageReference messageReference3 = this.generateReference((Queue)queue, 3L);
        queue.addTail(messageReference);
        queue.addTail(messageReference2);
        queue.addTail(messageReference3);
        Assertions.assertEquals((int)this.getMessagesAdded((Queue)queue), (int)3);
    }

    @Test
    public void testGetReference() throws Exception {
        QueueImpl queue = this.getTemporaryQueue();
        MessageReference messageReference = this.generateReference((Queue)queue, 1L);
        MessageReference messageReference2 = this.generateReference((Queue)queue, 2L);
        MessageReference messageReference3 = this.generateReference((Queue)queue, 3L);
        queue.addHead(messageReference, false);
        queue.addHead(messageReference2, false);
        queue.addHead(messageReference3, false);
        Assertions.assertEquals((Object)queue.getReference(2L), (Object)messageReference2);
    }

    @Test
    public void testGetNonExistentReference() throws Exception {
        QueueImpl queue = this.getTemporaryQueue();
        MessageReference messageReference = this.generateReference((Queue)queue, 1L);
        MessageReference messageReference2 = this.generateReference((Queue)queue, 2L);
        MessageReference messageReference3 = this.generateReference((Queue)queue, 3L);
        queue.addHead(messageReference, false);
        queue.addHead(messageReference2, false);
        queue.addHead(messageReference3, false);
        Assertions.assertNull((Object)queue.getReference(5L));
    }

    @Test
    public void testPauseAndResumeWithAsync() throws Exception {
        QueueImpl queue = this.getTemporaryQueue();
        queue.pause();
        int numMessages = 10;
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        for (int i = 0; i < 10; ++i) {
            MessageReference ref = this.generateReference((Queue)queue, i);
            refs.add(ref);
            queue.addTail(ref);
        }
        Assertions.assertEquals((int)10, (int)this.getMessageCount((Queue)queue));
        Assertions.assertEquals((int)0, (int)queue.getScheduledCount());
        Assertions.assertEquals((int)0, (int)queue.getDeliveringCount());
        FakeConsumer consumer = new FakeConsumer();
        queue.addConsumer((Consumer)consumer);
        Assertions.assertTrue((boolean)consumer.getReferences().isEmpty());
        Assertions.assertEquals((int)10, (int)this.getMessageCount((Queue)queue));
        Assertions.assertEquals((int)0, (int)queue.getScheduledCount());
        queue.deliverNow();
        Assertions.assertEquals((int)0, (int)consumer.getReferences().size());
        Assertions.assertEquals((int)10, (int)this.getMessageCount((Queue)queue));
        Assertions.assertEquals((int)0, (int)queue.getScheduledCount());
        Assertions.assertEquals((int)0, (int)queue.getDeliveringCount());
        queue.resume();
        this.awaitExecution();
        this.assertRefListsIdenticalRefs(refs, consumer.getReferences());
        Assertions.assertEquals((int)10, (int)this.getMessageCount((Queue)queue));
        Assertions.assertEquals((int)0, (int)queue.getScheduledCount());
        Assertions.assertEquals((int)10, (int)queue.getDeliveringCount());
    }

    @Test
    public void testPauseAndResumeWithDirect() throws Exception {
        QueueImpl queue = this.getTemporaryQueue();
        FakeConsumer consumer = new FakeConsumer();
        queue.addConsumer((Consumer)consumer);
        queue.pause();
        int numMessages = 10;
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        for (int i = 0; i < 10; ++i) {
            MessageReference ref = this.generateReference((Queue)queue, i);
            refs.add(ref);
            queue.addTail(ref);
        }
        Assertions.assertEquals((int)10, (int)this.getMessageCount((Queue)queue));
        Assertions.assertEquals((int)0, (int)queue.getScheduledCount());
        Assertions.assertEquals((int)0, (int)queue.getDeliveringCount());
        Assertions.assertTrue((boolean)consumer.getReferences().isEmpty());
        queue.resume();
        this.awaitExecution();
        this.assertRefListsIdenticalRefs(refs, consumer.getReferences());
        Assertions.assertEquals((int)10, (int)this.getMessageCount((Queue)queue));
        Assertions.assertEquals((int)10, (int)queue.getDeliveringCount());
    }

    @Test
    public void testResetMessagesAdded() throws Exception {
        QueueImpl queue = this.getTemporaryQueue();
        MessageReference messageReference = this.generateReference((Queue)queue, 1L);
        MessageReference messageReference2 = this.generateReference((Queue)queue, 2L);
        queue.addTail(messageReference);
        queue.addTail(messageReference2);
        Assertions.assertEquals((int)2, (int)this.getMessagesAdded((Queue)queue));
        queue.resetMessagesAdded();
        Assertions.assertEquals((int)0, (int)this.getMessagesAdded((Queue)queue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTotalIteratorOrder() throws Exception {
        String MY_ADDRESS = "myAddress";
        String MY_QUEUE = "myQueue";
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig(), (boolean)true));
        AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(10240).setMaxSizeBytes(20480L);
        server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        server.start();
        ServerLocator locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        ClientSessionFactory factory = this.createSessionFactory(locator);
        ClientSession session = this.addClientSession(factory.createSession(false, true, true));
        session.createQueue(QueueConfiguration.of((String)"myQueue").setAddress("myAddress"));
        ClientProducer producer = this.addClientProducer(session.createProducer("myAddress"));
        for (int i = 0; i < 50; ++i) {
            ClientMessage message = session.createMessage(true);
            message.getBodyBuffer().writeBytes(new byte[1024]);
            message.putIntProperty("order", i);
            producer.send((Message)message);
        }
        producer.close();
        session.close();
        factory.close();
        locator.close();
        Queue queue = ((LocalQueueBinding)server.getPostOffice().getBinding(SimpleString.of((String)"myQueue"))).getQueue();
        LinkedListIterator totalIterator = queue.browserIterator();
        try {
            int i = 0;
            while (totalIterator.hasNext()) {
                MessageReference ref = (MessageReference)totalIterator.next();
                Assertions.assertEquals((int)i++, (int)ref.getMessage().getIntProperty("order"));
            }
        }
        finally {
            totalIterator.close();
            server.stop();
        }
    }

    @Test
    public void testGroupMessageWithManyConsumers() throws Exception {
        final CountDownLatch firstMessageHandled = new CountDownLatch(1);
        final CountDownLatch finished = new CountDownLatch(2);
        FakeConsumer groupConsumer = new FakeConsumer(){
            int count = 0;

            @Override
            public synchronized HandleStatus handle(MessageReference reference) {
                if (this.count == 0) {
                    ++this.count;
                    firstMessageHandled.countDown();
                    return HandleStatus.HANDLED;
                }
                if (this.count <= 2) {
                    ++this.count;
                    finished.countDown();
                    return HandleStatus.BUSY;
                }
                return HandleStatus.HANDLED;
            }
        };
        FakeConsumer noConsumer = new FakeConsumer(){

            @Override
            public synchronized HandleStatus handle(MessageReference reference) {
                Assertions.fail((String)"this consumer isn't allowed to consume any message");
                throw new AssertionError();
            }
        };
        QueueImpl queue = new QueueImpl(1L, SimpleString.of((String)"address1"), queue1, null, null, false, true, false, this.scheduledExecutor, null, null, null, ArtemisExecutor.delegate((Executor)this.executor), this.defaultServer, null);
        queue.addConsumer((Consumer)groupConsumer);
        queue.addConsumer((Consumer)noConsumer);
        MessageReference firstMessageReference = this.generateReference((Queue)queue, 1L);
        SimpleString groupName = SimpleString.of((String)"group");
        firstMessageReference.getMessage().putStringProperty(Message.HDR_GROUP_ID, groupName);
        MessageReference secondMessageReference = this.generateReference((Queue)queue, 2L);
        secondMessageReference.getMessage().putStringProperty(Message.HDR_GROUP_ID, groupName);
        queue.addTail(firstMessageReference, true);
        Assertions.assertTrue((boolean)firstMessageHandled.await(3000L, TimeUnit.MILLISECONDS), (String)"first message isn't handled");
        Assertions.assertEquals((Object)groupConsumer, queue.getGroups().get(groupName), (String)"group consumer isn't correctly set");
        queue.addTail(secondMessageReference, true);
        boolean atLeastTwoDeliverAttempts = finished.await(3000L, TimeUnit.MILLISECONDS);
        Assertions.assertTrue((boolean)atLeastTwoDeliverAttempts);
        Thread.sleep(1000L);
        Assertions.assertEquals((long)1L, (long)queue.getMessageCount(), (String)"The second message should be in the queue");
    }

    private QueueImpl getNonDurableQueue() {
        return this.getQueue(queue1, false, false, null);
    }

    private QueueImpl getDurableQueue() {
        return this.getQueue(queue1, true, false, null);
    }

    private QueueImpl getNamedQueue(SimpleString name) {
        return this.getQueue(name, false, true, null);
    }

    private QueueImpl getFilteredQueue(Filter filter) {
        return this.getQueue(queue1, false, true, filter);
    }

    private QueueImpl getTemporaryQueue() {
        return this.getQueue(queue1, false, true, null);
    }

    private QueueImpl getQueue(SimpleString name, boolean durable, boolean temporary, Filter filter) {
        return new QueueImpl(1L, address1, name, filter, null, durable, temporary, false, this.scheduledExecutor, (PostOffice)new FakePostOffice(), null, null, ArtemisExecutor.delegate((Executor)this.executor), this.defaultServer, null);
    }

    class AddtoQueueRunner
    implements Runnable {
        QueueImpl queue;
        MessageReference messageReference;
        boolean added = false;
        CountDownLatch countDownLatch;
        boolean first;

        AddtoQueueRunner(boolean first, QueueImpl queue, MessageReference messageReference, CountDownLatch countDownLatch) {
            this.queue = queue;
            this.messageReference = messageReference;
            this.countDownLatch = countDownLatch;
            this.first = first;
        }

        @Override
        public void run() {
            if (this.first) {
                this.queue.addHead(this.messageReference, false);
            } else {
                this.queue.addTail(this.messageReference);
            }
            this.added = true;
            this.countDownLatch.countDown();
        }
    }
}

