/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.jms.jndi;

import java.net.URI;
import java.util.Map;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jndi.JNDIReferenceFactory;
import org.apache.activemq.artemis.jndi.JNDIStorable;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.uri.URISupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class ObjectFactoryTest {
    @Test
    @Timeout(value=1L)
    public void testConnectionFactory() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://0");
        String clientID = RandomUtil.randomString();
        String user = RandomUtil.randomString();
        String password = RandomUtil.randomString();
        long clientFailureCheckPeriod = RandomUtil.randomPositiveLong();
        long connectionTTL = RandomUtil.randomPositiveLong();
        long callTimeout = RandomUtil.randomPositiveLong();
        int minLargeMessageSize = RandomUtil.randomPositiveInt();
        int consumerWindowSize = RandomUtil.randomPositiveInt();
        int consumerMaxRate = RandomUtil.randomPositiveInt();
        int confirmationWindowSize = RandomUtil.randomPositiveInt();
        int producerMaxRate = RandomUtil.randomPositiveInt();
        boolean blockOnAcknowledge = RandomUtil.randomBoolean();
        boolean blockOnDurableSend = RandomUtil.randomBoolean();
        boolean blockOnNonDurableSend = RandomUtil.randomBoolean();
        boolean autoGroup = RandomUtil.randomBoolean();
        boolean preAcknowledge = RandomUtil.randomBoolean();
        String loadBalancingPolicyClassName = RandomUtil.randomString();
        boolean useGlobalPools = RandomUtil.randomBoolean();
        int scheduledThreadPoolMaxSize = RandomUtil.randomPositiveInt();
        int threadPoolMaxSize = RandomUtil.randomPositiveInt();
        long retryInterval = RandomUtil.randomPositiveLong();
        double retryIntervalMultiplier = RandomUtil.randomDouble();
        int reconnectAttempts = RandomUtil.randomPositiveInt();
        factory.setClientID(clientID);
        factory.setUser(user);
        factory.setPassword(password);
        factory.setClientFailureCheckPeriod(clientFailureCheckPeriod);
        factory.setConnectionTTL(connectionTTL);
        factory.setCallTimeout(callTimeout);
        factory.setMinLargeMessageSize(minLargeMessageSize);
        factory.setConsumerWindowSize(consumerWindowSize);
        factory.setConsumerMaxRate(consumerMaxRate);
        factory.setConfirmationWindowSize(confirmationWindowSize);
        factory.setProducerMaxRate(producerMaxRate);
        factory.setBlockOnAcknowledge(blockOnAcknowledge);
        factory.setBlockOnDurableSend(blockOnDurableSend);
        factory.setBlockOnNonDurableSend(blockOnNonDurableSend);
        factory.setAutoGroup(autoGroup);
        factory.setPreAcknowledge(preAcknowledge);
        factory.setConnectionLoadBalancingPolicyClassName(loadBalancingPolicyClassName);
        factory.setUseGlobalPools(useGlobalPools);
        factory.setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
        factory.setThreadPoolMaxSize(threadPoolMaxSize);
        factory.setRetryInterval(retryInterval);
        factory.setRetryIntervalMultiplier(retryIntervalMultiplier);
        factory.setReconnectAttempts(reconnectAttempts);
        Reference ref = JNDIReferenceFactory.createReference((String)factory.getClass().getName(), (JNDIStorable)factory);
        JNDIReferenceFactory refFactory = new JNDIReferenceFactory();
        ActiveMQConnectionFactory temp = (ActiveMQConnectionFactory)refFactory.getObjectInstance((Object)ref, null, null, null);
        Assertions.assertEquals((Object)clientID, (Object)temp.getClientID());
        Assertions.assertEquals((Object)user, (Object)temp.getUser());
        Assertions.assertEquals((Object)password, (Object)temp.getPassword());
        Assertions.assertEquals((long)clientFailureCheckPeriod, (long)temp.getClientFailureCheckPeriod());
        Assertions.assertEquals((long)connectionTTL, (long)temp.getConnectionTTL());
        Assertions.assertEquals((long)callTimeout, (long)temp.getCallTimeout());
        Assertions.assertEquals((int)minLargeMessageSize, (int)temp.getMinLargeMessageSize());
        Assertions.assertEquals((int)consumerWindowSize, (int)temp.getConsumerWindowSize());
        Assertions.assertEquals((int)consumerMaxRate, (int)temp.getConsumerMaxRate());
        Assertions.assertEquals((int)confirmationWindowSize, (int)temp.getConfirmationWindowSize());
        Assertions.assertEquals((int)producerMaxRate, (int)temp.getProducerMaxRate());
        Assertions.assertEquals((Object)blockOnAcknowledge, (Object)temp.isBlockOnAcknowledge());
        Assertions.assertEquals((Object)blockOnDurableSend, (Object)temp.isBlockOnDurableSend());
        Assertions.assertEquals((Object)blockOnNonDurableSend, (Object)temp.isBlockOnNonDurableSend());
        Assertions.assertEquals((Object)autoGroup, (Object)temp.isAutoGroup());
        Assertions.assertEquals((Object)preAcknowledge, (Object)temp.isPreAcknowledge());
        Assertions.assertEquals((Object)loadBalancingPolicyClassName, (Object)temp.getConnectionLoadBalancingPolicyClassName());
        Assertions.assertEquals((Object)useGlobalPools, (Object)temp.isUseGlobalPools());
        Assertions.assertEquals((int)scheduledThreadPoolMaxSize, (int)temp.getScheduledThreadPoolMaxSize());
        Assertions.assertEquals((int)threadPoolMaxSize, (int)temp.getThreadPoolMaxSize());
        Assertions.assertEquals((long)retryInterval, (long)temp.getRetryInterval());
        Assertions.assertEquals((double)retryIntervalMultiplier, (double)temp.getRetryIntervalMultiplier(), (double)1.0E-4);
        Assertions.assertEquals((int)reconnectAttempts, (int)temp.getReconnectAttempts());
    }

    @Test
    @Timeout(value=1L)
    public void testDestination() throws Exception {
        ActiveMQDestination dest = (ActiveMQDestination)ActiveMQJMSClient.createQueue((String)RandomUtil.randomString());
        Reference ref = JNDIReferenceFactory.createReference((String)dest.getClass().getName(), (JNDIStorable)dest);
        JNDIReferenceFactory refFactory = new JNDIReferenceFactory();
        ActiveMQDestination temp = (ActiveMQDestination)refFactory.getObjectInstance((Object)ref, null, null, null);
        Assertions.assertEquals((Object)dest.getAddress(), (Object)temp.getAddress());
    }

    @Test
    public void testJndiSslParameters() throws Exception {
        Reference reference = new Reference(ActiveMQConnectionFactory.class.getName(), JNDIReferenceFactory.class.getName(), null);
        reference.add(new StringRefAddr("brokerURL", "(tcp://localhost:61616,tcp://localhost:5545,tcp://localhost:5555)?sslEnabled=false&trustStorePath=nopath"));
        reference.add(new StringRefAddr("sslEnabled", "true"));
        reference.add(new StringRefAddr("trustStorePath", "/path/to/trustStore"));
        reference.add(new StringRefAddr("trustStorePassword", "trustStorePassword"));
        reference.add(new StringRefAddr("keyStorePath", "/path/to/keyStore"));
        reference.add(new StringRefAddr("keyStorePassword", "keyStorePassword"));
        reference.add(new StringRefAddr("doesnotexist", "somevalue"));
        JNDIReferenceFactory referenceFactory = new JNDIReferenceFactory();
        ActiveMQConnectionFactory cf = (ActiveMQConnectionFactory)referenceFactory.getObjectInstance((Object)reference, null, null, null);
        URI uri = cf.toURI();
        Map params = URISupport.parseParameters((URI)uri);
        Assertions.assertEquals((Object)"true", params.get("sslEnabled"));
        Assertions.assertEquals((Object)"/path/to/trustStore", params.get("trustStorePath"));
        Assertions.assertEquals((Object)"trustStorePassword", params.get("trustStorePassword"));
        Assertions.assertEquals((Object)"/path/to/keyStore", params.get("keyStorePath"));
        Assertions.assertEquals((Object)"keyStorePassword", params.get("keyStorePassword"));
        Assertions.assertNull(params.get("doesnotexist"));
    }
}

