/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.client;

import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.transport.amqp.AmqpSupport;
import org.apache.activemq.transport.amqp.client.AmqpAbstractResource;
import org.apache.activemq.transport.amqp.client.AmqpConnectionListener;
import org.apache.activemq.transport.amqp.client.AmqpEventSink;
import org.apache.activemq.transport.amqp.client.AmqpFrameValidator;
import org.apache.activemq.transport.amqp.client.AmqpProtocolTracer;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.activemq.transport.amqp.client.AmqpTransactionId;
import org.apache.activemq.transport.amqp.client.sasl.SaslAuthenticator;
import org.apache.activemq.transport.amqp.client.util.AsyncResult;
import org.apache.activemq.transport.amqp.client.util.ClientFuture;
import org.apache.activemq.transport.amqp.client.util.IdGenerator;
import org.apache.activemq.transport.amqp.client.util.NoOpAsyncResult;
import org.apache.activemq.transport.amqp.client.util.UnmodifiableProxy;
import org.apache.activemq.transport.netty.NettyTransport;
import org.apache.activemq.transport.netty.NettyTransportListener;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.engine.Collector;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.CollectorImpl;
import org.apache.qpid.proton.engine.impl.ProtocolTracer;
import org.apache.qpid.proton.engine.impl.TransportImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpConnection
extends AmqpAbstractResource<Connection>
implements NettyTransportListener {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final NoOpAsyncResult NOOP_REQUEST = new NoOpAsyncResult();
    private static final int DEFAULT_MAX_FRAME_SIZE = 0x100000;
    private static final int DEFAULT_CHANNEL_MAX = Short.MAX_VALUE;
    private static final IdGenerator CONNECTION_ID_GENERATOR = new IdGenerator();
    public static final long DEFAULT_CONNECT_TIMEOUT = 515000L;
    public static final long DEFAULT_CLOSE_TIMEOUT = 30000L;
    public static final long DEFAULT_DRAIN_TIMEOUT = 60000L;
    private ScheduledThreadPoolExecutor serializer;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicBoolean connected = new AtomicBoolean();
    private final AtomicLong sessionIdGenerator = new AtomicLong();
    private final AtomicLong txIdGenerator = new AtomicLong();
    private final Collector protonCollector = new CollectorImpl();
    private final NettyTransport transport;
    private final Transport protonTransport = Transport.Factory.create();
    private final String username;
    private final String password;
    private final URI remoteURI;
    private final String connectionId;
    private List<Symbol> desiredCapabilities = Collections.emptyList();
    private List<Symbol> offeredCapabilities = Collections.emptyList();
    private Map<Symbol, Object> offeredProperties = Collections.emptyMap();
    private volatile AmqpFrameValidator sentFrameInspector;
    private volatile AmqpFrameValidator receivedFrameInspector;
    private AmqpConnectionListener listener;
    private SaslAuthenticator authenticator;
    private String mechanismRestriction;
    private String authzid;
    private int idleTimeout = 0;
    private boolean idleProcessingDisabled;
    private String containerId;
    private boolean authenticated;
    private int maxFrameSize = 0x100000;
    private int channelMax = Short.MAX_VALUE;
    private int sessionIncomingCapacity = 0;
    private long connectTimeout = 515000L;
    private long closeTimeout = 30000L;
    private long drainTimeout = 60000L;
    private boolean trace;
    private boolean noContainerID = false;

    public AmqpConnection(NettyTransport transport, String username, String password) {
        this.setEndpoint(Connection.Factory.create());
        ((Connection)this.getEndpoint()).collect(this.protonCollector);
        this.transport = transport;
        this.username = username;
        this.password = password;
        this.connectionId = CONNECTION_ID_GENERATOR.generateId();
        this.remoteURI = transport.getRemoteLocation();
        this.serializer = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runner) {
                Thread serial = new Thread(runner);
                serial.setDaemon(true);
                serial.setName(this.toString());
                return serial;
            }
        });
        this.serializer.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.serializer.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        this.transport.setTransportListener(this);
        this.transport.setMaxFrameSize(this.getMaxFrameSize());
    }

    public void connect() throws Exception {
        if (this.connected.compareAndSet(false, true)) {
            this.transport.connect();
            ClientFuture future = new ClientFuture();
            this.serializer.execute(() -> {
                if (!this.noContainerID) {
                    ((Connection)this.getEndpoint()).setContainer(this.safeGetContainerId());
                }
                ((Connection)this.getEndpoint()).setHostname(this.remoteURI.getHost());
                if (!this.getDesiredCapabilities().isEmpty()) {
                    ((Connection)this.getEndpoint()).setDesiredCapabilities(this.getDesiredCapabilities().toArray(new Symbol[0]));
                }
                if (!this.getOfferedCapabilities().isEmpty()) {
                    ((Connection)this.getEndpoint()).setOfferedCapabilities(this.getOfferedCapabilities().toArray(new Symbol[0]));
                }
                if (!this.getOfferedProperties().isEmpty()) {
                    ((Connection)this.getEndpoint()).setProperties(this.getOfferedProperties());
                }
                if (this.getIdleTimeout() > 0) {
                    this.protonTransport.setIdleTimeout(this.getIdleTimeout());
                }
                this.protonTransport.setMaxFrameSize(this.getMaxFrameSize());
                this.protonTransport.setChannelMax(this.getChannelMax());
                this.protonTransport.setEmitFlowEventOnSend(false);
                this.protonTransport.bind((Connection)this.getEndpoint());
                Sasl sasl = this.protonTransport.sasl();
                if (sasl != null) {
                    sasl.client();
                }
                this.authenticator = new SaslAuthenticator(sasl, this.username, this.password, this.authzid, this.mechanismRestriction);
                ((TransportImpl)this.protonTransport).setProtocolTracer((ProtocolTracer)new AmqpProtocolTracer(this));
                this.open(future);
                this.pumpToProtonTransport(future);
            });
            try {
                if (this.connectTimeout <= 0L) {
                    future.sync();
                } else {
                    future.sync(this.connectTimeout, TimeUnit.MILLISECONDS);
                    if (((Connection)this.getEndpoint()).getRemoteState() != EndpointState.ACTIVE) {
                        throw new IOException("Failed to connect after configured timeout.");
                    }
                }
            }
            catch (Throwable e) {
                try {
                    this.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw e;
            }
        }
    }

    public boolean isConnected() {
        return this.transport.isConnected() && this.connected.get();
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            ClientFuture request = new ClientFuture();
            this.serializer.execute(() -> {
                try {
                    if (!this.transport.isConnected()) {
                        request.onSuccess();
                    }
                    if (this.getEndpoint() != null) {
                        this.close(request);
                    } else {
                        request.onSuccess();
                    }
                    this.pumpToProtonTransport(request);
                }
                catch (Exception e) {
                    logger.debug("Caught exception while closing proton connection");
                }
            });
            try {
                if (this.closeTimeout <= 0L) {
                    request.sync();
                } else {
                    request.sync(this.closeTimeout, TimeUnit.MILLISECONDS);
                }
            }
            catch (IOException e) {
                logger.warn("Error caught while closing Provider: ", (Object)e.getMessage());
            }
            finally {
                if (this.transport != null) {
                    try {
                        this.transport.close();
                    }
                    catch (Exception e) {
                        logger.debug("Cuaght exception while closing down Transport: {}", (Object)e.getMessage());
                    }
                }
                this.serializer.shutdownNow();
                try {
                    if (!this.serializer.awaitTermination(10L, TimeUnit.SECONDS)) {
                        logger.warn("Serializer didn't shutdown cleanly");
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public AmqpSession createSession() throws Exception {
        this.checkClosed();
        AmqpSession session = new AmqpSession(this, this.getNextSessionId());
        ClientFuture request = new ClientFuture();
        this.serializer.execute(() -> {
            this.checkClosed();
            Session protonSession = ((Connection)this.getEndpoint()).session();
            protonSession.setIncomingCapacity(this.sessionIncomingCapacity);
            session.setEndpoint(protonSession);
            session.setStateInspector(this.getStateInspector());
            session.open(request);
            this.pumpToProtonTransport(request);
        });
        request.sync();
        return session;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setAuthzid(String authzid) {
        this.authzid = authzid;
    }

    public String getAuthzid() {
        return this.authzid;
    }

    public URI getRemoteURI() {
        return this.remoteURI;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public void setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    public int getChannelMax() {
        return this.channelMax;
    }

    public void setChannelMax(int channelMax) {
        this.channelMax = channelMax;
    }

    public int getSessionIncomingCapacity() {
        return this.sessionIncomingCapacity;
    }

    public void setSessionIncomingCapacity(int capacity) {
        this.sessionIncomingCapacity = capacity;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public long getCloseTimeout() {
        return this.closeTimeout;
    }

    public void setCloseTimeout(long closeTimeout) {
        this.closeTimeout = closeTimeout;
    }

    public long getDrainTimeout() {
        return this.drainTimeout;
    }

    public void setDrainTimeout(long drainTimeout) {
        this.drainTimeout = drainTimeout;
    }

    public List<Symbol> getDesiredCapabilities() {
        return this.desiredCapabilities;
    }

    public void setDesiredCapabilities(List<Symbol> desiredCapabilities) {
        if (desiredCapabilities == null) {
            desiredCapabilities = Collections.emptyList();
        }
        this.desiredCapabilities = desiredCapabilities;
    }

    public List<Symbol> getOfferedCapabilities() {
        return this.offeredCapabilities;
    }

    public void setOfferedCapabilities(List<Symbol> offeredCapabilities) {
        if (offeredCapabilities == null) {
            offeredCapabilities = Collections.emptyList();
        }
        this.offeredCapabilities = offeredCapabilities;
    }

    public Map<Symbol, Object> getOfferedProperties() {
        return this.offeredProperties;
    }

    public void setOfferedProperties(Map<Symbol, Object> offeredProperties) {
        if (offeredProperties == null) {
            offeredProperties = Collections.emptyMap();
        }
        this.offeredProperties = offeredProperties;
    }

    public Connection getConnection() {
        return UnmodifiableProxy.connectionProxy((Connection)this.getEndpoint());
    }

    public AmqpConnectionListener getListener() {
        return this.listener;
    }

    public void setListener(AmqpConnectionListener listener) {
        this.listener = listener;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setIdleProcessingDisabled(boolean value) {
        this.idleProcessingDisabled = value;
    }

    public boolean isIdleProcessingDisabled() {
        return this.idleProcessingDisabled;
    }

    public void setMechanismRestriction(String mechanismRestriction) {
        this.mechanismRestriction = mechanismRestriction;
    }

    public String getMechanismRestriction() {
        return this.mechanismRestriction;
    }

    public boolean isTraceFrames() {
        return this.trace;
    }

    public void setTraceFrames(boolean trace) {
        this.trace = trace;
    }

    public AmqpFrameValidator getSentFrameInspector() {
        return this.sentFrameInspector;
    }

    public void setSentFrameInspector(AmqpFrameValidator amqpFrameInspector) {
        this.sentFrameInspector = amqpFrameInspector;
    }

    public AmqpFrameValidator getReceivedFrameInspector() {
        return this.receivedFrameInspector;
    }

    public void setReceivedFrameInspector(AmqpFrameValidator amqpFrameInspector) {
        this.receivedFrameInspector = amqpFrameInspector;
    }

    ScheduledExecutorService getScheduler() {
        return this.serializer;
    }

    Connection getProtonConnection() {
        return (Connection)this.getEndpoint();
    }

    String getConnectionId() {
        return this.connectionId;
    }

    AmqpTransactionId getNextTransactionId() {
        return new AmqpTransactionId(this.connectionId + ":" + this.txIdGenerator.incrementAndGet());
    }

    void pumpToProtonTransport() {
        this.pumpToProtonTransport(NOOP_REQUEST);
    }

    void pumpToProtonTransport(AsyncResult request) {
        try {
            boolean done = false;
            while (!done) {
                ByteBuffer toWrite = this.protonTransport.getOutputBuffer();
                if (toWrite != null && toWrite.hasRemaining()) {
                    ByteBuf outbound = this.transport.allocateSendBuffer(toWrite.remaining());
                    outbound.writeBytes(toWrite);
                    this.transport.sendVoidPromise(outbound);
                    this.protonTransport.outputConsumed();
                    continue;
                }
                done = true;
            }
        }
        catch (IOException e) {
            this.fireClientException(e);
            request.onFailure(e);
        }
    }

    @Override
    public void onData(ByteBuf incoming) {
        ReferenceCountUtil.retain((Object)incoming);
        this.serializer.execute(() -> {
            ByteBuffer source = incoming.nioBuffer();
            logger.trace("Client Received from Broker {} bytes:", (Object)source.remaining());
            if (this.protonTransport.isClosed()) {
                logger.debug("Ignoring incoming data because transport is closed");
                return;
            }
            do {
                ByteBuffer buffer = this.protonTransport.getInputBuffer();
                int limit = Math.min(buffer.remaining(), source.remaining());
                ByteBuffer duplicate = source.duplicate();
                duplicate.limit(source.position() + limit);
                buffer.put(duplicate);
                this.protonTransport.processInput();
                source.position(source.position() + limit);
            } while (source.hasRemaining());
            ReferenceCountUtil.release((Object)incoming);
            this.processUpdates();
            this.pumpToProtonTransport();
        });
    }

    @Override
    public void onTransportClosed() {
        logger.debug("The transport has unexpectedly closed");
        this.failed(this.getOpenAbortException());
    }

    @Override
    public void onTransportError(Throwable cause) {
        this.fireClientException(cause);
    }

    @Override
    protected void doOpenCompletion() {
        if (((Connection)this.getEndpoint()).getRemoteProperties() == null || !((Connection)this.getEndpoint()).getRemoteProperties().containsKey(AmqpSupport.CONNECTION_OPEN_FAILED)) {
            long initialNow;
            long initialKeepAliveDeadline;
            if (!this.isIdleProcessingDisabled() && (initialKeepAliveDeadline = this.protonTransport.tick(initialNow = TimeUnit.NANOSECONDS.toMillis(System.nanoTime()))) != 0L) {
                this.getScheduler().schedule(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (((Connection)AmqpConnection.this.getEndpoint()).getLocalState() != EndpointState.CLOSED) {
                                logger.debug("Client performing next idle check");
                                long now = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                                long deadline = AmqpConnection.this.protonTransport.tick(now);
                                AmqpConnection.this.pumpToProtonTransport();
                                if (AmqpConnection.this.protonTransport.isClosed()) {
                                    logger.debug("Transport closed after inactivity check.");
                                    throw new IllegalStateException("Channel was inactive for too long");
                                }
                                if (deadline != 0L) {
                                    AmqpConnection.this.getScheduler().schedule(this, deadline - now, TimeUnit.MILLISECONDS);
                                }
                            }
                        }
                        catch (Exception e) {
                            try {
                                AmqpConnection.this.transport.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            AmqpConnection.this.fireClientException(e);
                        }
                    }
                }, initialKeepAliveDeadline - initialNow, TimeUnit.MILLISECONDS);
            }
            super.doOpenCompletion();
        }
    }

    @Override
    protected void doOpenInspection() {
        try {
            this.getStateInspector().inspectOpenedResource(this.getConnection());
        }
        catch (Throwable error) {
            this.getStateInspector().markAsInvalid(error.getMessage());
        }
    }

    @Override
    protected void doClosedInspection() {
        try {
            this.getStateInspector().inspectClosedResource(this.getConnection());
        }
        catch (Throwable error) {
            this.getStateInspector().markAsInvalid(error.getMessage());
        }
    }

    protected void fireClientException(Throwable ex) {
        AmqpConnectionListener listener = this.listener;
        if (listener != null) {
            listener.onException(ex);
        }
    }

    protected void checkClosed() throws IllegalStateException {
        if (this.closed.get()) {
            throw new IllegalStateException("The Connection is already closed");
        }
    }

    private void processUpdates() {
        try {
            Event protonEvent = null;
            while ((protonEvent = this.protonCollector.peek()) != null) {
                if (!protonEvent.getType().equals((Object)Event.Type.TRANSPORT)) {
                    logger.trace("Client: New Proton Event: {}", (Object)protonEvent.getType());
                }
                AmqpEventSink amqpEventSink = null;
                switch (protonEvent.getType()) {
                    case CONNECTION_REMOTE_CLOSE: {
                        amqpEventSink = (AmqpEventSink)protonEvent.getConnection().getContext();
                        amqpEventSink.processRemoteClose(this);
                        break;
                    }
                    case CONNECTION_REMOTE_OPEN: {
                        amqpEventSink = (AmqpEventSink)protonEvent.getConnection().getContext();
                        amqpEventSink.processRemoteOpen(this);
                        break;
                    }
                    case SESSION_REMOTE_CLOSE: {
                        amqpEventSink = (AmqpEventSink)protonEvent.getSession().getContext();
                        amqpEventSink.processRemoteClose(this);
                        break;
                    }
                    case SESSION_REMOTE_OPEN: {
                        amqpEventSink = (AmqpEventSink)protonEvent.getSession().getContext();
                        amqpEventSink.processRemoteOpen(this);
                        break;
                    }
                    case LINK_REMOTE_CLOSE: {
                        amqpEventSink = (AmqpEventSink)protonEvent.getLink().getContext();
                        amqpEventSink.processRemoteClose(this);
                        break;
                    }
                    case LINK_REMOTE_DETACH: {
                        amqpEventSink = (AmqpEventSink)protonEvent.getLink().getContext();
                        amqpEventSink.processRemoteDetach(this);
                        break;
                    }
                    case LINK_REMOTE_OPEN: {
                        amqpEventSink = (AmqpEventSink)protonEvent.getLink().getContext();
                        amqpEventSink.processRemoteOpen(this);
                        break;
                    }
                    case LINK_FLOW: {
                        amqpEventSink = (AmqpEventSink)protonEvent.getLink().getContext();
                        amqpEventSink.processFlowUpdates(this);
                        break;
                    }
                    case DELIVERY: {
                        amqpEventSink = (AmqpEventSink)protonEvent.getLink().getContext();
                        amqpEventSink.processDeliveryUpdates(this, (Delivery)protonEvent.getContext());
                        break;
                    }
                }
                this.protonCollector.pop();
            }
            if (!this.authenticated) {
                this.processSaslAuthentication();
            }
        }
        catch (Exception ex) {
            logger.warn("Caught Exception during update processing: {}", (Object)ex.getMessage(), (Object)ex);
            this.fireClientException(ex);
        }
    }

    private void processSaslAuthentication() {
        if (this.authenticated || this.authenticator == null) {
            return;
        }
        try {
            if (this.authenticator.authenticate()) {
                this.authenticator = null;
                this.authenticated = true;
            }
        }
        catch (SecurityException ex) {
            this.failed(ex);
        }
    }

    private String getNextSessionId() {
        return this.connectionId + ":" + this.sessionIdGenerator.incrementAndGet();
    }

    private String safeGetContainerId() {
        String containerId = this.getContainerId();
        if (containerId == null || containerId.isEmpty()) {
            containerId = UUID.randomUUID().toString();
        }
        return containerId;
    }

    public String toString() {
        return "AmqpConnection { " + this.connectionId + " }";
    }

    public void setNoContainerID() {
        this.noContainerID = true;
    }
}

