/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.core;

import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageCredentialsAccountAndKey;
import com.microsoft.azure.storage.StorageCredentialsSharedAccessSignature;
import com.microsoft.azure.storage.StorageCredentialsToken;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.core.Base64;
import com.microsoft.azure.storage.core.Canonicalizer;
import com.microsoft.azure.storage.core.CanonicalizerFactory;
import com.microsoft.azure.storage.core.Logger;
import com.microsoft.azure.storage.core.Utility;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HttpsURLConnection;

public final class StorageCredentialsHelper {
    public static boolean canCredentialsSignRequest(StorageCredentials creds) {
        return creds.getClass().equals(StorageCredentialsAccountAndKey.class);
    }

    public static boolean canCredentialsGenerateClient(StorageCredentials creds) {
        return StorageCredentialsHelper.canCredentialsSignRequest(creds) || creds.getClass().equals(StorageCredentialsSharedAccessSignature.class) || creds.getClass().equals(StorageCredentialsToken.class);
    }

    public static synchronized String computeHmac256(StorageCredentials creds, String value) throws InvalidKeyException {
        if (creds.getClass().equals(StorageCredentialsAccountAndKey.class)) {
            byte[] utf8Bytes = null;
            try {
                utf8Bytes = value.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(e);
            }
            return Base64.encode(((StorageCredentialsAccountAndKey)creds).getHmac256().doFinal(utf8Bytes));
        }
        return null;
    }

    public static synchronized byte[] computeHmac256(byte[] data, byte[] key) throws InvalidKeyException {
        Mac hmacSha256 = null;
        try {
            hmacSha256 = Mac.getInstance("HmacSHA256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException();
        }
        hmacSha256.init(new SecretKeySpec(key, "HmacSHA256"));
        return hmacSha256.doFinal(data);
    }

    public static String signBlobQueueAndFileRequest(StorageCredentials creds, HttpURLConnection request, long contentLength, OperationContext opContext) throws InvalidKeyException, StorageException {
        String authHeaderValue = null;
        if (creds.getClass().equals(StorageCredentialsAccountAndKey.class)) {
            opContext = opContext == null ? new OperationContext() : opContext;
            request.setRequestProperty("x-ms-date", Utility.getGMTTime());
            Canonicalizer canonicalizer = CanonicalizerFactory.getBlobQueueFileCanonicalizer(request);
            String stringToSign = canonicalizer.canonicalize(request, creds.getAccountName(), contentLength);
            String computedBase64Signature = StorageCredentialsHelper.computeHmac256(creds, stringToSign);
            Logger.trace(opContext, "Signing %s", (Object)stringToSign);
            authHeaderValue = String.format("%s %s:%s", "SharedKey", creds.getAccountName(), computedBase64Signature);
            request.setRequestProperty("Authorization", authHeaderValue);
        } else if (creds.getClass().equals(StorageCredentialsToken.class)) {
            if (request instanceof HttpsURLConnection) {
                authHeaderValue = String.format("%s %s", "Bearer", ((StorageCredentialsToken)creds).getToken());
                request.setRequestProperty("Authorization", authHeaderValue);
            } else {
                throw new IllegalArgumentException("Token credential is only supported for HTTPS requests.");
            }
        }
        return authHeaderValue;
    }

    public static void signTableRequest(StorageCredentials creds, HttpURLConnection request, long contentLength, OperationContext opContext) throws InvalidKeyException, StorageException {
        if (creds.getClass().equals(StorageCredentialsAccountAndKey.class)) {
            opContext = opContext == null ? new OperationContext() : opContext;
            request.setRequestProperty("x-ms-date", Utility.getGMTTime());
            Canonicalizer canonicalizer = CanonicalizerFactory.getTableCanonicalizer(request);
            String stringToSign = canonicalizer.canonicalize(request, creds.getAccountName(), contentLength);
            String computedBase64Signature = StorageCredentialsHelper.computeHmac256(creds, stringToSign);
            Logger.trace(opContext, "Signing %s", (Object)stringToSign);
            request.setRequestProperty("Authorization", String.format("%s %s:%s", "SharedKey", creds.getAccountName(), computedBase64Signature));
        }
    }

    private StorageCredentialsHelper() {
    }
}

