/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web;

import java.util.List;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.ChildResourceDefinition;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleResourceRegistrar;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.session.SessionAttributePersistenceStrategy;
import org.wildfly.clustering.web.service.routing.RoutingProvider;
import org.wildfly.clustering.web.service.session.DistributableSessionManagementConfiguration;
import org.wildfly.clustering.web.service.session.DistributableSessionManagementProvider;
import org.wildfly.extension.clustering.web.DistributableWebExtension;
import org.wildfly.extension.clustering.web.LocalAffinityResourceDefinition;
import org.wildfly.extension.clustering.web.NoAffinityResourceDefinition;
import org.wildfly.extension.clustering.web.SessionGranularity;
import org.wildfly.extension.clustering.web.SessionMarshallerFactory;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ResourceModelResolver;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;

public abstract class SessionManagementResourceDefinition
extends ChildResourceDefinition<ManagementResourceRegistration>
implements ResourceServiceConfigurator,
ResourceModelResolver<DistributableSessionManagementConfiguration<DeploymentUnit>> {
    static final RuntimeCapability<Void> SESSION_MANAGEMENT_PROVIDER = RuntimeCapability.Builder.of((UnaryServiceDescriptor)DistributableSessionManagementProvider.SERVICE_DESCRIPTOR).addRequirements(new String[]{RoutingProvider.SERVICE_DESCRIPTOR.getName()}).setAllowMultipleRegistrations(true).build();
    private final UnaryOperator<ResourceDescriptor> configurator;

    public SessionManagementResourceDefinition(PathElement path, UnaryOperator<ResourceDescriptor> configurator) {
        super(path, (ResourceDescriptionResolver)DistributableWebExtension.SUBSYSTEM_RESOLVER.createChildResolver(path, PathElement.pathElement((String)"session-management")));
        this.configurator = configurator;
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = parent.registerSubModel((ResourceDefinition)this);
        ResourceDescriptor descriptor = ((ResourceDescriptor)this.configurator.apply(new ResourceDescriptor(this.getResourceDescriptionResolver()))).addAttributes(Attribute.class).addCapabilities(List.of(SESSION_MANAGEMENT_PROVIDER));
        ResourceServiceHandler handler = ResourceServiceHandler.of((ResourceOperationRuntimeHandler[])new ResourceOperationRuntimeHandler[]{ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this)});
        new SimpleResourceRegistrar(descriptor, handler).register(registration);
        new NoAffinityResourceDefinition().register(registration);
        new LocalAffinityResourceDefinition().register(registration);
        return registration;
    }

    public DistributableSessionManagementConfiguration<DeploymentUnit> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        final SessionGranularity granularity = SessionGranularity.valueOf(Attribute.GRANULARITY.resolveModelAttribute((ExpressionResolver)context, model).asString());
        final SessionMarshallerFactory marshallerFactory = SessionMarshallerFactory.valueOf(Attribute.MARSHALLER.resolveModelAttribute((ExpressionResolver)context, model).asString());
        return new DistributableSessionManagementConfiguration<DeploymentUnit>(){

            public SessionAttributePersistenceStrategy getAttributePersistenceStrategy() {
                return granularity.getAttributePersistenceStrategy();
            }

            public Function<DeploymentUnit, ByteBufferMarshaller> getMarshallerFactory() {
                return marshallerFactory;
            }
        };
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        GRANULARITY("granularity", ModelType.STRING, null){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setValidator((ParameterValidator)EnumValidator.create(SessionGranularity.class));
            }
        }
        ,
        MARSHALLER("marshaller", ModelType.STRING, new ModelNode(SessionMarshallerFactory.JBOSS.name())){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setValidator((ParameterValidator)EnumValidator.create(SessionMarshallerFactory.class));
            }
        };

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, ModelNode defaultValue) {
            this.definition = ((SimpleAttributeDefinitionBuilder)this.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(defaultValue == null)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}))).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

