/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.opentelemetry;

import java.util.List;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.weld.WeldCapability;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;

class OpenTelemetryDependencyProcessor
implements DeploymentUnitProcessor {
    private static final String API_MODULE = "org.wildfly.extension.opentelemetry-api";
    private static final List<String> EXPORTED_MODULES = List.of("io.opentelemetry.api", "io.opentelemetry.api.events", "io.opentelemetry.context", "io.opentelemetry.exporter", "io.opentelemetry.instrumentation.api", "io.opentelemetry.otlp", "io.opentelemetry.sdk", "io.opentelemetry.semconv", "io.smallrye.opentelemetry");

    OpenTelemetryDependencyProcessor() {
    }

    public void deploy(DeploymentPhaseContext phaseContext) {
        this.addDependencies(phaseContext.getDeploymentUnit());
    }

    private void addDependencies(DeploymentUnit deploymentUnit) {
        try {
            ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
            ModuleLoader moduleLoader = Module.getBootModuleLoader();
            WeldCapability weldCapability = (WeldCapability)((CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT)).getCapabilityRuntimeAPI("org.wildfly.weld", WeldCapability.class);
            if (weldCapability.isPartOfWeldDeployment(deploymentUnit)) {
                moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, API_MODULE, false, true, true, false));
            }
            for (String module : EXPORTED_MODULES) {
                moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, module, false, true, true, false));
            }
        }
        catch (CapabilityServiceSupport.NoSuchCapabilityException e) {
            throw new IllegalStateException();
        }
    }
}

