/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.parsing;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.parsing.WriteUtils;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class DeploymentsXml {
    DeploymentsXml() {
    }

    void parseDeployments(XMLExtendedStreamReader reader, ModelNode address, String expectedNs, List<ModelNode> list, Set<Attribute> allowedAttributes, Set<Element> allowedElements, boolean validateUniqueRuntimeNames) throws XMLStreamException {
        HashSet<String> runtimeNames;
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        HashSet<String> names = new HashSet<String>();
        HashSet<String> hashSet = runtimeNames = validateUniqueRuntimeNames ? new HashSet<String>() : null;
        while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (String)expectedNs);
            Element deployment = Element.forName((String)reader.getLocalName());
            if (Element.DEPLOYMENT != deployment) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ModelNode deploymentAdd = Util.getEmptyOperation((String)"add", null);
            String uniqueName = null;
            String runtimeName = null;
            boolean enabled = false;
            EnumSet<Attribute> requiredAttributes = EnumSet.of(Attribute.NAME, Attribute.RUNTIME_NAME);
            int count = reader.getAttributeCount();
            block11: for (int i = 0; i < count; ++i) {
                String value = reader.getAttributeValue(i);
                if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
                if (!allowedAttributes.contains(attribute)) {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                requiredAttributes.remove(attribute);
                switch (attribute) {
                    case NAME: {
                        if (!names.add(value)) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)value);
                        }
                        uniqueName = value;
                        continue block11;
                    }
                    case RUNTIME_NAME: {
                        DeploymentAttributes.RUNTIME_NAME.parseAndSetParameter(value, deploymentAdd, (XMLStreamReader)reader);
                        runtimeName = value;
                        continue block11;
                    }
                    case ENABLED: {
                        DeploymentAttributes.ENABLED.parseAndSetParameter(value, deploymentAdd, (XMLStreamReader)reader);
                        enabled = deploymentAdd.get(DeploymentAttributes.ENABLED.getName()).asBoolean(false);
                        continue block11;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (!requiredAttributes.isEmpty()) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
            }
            if (validateUniqueRuntimeNames && enabled && runtimeName != null && !runtimeNames.add(runtimeName)) {
                throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, runtimeName);
            }
            ModelNode deploymentAddress = address.clone().add("deployment", uniqueName);
            deploymentAdd.get("address").set(deploymentAddress);
            if (allowedAttributes.contains(Attribute.ENABLED) && !deploymentAdd.hasDefined(DeploymentAttributes.ENABLED.getName())) {
                deploymentAdd.get(DeploymentAttributes.ENABLED.getName()).set(true);
            }
            block12: while (reader.hasNext() && reader.nextTag() != 2) {
                ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (String)expectedNs);
                Element element = Element.forName((String)reader.getLocalName());
                if (!allowedElements.contains(element)) {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                switch (element) {
                    case CONTENT: {
                        this.parseContentType(reader, deploymentAdd);
                        continue block12;
                    }
                    case FS_ARCHIVE: {
                        this.parseFSBaseType(reader, deploymentAdd, true);
                        continue block12;
                    }
                    case FS_EXPLODED: {
                        this.parseFSBaseType(reader, deploymentAdd, false);
                        continue block12;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            list.add(deploymentAdd);
        }
    }

    private void parseContentType(XMLExtendedStreamReader reader, ModelNode parent) throws XMLStreamException {
        ModelNode content = parent.get("content").add();
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            String value = reader.getAttributeValue(i);
            switch (attribute) {
                case SHA1: {
                    try {
                        content.get("hash").set(HashUtil.hexStringToByteArray((String)value));
                        continue block6;
                    }
                    catch (Exception e) {
                        throw ControllerLogger.ROOT_LOGGER.invalidSha1Value((Throwable)e, value, attribute.getLocalName(), reader.getLocation());
                    }
                }
                case ARCHIVE: {
                    DeploymentAttributes.CONTENT_ARCHIVE.getParser().parseAndSetParameter((AttributeDefinition)DeploymentAttributes.CONTENT_ARCHIVE, value, content, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseFSBaseType(XMLExtendedStreamReader reader, ModelNode parent, boolean isArchive) throws XMLStreamException {
        ModelNode content = parent.get("content").add();
        content.get("archive").set(isArchive);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            String value = reader.getAttributeValue(i);
            switch (attribute) {
                case PATH: {
                    content.get("path").set(value);
                    continue block4;
                }
                case RELATIVE_TO: {
                    content.get("relative-to").set(value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    static void writeContentItem(XMLExtendedStreamWriter writer, ModelNode contentItem) throws XMLStreamException {
        if (contentItem.has("hash")) {
            WriteUtils.writeElement((XMLExtendedStreamWriter)writer, (Element)Element.CONTENT);
            WriteUtils.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.SHA1, (String)HashUtil.bytesToHexString((byte[])contentItem.require("hash").asBytes()));
            DeploymentAttributes.CONTENT_ARCHIVE.getMarshaller().marshallAsAttribute((AttributeDefinition)DeploymentAttributes.CONTENT_ARCHIVE, contentItem, true, (XMLStreamWriter)writer);
            writer.writeEndElement();
        } else {
            if (contentItem.require("archive").asBoolean()) {
                WriteUtils.writeElement((XMLExtendedStreamWriter)writer, (Element)Element.FS_ARCHIVE);
            } else {
                WriteUtils.writeElement((XMLExtendedStreamWriter)writer, (Element)Element.FS_EXPLODED);
            }
            WriteUtils.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.PATH, (String)contentItem.require("path").asString());
            if (contentItem.has("relative-to")) {
                WriteUtils.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.RELATIVE_TO, (String)contentItem.require("relative-to").asString());
            }
            writer.writeEndElement();
        }
    }
}

