/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.extension;

import io.smallrye.mutiny.Multi;
import io.smallrye.reactive.messaging.ChannelRegistry;
import io.smallrye.reactive.messaging.PausableChannelConfiguration;
import io.smallrye.reactive.messaging.PublisherDecorator;
import io.smallrye.reactive.messaging.SubscriberDecorator;
import io.smallrye.reactive.messaging.providers.helpers.PausableMulti;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.reactive.messaging.Message;

@ApplicationScoped
public class PausableChannelDecorator
implements PublisherDecorator,
SubscriberDecorator {
    @Inject
    ChannelRegistry registry;
    private final Map<String, PausableChannelConfiguration> configurations = new HashMap<String, PausableChannelConfiguration>();

    public Multi<? extends Message<?>> decorate(Multi<? extends Message<?>> publisher, List<String> channelName, boolean isConnector) {
        String channel = channelName.get(0);
        if (isConnector && this.configurations.containsKey(channel)) {
            PausableChannelConfiguration configuration = this.configurations.get(channel);
            PausableMulti pausable = new PausableMulti(publisher, configuration.initiallyPaused());
            for (String name : channelName) {
                this.registry.register(name, pausable);
            }
            return pausable;
        }
        return publisher;
    }

    public int getPriority() {
        return super.getPriority();
    }

    public void addConfiguration(PausableChannelConfiguration configuration) {
        this.configurations.put(configuration.name(), configuration);
    }
}

