/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.common.util;

import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.BeanManager;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.cdi.common.util.Types;

public class Reflections {
    public static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Type[] EMPTY_TYPES = new Type[0];

    public static <T> T cast(Object obj) {
        return (T)obj;
    }

    public static Set<Method> getAllDeclaredMethods(Class<?> clazz) {
        HashSet<Method> methods = new HashSet<Method>();
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            Collections.addAll(methods, c.getDeclaredMethods());
        }
        return methods;
    }

    private static String buildInvokeMethodErrorMessage(Method method, Object obj, Object ... args) {
        StringBuilder message = new StringBuilder(String.format("Exception invoking method [%s] on object [%s], using arguments [", method.getName(), obj));
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                message.append(i > 0 ? "," : "").append(args[i]);
            }
        }
        message.append("]");
        return message.toString();
    }

    public static Object invokeMethod(boolean setAccessible, Method method, Object instance, Object ... args) {
        return Reflections.invokeMethod(setAccessible, method, Object.class, instance, args);
    }

    public static <T> T invokeMethod(boolean setAccessible, Method method, Class<T> expectedReturnType, Object instance, Object ... args) {
        if (setAccessible && !method.isAccessible()) {
            method.setAccessible(true);
        }
        try {
            return expectedReturnType.cast(method.invoke(instance, args));
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(Reflections.buildInvokeMethodErrorMessage(method, instance, args), ex);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(Reflections.buildInvokeMethodErrorMessage(method, instance, args), ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(Reflections.buildInvokeMethodErrorMessage(method, instance, args), ex.getCause());
        }
        catch (NullPointerException ex) {
            NullPointerException ex2 = new NullPointerException(Reflections.buildInvokeMethodErrorMessage(method, instance, args));
            ex2.initCause(ex.getCause());
            throw ex2;
        }
        catch (ExceptionInInitializerError e) {
            ExceptionInInitializerError e2 = new ExceptionInInitializerError(Reflections.buildInvokeMethodErrorMessage(method, instance, args));
            e2.initCause(e.getCause());
            throw e2;
        }
    }

    public static <T> Class<T> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType() instanceof Class) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return null;
    }

    public static boolean isSerializable(Class<?> clazz) {
        return clazz.isPrimitive() || Serializable.class.isAssignableFrom(clazz);
    }

    public static boolean isAssignableFrom(Class<?> rawType1, Type[] actualTypeArguments1, Class<?> rawType2, Type[] actualTypeArguments2) {
        return Types.boxedClass(rawType1).isAssignableFrom(Types.boxedClass(rawType2)) && Reflections.isAssignableFrom(actualTypeArguments1, actualTypeArguments2);
    }

    public static boolean matches(Class<?> rawType1, Type[] actualTypeArguments1, Class<?> rawType2, Type[] actualTypeArguments2) {
        return Types.boxedClass(rawType1) == Types.boxedClass(rawType2) && Reflections.isAssignableFrom(actualTypeArguments1, actualTypeArguments2);
    }

    public static boolean isAssignableFrom(Type[] actualTypeArguments1, Type[] actualTypeArguments2) {
        for (int i = 0; i < actualTypeArguments1.length; ++i) {
            Type type1 = actualTypeArguments1[i];
            Object type2 = Object.class;
            if (actualTypeArguments2.length > i) {
                type2 = actualTypeArguments2[i];
            }
            if (Reflections.isAssignableFrom(type1, type2)) continue;
            return false;
        }
        return true;
    }

    public static boolean matches(Type type1, Set<? extends Type> types2) {
        for (Type type : types2) {
            if (!Reflections.matches(type1, type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableFrom(Type type1, Type[] types2) {
        for (Type type2 : types2) {
            if (!Reflections.isAssignableFrom(type1, type2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableFrom(Type type1, Type type2) {
        TypeVariable typeVariable;
        WildcardType wildcardType;
        ParameterizedType parameterizedType1;
        Class clazz;
        if (type1 instanceof Class && Reflections.isAssignableFrom(clazz = (Class)type1, EMPTY_TYPES, type2)) {
            return true;
        }
        if (type1 instanceof ParameterizedType && (parameterizedType1 = (ParameterizedType)type1).getRawType() instanceof Class && Reflections.isAssignableFrom((Class)parameterizedType1.getRawType(), parameterizedType1.getActualTypeArguments(), type2)) {
            return true;
        }
        if (type1 instanceof WildcardType && Reflections.isTypeBounded(type2, (wildcardType = (WildcardType)type1).getLowerBounds(), wildcardType.getUpperBounds())) {
            return true;
        }
        if (type2 instanceof WildcardType && Reflections.isTypeBounded(type1, (wildcardType = (WildcardType)type2).getUpperBounds(), wildcardType.getLowerBounds())) {
            return true;
        }
        if (type1 instanceof TypeVariable && Reflections.isTypeBounded(type2, EMPTY_TYPES, (typeVariable = (TypeVariable)type1).getBounds())) {
            return true;
        }
        return type2 instanceof TypeVariable && Reflections.isTypeBounded(type1, (typeVariable = (TypeVariable)type2).getBounds(), EMPTY_TYPES);
    }

    public static boolean matches(Type type1, Type type2) {
        TypeVariable typeVariable;
        WildcardType wildcardType;
        ParameterizedType parameterizedType1;
        Class clazz;
        if (type1 instanceof Class && Reflections.matches(clazz = (Class)type1, EMPTY_TYPES, type2)) {
            return true;
        }
        if (type1 instanceof ParameterizedType && (parameterizedType1 = (ParameterizedType)type1).getRawType() instanceof Class && Reflections.matches((Class)parameterizedType1.getRawType(), parameterizedType1.getActualTypeArguments(), type2)) {
            return true;
        }
        if (type1 instanceof WildcardType && Reflections.isTypeBounded(type2, (wildcardType = (WildcardType)type1).getLowerBounds(), wildcardType.getUpperBounds())) {
            return true;
        }
        if (type2 instanceof WildcardType && Reflections.isTypeBounded(type1, (wildcardType = (WildcardType)type2).getUpperBounds(), wildcardType.getLowerBounds())) {
            return true;
        }
        if (type1 instanceof TypeVariable && Reflections.isTypeBounded(type2, EMPTY_TYPES, (typeVariable = (TypeVariable)type1).getBounds())) {
            return true;
        }
        return type2 instanceof TypeVariable && Reflections.isTypeBounded(type1, (typeVariable = (TypeVariable)type2).getBounds(), EMPTY_TYPES);
    }

    public static boolean isTypeBounded(Type type, Type[] lowerBounds, Type[] upperBounds) {
        if (lowerBounds.length > 0 && !Reflections.isAssignableFrom(type, lowerBounds)) {
            return false;
        }
        return upperBounds.length <= 0 || Reflections.isAssignableFrom(upperBounds, type);
    }

    public static boolean isAssignableFrom(Class<?> rawType1, Type[] actualTypeArguments1, Type type2) {
        TypeVariable typeVariable;
        Class clazz;
        ParameterizedType parameterizedType;
        return type2 instanceof ParameterizedType ? (parameterizedType = (ParameterizedType)type2).getRawType() instanceof Class && Reflections.isAssignableFrom(rawType1, actualTypeArguments1, (Class)parameterizedType.getRawType(), parameterizedType.getActualTypeArguments()) : (type2 instanceof Class ? Reflections.isAssignableFrom(rawType1, actualTypeArguments1, clazz = (Class)type2, EMPTY_TYPES) : type2 instanceof TypeVariable && Reflections.isTypeBounded(rawType1, actualTypeArguments1, (typeVariable = (TypeVariable)type2).getBounds()));
    }

    public static boolean matches(Class<?> rawType1, Type[] actualTypeArguments1, Type type2) {
        if (type2 instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type2;
            if (parameterizedType.getRawType() instanceof Class) {
                return Reflections.matches(rawType1, actualTypeArguments1, (Class)parameterizedType.getRawType(), parameterizedType.getActualTypeArguments());
            }
        } else if (type2 instanceof Class) {
            Class clazz = (Class)type2;
            return Reflections.matches(rawType1, actualTypeArguments1, clazz, EMPTY_TYPES);
        }
        return false;
    }

    public static boolean matches(Set<Type> types1, Set<Type> types2) {
        for (Type type : types1) {
            if (!Reflections.matches(type, types2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableFrom(Type[] types1, Type type2) {
        for (Type type : types1) {
            if (!Reflections.isAssignableFrom(type, type2)) continue;
            return true;
        }
        return false;
    }

    private Reflections() {
    }

    public static <A extends Annotation> A getMetaAnnotation(Annotated element, Class<A> annotationType) {
        for (Annotation annotation : element.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(annotationType)) continue;
            return annotation.annotationType().getAnnotation(annotationType);
        }
        return null;
    }

    public static Set<Annotation> getQualifiers(BeanManager beanManager, Iterable<Annotation> annotations) {
        return Reflections.getQualifiers(beanManager, new Iterable[]{annotations});
    }

    public static Set<Annotation> getQualifiers(BeanManager beanManager, Iterable<Annotation> ... annotations) {
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        for (Iterable<Annotation> annotationSet : annotations) {
            for (Annotation annotation : annotationSet) {
                if (!beanManager.isQualifier(annotation.annotationType())) continue;
                qualifiers.add(annotation);
            }
        }
        return qualifiers;
    }

    public static Set<Field> getAllDeclaredFields(Class<?> clazz) {
        HashSet<Field> fields = new HashSet<Field>();
        for (Class<?> c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
            Collections.addAll(fields, c.getDeclaredFields());
        }
        return fields;
    }
}

