/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl.toJavaPortable;

import com.sun.tools.corba.se.idl.AttributeEntry;
import com.sun.tools.corba.se.idl.GenFileStream;
import com.sun.tools.corba.se.idl.InterfaceEntry;
import com.sun.tools.corba.se.idl.MethodEntry;
import com.sun.tools.corba.se.idl.SymtabEntry;
import com.sun.tools.corba.se.idl.toJavaPortable.Arguments;
import com.sun.tools.corba.se.idl.toJavaPortable.AuxGen;
import com.sun.tools.corba.se.idl.toJavaPortable.Compile;
import com.sun.tools.corba.se.idl.toJavaPortable.MethodGen;
import com.sun.tools.corba.se.idl.toJavaPortable.Util;
import java.io.File;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Stub
implements AuxGen {
    protected Hashtable symbolTable = null;
    protected InterfaceEntry i = null;
    protected PrintWriter stream = null;
    protected Vector methodList = null;
    protected String classSuffix = "";
    protected boolean localStub = false;
    private boolean isAbstract = false;

    @Override
    public void generate(Hashtable symbolTable, SymtabEntry entry) {
        this.symbolTable = symbolTable;
        this.i = (InterfaceEntry)entry;
        this.localStub = this.i.isLocalServant();
        this.isAbstract = this.i.isAbstract();
        this.init();
        this.openStream();
        if (this.stream == null) {
            return;
        }
        this.writeHeading();
        this.writeBody();
        this.writeClosing();
        this.closeStream();
    }

    protected void init() {
        this.classSuffix = "Stub";
    }

    protected void openStream() {
        String name = "_" + this.i.name() + this.classSuffix;
        String pkg = Util.containerFullName(this.i.container());
        if (pkg != null && !pkg.equals("")) {
            Util.mkdir(pkg);
            name = pkg + "/" + name;
        }
        this.stream = Util.getStream(name.replace('/', File.separatorChar) + ".java", this.i);
    }

    protected void writeHeading() {
        Util.writePackage(this.stream, this.i, (short)1);
        Util.writeProlog(this.stream, ((GenFileStream)this.stream).name());
        if (this.i.comment() != null) {
            this.i.comment().generate("", this.stream);
        }
        this.writeClassDeclaration();
        this.stream.println('{');
    }

    protected void writeClassDeclaration() {
        this.stream.print("public class _" + this.i.name() + this.classSuffix + " extends org.omg.CORBA.portable.ObjectImpl");
        this.stream.println(" implements " + Util.javaName(this.i));
    }

    protected void writeBody() {
        this.writeCtors();
        this.buildMethodList();
        this.writeMethods();
        this.writeCORBAObjectMethods();
        this.writeSerializationMethods();
    }

    protected void writeClosing() {
        this.stream.println("} // class _" + this.i.name() + this.classSuffix);
    }

    protected void closeStream() {
        this.stream.close();
    }

    protected void writeCtors() {
        String name = this.i.name();
        if (this.localStub) {
            this.stream.println("  final public static java.lang.Class _opsClass = " + name + "Operations.class;");
            this.stream.println();
        }
        this.stream.println();
    }

    protected void buildMethodList() {
        this.methodList = new Vector();
        this.buildMethodList(this.i);
    }

    private void buildMethodList(InterfaceEntry entry) {
        Enumeration locals = entry.methods().elements();
        while (locals.hasMoreElements()) {
            this.addMethod((MethodEntry)locals.nextElement());
        }
        Enumeration parents = entry.derivedFrom().elements();
        while (parents.hasMoreElements()) {
            InterfaceEntry parent = (InterfaceEntry)parents.nextElement();
            if (parent.name().equals("Object")) continue;
            this.buildMethodList(parent);
        }
    }

    private void addMethod(MethodEntry method) {
        if (!this.methodList.contains(method)) {
            this.methodList.addElement(method);
        }
    }

    protected void writeMethods() {
        int count = this.methodList.size();
        Enumeration e = this.methodList.elements();
        while (e.hasMoreElements()) {
            Object method = e.nextElement();
            if (!(method instanceof AttributeEntry) || ((AttributeEntry)method).readOnly()) continue;
            ++count;
        }
        if (((Arguments)Compile.compiler.arguments).LocalOptimization && !this.isAbstract) {
            this.stream.println("    final public static java.lang.Class _opsClass =");
            this.stream.println("        " + this.i.name() + "Operations.class;");
        }
        int realI = 0;
        for (int i = 0; i < this.methodList.size(); ++i) {
            MethodEntry method = (MethodEntry)this.methodList.elementAt(i);
            if (!this.localStub) {
                ((MethodGen)method.generator()).stub(this.i.name(), this.isAbstract, this.symbolTable, method, this.stream, realI);
            } else {
                ((MethodGen)method.generator()).localstub(this.symbolTable, method, this.stream, realI, this.i);
            }
            if (method instanceof AttributeEntry && !((AttributeEntry)method).readOnly()) {
                realI += 2;
                continue;
            }
            ++realI;
        }
    }

    private void buildIDList(InterfaceEntry entry, Vector list) {
        if (!entry.fullName().equals("org/omg/CORBA/Object")) {
            String id = Util.stripLeadingUnderscoresFromID(entry.repositoryID().ID());
            if (!list.contains(id)) {
                list.addElement(id);
            }
            Enumeration e = entry.derivedFrom().elements();
            while (e.hasMoreElements()) {
                this.buildIDList((InterfaceEntry)e.nextElement(), list);
            }
        }
    }

    private void writeIDs() {
        Vector list = new Vector();
        this.buildIDList(this.i, list);
        Enumeration e = list.elements();
        boolean first = true;
        while (e.hasMoreElements()) {
            if (first) {
                first = false;
            } else {
                this.stream.println(", ");
            }
            this.stream.print("    \"" + (String)e.nextElement() + "\"");
        }
    }

    protected void writeCORBAObjectMethods() {
        this.stream.println("  // Type-specific CORBA::Object operations");
        this.stream.println("  private static String[] __ids = {");
        this.writeIDs();
        this.stream.println("};");
        this.stream.println();
        this.stream.println("  public String[] _ids ()");
        this.stream.println("  {");
        this.stream.println("    return (String[])__ids.clone ();");
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeSerializationMethods() {
        this.stream.println("  private void readObject (java.io.ObjectInputStream s) throws java.io.IOException");
        this.stream.println("  {");
        this.stream.println("     String str = s.readUTF ();");
        this.stream.println("     String[] args = null;");
        this.stream.println("     java.util.Properties props = null;");
        this.stream.println("     org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init (args, props);");
        this.stream.println("   try {");
        this.stream.println("     org.omg.CORBA.Object obj = orb.string_to_object (str);");
        this.stream.println("     org.omg.CORBA.portable.Delegate delegate = ((org.omg.CORBA.portable.ObjectImpl) obj)._get_delegate ();");
        this.stream.println("     _set_delegate (delegate);");
        this.stream.println("   } finally {");
        this.stream.println("     orb.destroy() ;");
        this.stream.println("   }");
        this.stream.println("  }");
        this.stream.println();
        this.stream.println("  private void writeObject (java.io.ObjectOutputStream s) throws java.io.IOException");
        this.stream.println("  {");
        this.stream.println("     String[] args = null;");
        this.stream.println("     java.util.Properties props = null;");
        this.stream.println("     org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init (args, props);");
        this.stream.println("   try {");
        this.stream.println("     String str = orb.object_to_string (this);");
        this.stream.println("     s.writeUTF (str);");
        this.stream.println("   } finally {");
        this.stream.println("     orb.destroy() ;");
        this.stream.println("   }");
        this.stream.println("  }");
    }
}

