/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jsf.deployment;

import java.util.ArrayList;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.jsf.deployment.JSFModuleIdFactory;
import org.jboss.as.jsf.deployment.JsfVersionMarker;
import org.jboss.as.jsf.logging.JSFLogger;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.PathFilters;

public class JSFDependencyProcessor
implements DeploymentUnitProcessor {
    public static final String IS_CDI_PARAM = "org.jboss.jbossfaces.IS_CDI";
    private static final String JSF_SUBSYSTEM = "org.jboss.as.jsf";
    private static final String JAVAX_FACES_EVENT_NAMEDEVENT_class = "/jakarta.faces.event.NamedEvent".replaceAll("\\.", "/") + ".class";
    private JSFModuleIdFactory moduleIdFactory = JSFModuleIdFactory.getInstance();

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentUnit tl = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        String jsfVersion = JsfVersionMarker.getVersion(tl).equals("NONE") ? JSFModuleIdFactory.getInstance().getDefaultSlot() : JsfVersionMarker.getVersion(tl);
        String defaultJsfVersion = JSFModuleIdFactory.getInstance().getDefaultSlot();
        if (JsfVersionMarker.isJsfDisabled(deploymentUnit)) {
            if (jsfVersion.equals(defaultJsfVersion) && !this.moduleIdFactory.isValidJSFSlot(jsfVersion)) {
                throw JSFLogger.ROOT_LOGGER.invalidDefaultJSFImpl(defaultJsfVersion);
            }
            this.addJSFAPI("Mojarra-4.0", moduleSpecification, moduleLoader);
            return;
        }
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit) && !DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        if (jsfVersion.equals("WAR_BUNDLES_JSF_IMPL")) {
            return;
        }
        if (!this.moduleIdFactory.isValidJSFSlot(jsfVersion)) {
            JSFLogger.ROOT_LOGGER.unknownJSFVersion(jsfVersion, defaultJsfVersion);
            jsfVersion = defaultJsfVersion;
        }
        if (jsfVersion.equals(defaultJsfVersion) && !this.moduleIdFactory.isValidJSFSlot(jsfVersion)) {
            throw JSFLogger.ROOT_LOGGER.invalidDefaultJSFImpl(defaultJsfVersion);
        }
        this.addJSFAPI(jsfVersion, moduleSpecification, moduleLoader);
        this.addJSFImpl(jsfVersion, moduleSpecification, moduleLoader);
        moduleSpecification.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)JSF_SUBSYSTEM).setImportServices(true).build());
        this.addJSFInjection(jsfVersion, moduleSpecification, moduleLoader);
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData != null) {
            this.addCDIFlag(warMetaData, deploymentUnit);
        }
    }

    private void addJSFAPI(String jsfVersion, ModuleSpecification moduleSpecification, ModuleLoader moduleLoader) {
        if (jsfVersion.equals("WAR_BUNDLES_JSF_IMPL")) {
            return;
        }
        String jsfModule = this.moduleIdFactory.getApiModId(jsfVersion);
        ModuleDependency jsfAPI = ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)jsfModule).build();
        moduleSpecification.addSystemDependency(jsfAPI);
    }

    private void addJSFImpl(String jsfVersion, ModuleSpecification moduleSpecification, ModuleLoader moduleLoader) {
        if (jsfVersion.equals("WAR_BUNDLES_JSF_IMPL")) {
            return;
        }
        String jsfModule = this.moduleIdFactory.getImplModId(jsfVersion);
        ModuleDependency jsfImpl = ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)jsfModule).setImportServices(true).build();
        jsfImpl.addImportFilter(PathFilters.getMetaInfFilter(), true);
        moduleSpecification.addSystemDependency(jsfImpl);
    }

    private void addJSFInjection(String jsfVersion, ModuleSpecification moduleSpecification, ModuleLoader moduleLoader) throws DeploymentUnitProcessingException {
        if (jsfVersion.equals("WAR_BUNDLES_JSF_IMPL")) {
            return;
        }
        String jsfInjectionModule = this.moduleIdFactory.getInjectionModId(jsfVersion);
        ModuleDependency jsfInjectionDependency = ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)jsfInjectionModule).setExport(true).setImportServices(true).build();
        try {
            if (this.isJSF12(jsfInjectionDependency, jsfInjectionModule.toString())) {
                JSFLogger.ROOT_LOGGER.loadingJsf12();
                jsfInjectionDependency.addImportFilter(PathFilters.is((String)"META-INF/faces-config.xml"), false);
                jsfInjectionDependency.addImportFilter(PathFilters.is((String)"META-INF/1.2/faces-config.xml"), true);
            } else {
                JSFLogger.ROOT_LOGGER.loadingJsf2x();
                jsfInjectionDependency.addImportFilter(PathFilters.getMetaInfFilter(), true);
                jsfInjectionDependency.addImportFilter(PathFilters.is((String)"META-INF/1.2/faces-config.xml"), false);
            }
        }
        catch (ModuleLoadException e) {
            throw JSFLogger.ROOT_LOGGER.jsfInjectionFailed(jsfVersion, e);
        }
        moduleSpecification.addSystemDependency(jsfInjectionDependency);
    }

    private boolean isJSF12(ModuleDependency moduleDependency, String identifier) throws ModuleLoadException {
        return moduleDependency.getModuleLoader().loadModule(identifier).getClassLoader().getResource(JAVAX_FACES_EVENT_NAMEDEVENT_class) == null;
    }

    private void addCDIFlag(WarMetaData warMetaData, DeploymentUnit deploymentUnit) {
        ArrayList<ParamValueMetaData> contextParams;
        JBossWebMetaData webMetaData = warMetaData.getMergedJBossWebMetaData();
        if (webMetaData == null) {
            webMetaData = new JBossWebMetaData();
            warMetaData.setMergedJBossWebMetaData(webMetaData);
        }
        if ((contextParams = webMetaData.getContextParams()) == null) {
            contextParams = new ArrayList<ParamValueMetaData>();
        }
        ParamValueMetaData param = new ParamValueMetaData();
        param.setParamName(IS_CDI_PARAM);
        param.setParamValue("true");
        contextParams.add(param);
        webMetaData.setContextParams(contextParams);
    }
}

